/*
 * Decompiled with CFR 0.152.
 */
package command;

import basicinfo.Goodbye;
import command.CommandInfo;
import command.Definite;
import command.ReadAux;
import io.InFileDominatrix;
import io.IoInfo;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import lexicon.LocalLoop;
import print.Parameters;
import revise.OneTask;

public class BasicCommands
extends CommandInfo {
    private static String begin = "NO_BEGIN_COMMENT_FOUND";
    private static String end = "NO_END_COMMENT_FOUND";

    public static boolean Store(String commando, InFileDominatrix infile) {
        if (BasicCommands.Fundamentals(commando, infile)) {
            return true;
        }
        if (BasicCommands.Basics(commando, infile)) {
            return true;
        }
        if (BasicCommands.CorpusSpecs(commando, infile)) {
            return true;
        }
        if (BasicCommands.PrintSpecs(commando, infile)) {
            return true;
        }
        if (BasicCommands.ReviseSpecs(commando, infile)) {
            return true;
        }
        if (BasicCommands.LexStuff(commando, infile)) {
            return true;
        }
        BasicCommands.CodingQueryError(commando, infile);
        return false;
    }

    public static boolean Fundamentals(String commando, InFileDominatrix infile) {
        if (commando.startsWith("query:")) {
            CommandInfo.orig_query = CommandInfo.query = ReadAux.Get_Query(commando, infile);
            return true;
        }
        if (commando.startsWith("begin_remark:")) {
            ReadAux.Get_Remark(commando, infile);
            return true;
        }
        if (commando.startsWith("node:")) {
            CommandInfo.node = ReadAux.Get_String(commando, infile);
            return true;
        }
        if (commando.startsWith("define:")) {
            CommandInfo.def_name = ReadAux.Get_String(commando, infile);
            CommandInfo.use_def_file = true;
            Definite.MakeDefVector(CommandInfo.def_name);
            return true;
        }
        if (commando.startsWith("local_frames:")) {
            CommandInfo.do_frames = true;
            CommandInfo.orig_query = CommandInfo.query = ReadAux.Get_Query(commando, infile);
            return true;
        }
        if (commando.startsWith("coding_query:")) {
            CommandInfo.orig_coding_query = CommandInfo.coding_query = ReadAux.Get_Query(commando, infile);
            CommandInfo.do_coding = true;
            return true;
        }
        return false;
    }

    public static boolean LexStuff(String commando, InFileDominatrix infile) {
        if (commando.startsWith("make_lexicon:")) {
            CommandInfo.make_lexicon = ReadAux.Get_boolean(commando, infile);
            return true;
        }
        if (commando.startsWith("pos_labels:")) {
            LocalLoop.SetPosLabels(ReadAux.Get_String(commando, infile));
            return true;
        }
        if (commando.startsWith("text_labels:")) {
            LocalLoop.SetTextLabels(ReadAux.Get_String(commando, infile));
            return true;
        }
        return false;
    }

    public static boolean CorpusSpecs(String commando, InFileDominatrix infile) {
        if (commando.startsWith("corpus_file_extension:")) {
            return true;
        }
        if (commando.startsWith("corpus_comment_begin:")) {
            begin = ReadAux.Get_String(commando, infile);
            return true;
        }
        if (commando.startsWith("corpus_comment_end:")) {
            end = ReadAux.Get_String(commando, infile);
            IoInfo.commie.addCommPair(begin, end);
            return true;
        }
        if (commando.startsWith("corpus_line_comment:")) {
            begin = ReadAux.Get_String(commando, infile);
            IoInfo.linie.addLineComm(begin);
            return true;
        }
        return false;
    }

    public static boolean PrintSpecs(String commando, InFileDominatrix infile) {
        if (commando.startsWith("set_margin:")) {
            Parameters.margin = ReadAux.Get_int(commando, infile);
            return true;
        }
        if (commando.startsWith("nodes_only:")) {
            Parameters.nodes_only = ReadAux.Get_boolean(commando, infile);
            if (!Parameters.nodes_only) {
                Parameters.remove_nodes = false;
            }
            return true;
        }
        if (commando.startsWith("remove_nodes:")) {
            Parameters.remove_nodes = ReadAux.Get_boolean(commando, infile);
            return true;
        }
        if (commando.startsWith("print_indices:")) {
            Parameters.print_indices = ReadAux.Get_boolean(commando, infile);
            return true;
        }
        if (commando.startsWith("print_complement:")) {
            CommandInfo.print_complement = ReadAux.Get_boolean(commando, infile);
            return true;
        }
        if (commando.startsWith("copy_corpus:")) {
            CommandInfo.copy_corpus = ReadAux.Get_boolean(commando, infile);
            Parameters.print_indices = false;
            return true;
        }
        if (commando.startsWith("reformat_corpus:")) {
            CommandInfo.reformat_corpus = ReadAux.Get_boolean(commando, infile);
            Parameters.print_indices = false;
            return true;
        }
        if (commando.startsWith("print_only:")) {
            CommandInfo.lonely = ReadAux.Get_String(commando, infile);
            CommandInfo.print_only = true;
            return true;
        }
        if (commando.startsWith("multi_output:")) {
            CommandInfo.multi_output = ReadAux.Get_boolean(commando, infile);
            return true;
        }
        return false;
    }

    public static boolean ReviseSpecs(String commando, InFileDominatrix infile) {
        if (commando.startsWith("replace_label") || commando.startsWith("append_label") || commando.startsWith("prepend_label") || commando.startsWith("post_crop_label") || commando.startsWith("pre_crop_label") || commando.startsWith("add_leaf") || commando.startsWith("move_up_node") || commando.startsWith("delete") || commando.startsWith("add_internal_node")) {
            CommandInfo.revise = true;
            OneTask one = new OneTask(commando + infile.RestOfLine());
            CommandInfo.tasker.addTask(one);
            return true;
        }
        return false;
    }

    public static boolean Basics(String commando, InFileDominatrix infile) {
        if (commando.startsWith("ignore_nodes:")) {
            CommandInfo.ignore = ReadAux.Get_String(commando, infile);
            if (CommandInfo.ignore.equals("null")) {
                CommandInfo.ignore = "";
            }
            return true;
        }
        if (commando.startsWith("add_to_ignore:")) {
            CommandInfo.ignore = CommandInfo.ignore + "|" + ReadAux.Get_String(commando, infile);
            return true;
        }
        if (commando.startsWith("ignore_words:")) {
            CommandInfo.word_ignore = ReadAux.Get_String(commando, infile);
            if (CommandInfo.word_ignore.equals("null")) {
                CommandInfo.word_ignore = "";
            }
            return true;
        }
        if (commando.startsWith("add_to_ignore_words:")) {
            CommandInfo.word_ignore = CommandInfo.word_ignore + "|" + ReadAux.Get_String(commando, infile);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void CommandNotFoundError(String commando, InFileDominatrix infile) {
        try {
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                String response = "";
                System.err.println("ERROR! command not recognized:  " + commando);
                System.err.print("Search aborted because of error ");
                System.err.println("in command file.");
                System.err.println("");
            }
            catch (Exception e) {
                System.err.println("In BasicCommands.CommandNotFoundError:  ");
                System.err.println(e.getMessage());
                Goodbye.SearchExit();
                return;
            }
        }
        catch (Throwable throwable) {
            Goodbye.SearchExit();
            return;
        }
        Goodbye.SearchExit();
    }

    public static void CodingQueryError(String commando, InFileDominatrix infile) {
        Character charlie = new Character('Q');
        int i = 0;
        while (i < commando.length() - 1) {
            if (!Character.isDigit(commando.charAt(i))) {
                return;
            }
            ++i;
        }
        System.err.println("ERROR!  Coding queries must now begin with this line:");
        System.err.println("    coding_query:    ");
        System.err.println("Search aborted.");
        Goodbye.SearchExit();
    }
}

