/*
 * Decompiled with CFR 0.152.
 */
package convert;

import java.util.Vector;
import syntree.Node;
import syntree.SynTree;

public class MatrixToVector {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Vector MtoV(SynTree spare) {
        Integer zero = new Integer(0);
        Vector<Integer> sub_vec = new Vector<Integer>();
        Vector sent_vec = new Vector();
        try {
            try {
                sub_vec.addElement(zero);
                sent_vec = MatrixToVector.RecurseDaughters(spare, sent_vec, zero);
                sent_vec.insertElementAt(sub_vec, 0);
                return sent_vec;
            }
            catch (RuntimeException e) {
                System.err.println("Came to grief in MatrixToVector.");
                System.err.println(e.getMessage());
                e.printStackTrace();
                System.exit(1);
                return sent_vec;
            }
        }
        catch (Throwable throwable) {
            return sent_vec;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Vector RecurseDaughters(SynTree spare, Vector sent_vec, Integer mother_dex) {
        Vector sub_vec = new Vector();
        try {
            try {
                if (sub_vec.isEmpty()) {
                    String label = spare.LabelAt((int)mother_dex);
                    if (spare.IsLeafPOS(mother_dex)) {
                        sub_vec = MatrixToVector.LeafStuff(spare, mother_dex);
                        sent_vec.addElement(sub_vec);
                    } else {
                        Vector<Object> sub_sub_vec = new Vector<Object>();
                        sub_sub_vec.addElement(mother_dex);
                        sub_sub_vec.addElement(label);
                        sub_vec.addElement(sub_sub_vec);
                        sent_vec.addElement(sub_vec);
                    }
                }
                if (!spare.IsLeafPOS(mother_dex)) {
                    Vector daughters = spare.GetDaughters(mother_dex);
                    int n = 0;
                    while (n < daughters.size()) {
                        Vector one_daughter = (Vector)daughters.elementAt(n);
                        Integer start_dex = (Integer)one_daughter.elementAt(0);
                        if (!spare.IsLeafPOS(start_dex)) {
                            MatrixToVector.RecurseDaughters(spare, sent_vec, start_dex);
                        } else {
                            sub_vec = MatrixToVector.LeafStuff(spare, start_dex);
                            sent_vec.addElement(sub_vec);
                            Integer closures = MatrixToVector.NumClosures(spare, start_dex);
                            int j = 0;
                            while (j < closures) {
                                if (sent_vec.size() > 1) {
                                    ((Vector)sent_vec.elementAt(sent_vec.size() - 2)).addElement((Vector)sent_vec.elementAt(sent_vec.size() - 1));
                                    sent_vec.removeElementAt(sent_vec.size() - 1);
                                }
                                ++j;
                            }
                        }
                        ++n;
                    }
                }
                if (mother_dex != 0) return sent_vec;
                Vector sisters = spare.GetSisters(mother_dex);
                if (sisters.size() == 2) {
                    Vector<Object> sub_sister = new Vector<Object>();
                    Vector<Vector<Object>> leaf_vec = new Vector<Vector<Object>>();
                    Vector sis_1 = (Vector)sisters.elementAt(0);
                    Vector sis_2 = (Vector)sisters.elementAt(1);
                    sub_sister.addElement((Integer)sis_2.elementAt(0));
                    sub_sister.addElement((String)sis_1.elementAt(1));
                    sub_sister.addElement((String)sis_2.elementAt(1));
                    leaf_vec.addElement(sub_sister);
                    sent_vec.addElement(leaf_vec);
                }
                if (sisters.size() <= 2) return sent_vec;
                System.err.println("WARNING! extra sisters:  " + sisters);
                return sent_vec;
            }
            catch (Exception e) {
                System.err.println("Came to grief in RecurseDaughters.");
                e.printStackTrace();
                System.err.println(e.getMessage());
                return sent_vec;
            }
        }
        catch (Throwable throwable) {
            return sent_vec;
        }
    }

    public static Integer NumClosures(SynTree spare, Integer start_dex) {
        int close_int = 0;
        Integer orig_end_dex = spare.EndDexAt((int)start_dex);
        int n = 0;
        while (n < spare.size()) {
            Integer end_dex = spare.EndDexAt(n);
            if (end_dex.intValue() == orig_end_dex.intValue() && !spare.IsLeafPOS(n)) {
                ++close_int;
            }
            ++n;
        }
        Integer num_close = new Integer(close_int);
        return num_close;
    }

    public static Vector LeafStuff(SynTree spare, Integer start_dex) {
        Vector leaf_vec = new Vector();
        Vector<Object> sub_leaf = new Vector<Object>();
        String pos = spare.LabelAt(start_dex);
        Node leaf_node = spare.NodeAt(start_dex + 1);
        Integer leaf_dex = leaf_node.getIndex();
        String leaf_text = leaf_node.getLabel();
        sub_leaf.addElement(leaf_dex);
        sub_leaf.addElement(pos);
        sub_leaf.addElement(leaf_text);
        leaf_vec.addElement(sub_leaf);
        return leaf_vec;
    }
}

