/*
 * Decompiled with CFR 0.152.
 */
package frames;

import frames.Kernel;
import frames.SingleFrame;
import java.util.Random;
import java.util.Vector;

public class SameKernelBucket {
    private Vector list_o_frames = new Vector();

    public void addSingleFrame(SingleFrame framed) {
        this.list_o_frames.addElement(framed);
    }

    public int size() {
        return this.list_o_frames.size();
    }

    public Vector getList() {
        return this.list_o_frames;
    }

    public Kernel getSynKernel() {
        SingleFrame framed = this.getFrame(0);
        return framed.getSynKernel();
    }

    public SingleFrame getFrame(int dex) {
        return (SingleFrame)this.list_o_frames.elementAt(dex);
    }

    public void PrintToSystemErr() {
        int i = 0;
        while (i < this.list_o_frames.size()) {
            SingleFrame framed = (SingleFrame)this.list_o_frames.elementAt(i);
            framed.PrintToSystemErr();
            ++i;
        }
    }

    public void Sort() {
        this.QuickSortLaterFrame(0, this.size() - 1);
    }

    private void QuickSortLaterFrame(int lower, int upper) {
        Random chance = new Random();
        if (upper > lower) {
            int random_dex = chance.nextInt(upper - lower);
            int index = lower + random_dex;
            int pivot_loc = this.SplitLaterFrame(lower, upper, index);
            this.QuickSortLaterFrame(lower, pivot_loc - 1);
            this.QuickSortLaterFrame(pivot_loc + 1, upper);
        }
    }

    private int SplitLaterFrame(int lower, int upper, int pivot_loc) {
        SingleFrame frame1 = this.getFrame(pivot_loc);
        this.Swap(this.list_o_frames, lower, pivot_loc);
        pivot_loc = lower;
        int i = lower + 1;
        while (i <= upper) {
            SingleFrame frame2 = this.getFrame(i);
            if (frame1.LaterFrame(frame2)) {
                this.Swap(this.list_o_frames, ++pivot_loc, i);
            }
            ++i;
        }
        this.Swap(this.list_o_frames, lower, pivot_loc);
        return pivot_loc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void Swap(Vector host, int one_dex, int other_dex) {
        try {
            try {
                SingleFrame temp = (SingleFrame)host.elementAt(one_dex);
                host.setElementAt((SingleFrame)host.elementAt(other_dex), one_dex);
                host.setElementAt(temp, other_dex);
                return;
            }
            catch (Exception e) {
                System.err.println("in SameKernelBucket.Swap:  ");
                System.err.println(e.getMessage());
                return;
            }
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public SameKernelBucket() {
    }

    public SameKernelBucket(SingleFrame framed) {
        this.addSingleFrame(framed);
    }
}

