/*
 * Decompiled with CFR 0.152.
 */
package lexicon;

import basicinfo.Matcher;
import lexicon.LocalLoop;
import lexicon.POSPair;
import lexicon.SentenceList;
import syntree.Node;

public class BuildLex
extends LocalLoop {
    public static boolean IgnoreIt(Node nodal) {
        int i = 0;
        while (i < LocalLoop.ignore_for_lex.size()) {
            String nore;
            String ig = (String)LocalLoop.ignore_for_lex.elementAt(i);
            if (Matcher.StarMatch(ig, nore = nodal.getLabel())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean GoodPos(Node nodal) {
        int i = 0;
        while (i < LocalLoop.pos_list.size()) {
            String lab;
            String pos = (String)LocalLoop.pos_list.elementAt(i);
            if (Matcher.StarMatch(pos, lab = nodal.getLabel())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean GoodText(Node nodal) {
        int i = 0;
        while (i < LocalLoop.text_list.size()) {
            String lab;
            String text = (String)LocalLoop.text_list.elementAt(i);
            if (Matcher.StarMatch(text, lab = nodal.getLabel())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean GoodLeaf(Node pos_node, Node text_node) {
        if (BuildLex.IgnoreIt(pos_node)) {
            return false;
        }
        if (BuildLex.IgnoreIt(text_node)) {
            return false;
        }
        if (LocalLoop.use_pos_list && !BuildLex.GoodPos(pos_node)) {
            return false;
        }
        return !LocalLoop.use_text_list || BuildLex.GoodText(text_node);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SentenceList OneSentence() {
        SentenceList per_sentence = new SentenceList();
        try {
            try {
                int n = 0;
                while (n < LocalLoop.sparse.size()) {
                    Node text_node;
                    Node curr_node = LocalLoop.sparse.NodeAt(n);
                    if (LocalLoop.sparse.IsLeafPOS(curr_node) && BuildLex.GoodLeaf(curr_node, text_node = LocalLoop.sparse.FirstDaughter(curr_node))) {
                        POSPair paris = new POSPair(curr_node, text_node);
                        per_sentence.addPOSPair(paris);
                    }
                    ++n;
                }
                return per_sentence;
            }
            catch (Exception e) {
                System.err.println("in BuildLex:  ");
                System.err.println(e.getMessage());
                e.printStackTrace();
                return per_sentence;
            }
        }
        catch (Throwable throwable) {
            return per_sentence;
        }
    }
}

