/*
 * Decompiled with CFR 0.152.
 */
package lexicon;

import java.util.Vector;
import lexicon.NumPOS;
import lexicon.POSPair;
import lexicon.POSStat;

public class LexEntry {
    private String canonical;
    private Vector variations;
    private Vector pos_stats;
    private int total;

    public boolean belongs(POSPair paris) {
        String text = paris.GetTextStr();
        if (text.startsWith("$")) {
            text = text.substring(1, text.length());
        }
        return text.equalsIgnoreCase(this.canonical);
    }

    public void addPOSPair(POSPair paris) {
        String text = paris.GetTextStr();
        int i = 0;
        while (i < this.variations.size()) {
            if (text.equals((String)this.variations.elementAt(i))) break;
            if (i == this.variations.size() - 1) {
                this.variations.addElement(text);
                break;
            }
            ++i;
        }
        String pos = paris.GetPOSStr();
        i = 0;
        while (i < this.pos_stats.size()) {
            POSStat old_stat = (POSStat)this.pos_stats.elementAt(i);
            String old_pos = old_stat.getString();
            if (old_pos.equals(pos)) {
                old_stat.incrementTotal();
                break;
            }
            if (i == this.pos_stats.size() - 1) {
                POSStat new_stat = new POSStat(pos);
                this.pos_stats.addElement(new_stat);
                break;
            }
            ++i;
        }
        ++this.total;
    }

    public void setCanonical(String canon) {
        this.canonical = canon.toLowerCase();
    }

    public String getCanonical() {
        return this.canonical;
    }

    public Vector getVariations() {
        return this.variations;
    }

    public void addToVariations(String var) {
        this.variations.addElement(var);
    }

    public void addToPOSStats(NumPOS numb) {
        this.pos_stats.addElement(numb);
    }

    public Vector getPOSStats() {
        return this.pos_stats;
    }

    public void incrementTotal() {
        ++this.total;
    }

    public int getTotal() {
        return this.total;
    }

    public boolean LaterEntry(LexEntry lurk) {
        return this.canonical.compareTo(lurk.getCanonical()) > 0;
    }

    public void PrintToSystemErr() {
        System.err.println("LexEntry:  ");
        System.err.println("canonical:  " + this.canonical);
        System.err.println("variations:  " + this.variations);
        System.err.println("pos_stats:  ");
        int i = 0;
        while (i < this.pos_stats.size()) {
            POSStat numb = (POSStat)this.pos_stats.elementAt(i);
            numb.PrintToSystemErr();
            ++i;
        }
        System.err.println("total:  " + this.total);
    }

    public LexEntry() {
        this.variations = new Vector();
        this.pos_stats = new Vector();
        this.total = 0;
    }

    public LexEntry(String canon) {
        this.canonical = canon;
        this.variations = new Vector();
        this.pos_stats = new Vector();
        this.total = 0;
    }

    public LexEntry(POSPair paris) {
        try {
            this.pos_stats = new Vector();
            this.variations = new Vector();
            this.canonical = paris.GetTextStr().toLowerCase();
            this.variations.addElement(this.canonical);
            if (this.canonical.startsWith("$")) {
                this.canonical = this.canonical.substring(1, this.canonical.length());
            }
            POSStat poss = new POSStat(paris.GetPOSStr());
            this.pos_stats.addElement(poss);
            ++this.total;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

