/*
 * Decompiled with CFR 0.152.
 */
package lexicon;

import syntree.Node;

public class POSPair {
    private Node POS_node;
    private Node text_node;

    public Node GetPOSNode() {
        return this.POS_node;
    }

    public Node GetTextNode() {
        return this.text_node;
    }

    public String GetPOSStr() {
        return this.POS_node.getLabel();
    }

    public String GetTextStr() {
        return this.text_node.getLabel();
    }

    public boolean SameText(POSPair other) {
        String this_text = this.GetPOSStr();
        String other_text = other.GetPOSStr();
        if (this_text.startsWith("$")) {
            this_text = this_text.substring(1, this_text.length());
        }
        if (other_text.startsWith("$")) {
            other_text = other_text.substring(1, other_text.length());
        }
        return this_text.equalsIgnoreCase(other_text);
    }

    public int getASCIInum() {
        Character charlie = new Character('Q');
        String text_str = this.GetTextStr();
        int init = text_str.charAt(0);
        if (init == 36 || init == 43) {
            init = text_str.charAt(1);
        }
        int num = init = Character.toUpperCase((char)init);
        if ((num -= 64) < 1 || num > 26) {
            num = 0;
        }
        return num;
    }

    public void PrintToSystemErr() {
        System.err.println("POSPair:  ");
        this.POS_node.PrintToSystemErr();
        this.text_node.PrintToSystemErr();
    }

    public POSPair() {
    }

    public POSPair(Node pos, Node text) {
        this.POS_node = pos;
        this.text_node = text;
    }
}

