/*
 * Decompiled with CFR 0.152.
 */
package print;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Vector;
import print.Parameters;
import print.Remove;
import search_result.SentenceResult;
import search_result.SubResult;
import syntree.Node;
import syntree.SynTree;

public class PrintTree
extends Parameters {
    protected static boolean previous_leaf = false;
    protected static Vector bound_list = new Vector();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void PhraseVec(SynTree sparse, int indent, PrintWriter out_file, int sparse_dex) {
        String label = "";
        try {
            try {
                Node one_item = sparse.NodeAt(sparse_dex);
                label = one_item.getLabel();
                int next_dent = indent;
                next_dent += 1 + label.length() + 1;
                if (previous_leaf) {
                    PrintTree.IndentIt(indent, out_file);
                    previous_leaf = false;
                }
                out_file.print("(");
                next_dent = PrintTree.HandleIndices(one_item, out_file, next_dent);
                out_file.print(label + " ");
                Vector daughters = sparse.GetDaughters(sparse_dex);
                boolean just_leaves = PrintTree.HasJustLeaves(sparse, daughters);
                int j = 0;
                while (true) {
                    if (j >= daughters.size()) {
                        out_file.print(")");
                        return;
                    }
                    Node daughter = (Node)daughters.elementAt(j);
                    Integer daughter_dex = daughter.getIndex();
                    if (!sparse.IsLeafPOS(daughter_dex)) {
                        PrintTree.PhraseVec(sparse, next_dent, out_file, daughter_dex);
                    } else {
                        if (j > 0 && !just_leaves) {
                            PrintTree.IndentIt(next_dent, out_file);
                        }
                        PrintTree.PrintLeafNode(sparse, out_file, daughter);
                        if (just_leaves && j < daughters.size() - 1) {
                            out_file.print(" ");
                        }
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("in PrintTree:  sparse_dex:  " + sparse_dex);
                sparse.PrintToSystemErr();
                return;
            }
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public static void Nodes(SynTree sparse, SentenceResult OneResult, PrintWriter out_file) {
        sparse.setConstantNodes();
        PrintTree.subNodes(sparse, 0, OneResult, out_file);
        bound_list.removeAllElements();
    }

    protected static void subNodes(SynTree sparse, int sparse_dex, SentenceResult sent_res, PrintWriter out_file) {
        Node res_bound;
        SubResult sub_res;
        Node one_item = sparse.NodeAt(sparse_dex);
        int i = 0;
        while (i < sent_res.size()) {
            sub_res = sent_res.subResultAt(i);
            res_bound = sub_res.getBoundary();
            if (res_bound.equals(one_item) && PrintTree.notDupe(res_bound)) {
                previous_leaf = false;
                if (res_bound.equals(sparse.METAROOT)) {
                    PrintTree.PhraseVec(sparse, 0, out_file, sparse_dex);
                    out_file.println("");
                    return;
                }
                out_file.print("( ");
                PrintTree.PrintCODINGNode(sparse, res_bound, "( ", out_file);
                PrintTree.PhraseVec(sparse, 2, out_file, sparse_dex);
                PrintTree.PrintIDStuff(sparse, out_file);
            }
            ++i;
        }
        Vector daughters = sparse.GetDaughters(sparse_dex);
        int j = 0;
        while (j < daughters.size()) {
            Node daughter = (Node)daughters.elementAt(j);
            int daughter_dex = daughter.getIndex_int();
            if (!sparse.IsLeafPOS(daughter)) {
                PrintTree.subNodes(sparse, daughter_dex, sent_res, out_file);
            } else {
                i = 0;
                while (i < sent_res.size()) {
                    sub_res = sent_res.subResultAt(i);
                    res_bound = sub_res.getBoundary();
                    if (res_bound.equals(daughter) && PrintTree.notDupe(res_bound)) {
                        PrintTree.PrintLeafTree(sparse, out_file, daughter);
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    protected static boolean HasJustLeaves(SynTree sparse, Vector daughters) {
        int j = 0;
        while (j < daughters.size()) {
            Node daughter = (Node)daughters.elementAt(j);
            if (!sparse.IsLeafPOS(daughter)) {
                return false;
            }
            previous_leaf = true;
            Node leaf_node = sparse.FirstDaughter(daughter);
            String leaf = leaf_node.getLabel();
            if (leaf.startsWith("*") || leaf.startsWith("RMV")) {
                return false;
            }
            ++j;
        }
        return true;
    }

    protected static void PrintLeafTree(SynTree sparse, PrintWriter out_file, Node daughter) {
        out_file.println("");
        out_file.print("( ");
        PrintTree.PrintLeafNode(sparse, out_file, daughter);
        PrintTree.PrintIDNode(sparse, out_file);
        out_file.println(" )");
    }

    protected static void PrintCODINGNode(SynTree sparse, Node bound, String prev, PrintWriter out_file) {
        Node code = PrintTree.GetAssocNode(sparse, bound, "CODING");
        if (!code.IsNullNode()) {
            PrintTree.PrintLeafNode(sparse, out_file, code);
            PrintTree.IndentIt(prev.length(), out_file);
        }
    }

    protected static Node GetAssocNode(SynTree sparse, Node current, String to_match) {
        int dex = current.getIndex_int();
        Node ancestor = current;
        while (!ancestor.IsNullNode()) {
            Node daughter = sparse.FirstDaughter(ancestor = sparse.GetMother(ancestor));
            if (!daughter.getLabel().equals(to_match)) continue;
            return daughter;
        }
        return new Node("NULL");
    }

    protected static void PrintIDNode(SynTree sparse, PrintWriter out_file) {
        if (!sparse.ID_POS.IsNullNode()) {
            PrintTree.PrintLeafNode(sparse, out_file, sparse.ID_POS);
        }
    }

    protected static void PrintLeafNode(SynTree sparse, PrintWriter out_file, Node leafPOS) {
        out_file.print("(");
        if (Parameters.print_indices) {
            Integer index = leafPOS.getIndex();
            out_file.print(index + " ");
        }
        Node leafText = sparse.FirstDaughter(leafPOS);
        out_file.print(leafPOS.getLabel() + " ");
        out_file.print(leafText.getLabel());
        out_file.print(")");
    }

    public static void Sentence(SynTree sparse, PrintWriter out_file) {
        PrintTree.PhraseVec(sparse, 0, out_file, 0);
        out_file.println("");
    }

    protected static int HandleIndices(Node one_item, PrintWriter out_file, int next_dent) {
        if (Parameters.print_indices) {
            Integer index = one_item.getIndex();
            String str_dex = Integer.toString(index);
            next_dent += str_dex.length() + 1;
            out_file.print(str_dex + " ");
        }
        return next_dent;
    }

    protected static void PrintIDStuff(SynTree sparse, PrintWriter out_file) {
        out_file.println("");
        out_file.print("  ");
        PrintTree.PrintIDNode(sparse, out_file);
        out_file.println(") ");
        out_file.println("");
    }

    protected static void IndentIt(int indent, PrintWriter out_file) {
        out_file.println("");
        int j = 0;
        while (j < indent / 8) {
            out_file.print("\t");
            ++j;
        }
        j = 0;
        while (j < indent % 8) {
            out_file.print(" ");
            ++j;
        }
    }

    protected static boolean notDupe(Node res_bound) {
        int m = 0;
        while (m < bound_list.size()) {
            Node a_bound = (Node)bound_list.elementAt(m);
            if (a_bound.equals(res_bound)) {
                return false;
            }
            ++m;
        }
        bound_list.addElement(res_bound);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        SynTree sparse = new SynTree("EXAMPLE");
        try {
            try {
                FileWriter out = new FileWriter("print_test.out");
                PrintWriter outfile = new PrintWriter(new BufferedWriter(out));
                PrintTree.Sentence(sparse, outfile);
                outfile.flush();
                System.err.print("look for printed test sentence in ");
                System.err.println("print_test.out.");
                return;
            }
            catch (Exception e) {
                System.err.println("ERROR! bug in PrintTree.main.");
                e.printStackTrace();
                return;
            }
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public static void PrintToken(SynTree sparse, SentenceResult one_result, PrintWriter out_file) {
        if (!Parameters.nodes_only) {
            PrintTree.Sentence(sparse, out_file);
            return;
        }
        if (!Parameters.remove_nodes) {
            PrintTree.Nodes(sparse, one_result, out_file);
            return;
        }
        Remove.Nodes(sparse, one_result, out_file);
    }
}

