/*
 * Decompiled with CFR 0.152.
 */
package search;

import basicinfo.Matcher;
import basicinfo.PipeList;
import basicinfo.Vitals;
import java.util.Vector;
import syntree.Node;
import syntree.SynTree;

public class Syntax {
    public static boolean ignoreIt(SynTree sparse, Node nodal) {
        Node leaf;
        String label = nodal.getLabel();
        if (PipeList.IsOnList(label, Vitals.ignore_list)) {
            return true;
        }
        return sparse.IsLeafPOS(nodal) && PipeList.IsOnList(label = (leaf = sparse.FirstDaughter(nodal)).getLabel(), Vitals.ignore_list);
    }

    public static boolean IsOnList(SynTree sparse, Node nodal, Vector List2) {
        String label = nodal.getLabel();
        int r = 0;
        while (r < List2.size()) {
            String list_item = (String)List2.elementAt(r);
            if (list_item.equals("$ROOT") && nodal.equals(sparse.ROOT)) {
                return true;
            }
            if (list_item.equals("$METAROOT") && nodal.equals(sparse.METAROOT)) {
                return true;
            }
            if (Syntax.ignoreIt(sparse, nodal)) {
                return false;
            }
            if (Matcher.StarMatch(list_item, label)) {
                return true;
            }
            ++r;
        }
        return false;
    }

    public static boolean IsBoundary(SynTree sparse, Node nodal) {
        String label = nodal.getLabel();
        int r = 0;
        while (r < Vitals.Node_List.size()) {
            String one_bound = (String)Vitals.Node_List.elementAt(r);
            if (Matcher.StarMatch(one_bound, label)) {
                return true;
            }
            if (one_bound.equals("$ROOT") && nodal.equals(sparse.ROOT)) {
                return true;
            }
            if (one_bound.equals("$METAROOT") && nodal.equals(sparse.METAROOT)) {
                return true;
            }
            ++r;
        }
        return false;
    }

    public static Vector GetText(SynTree sparse, Node nodal) {
        Vector<String> texts = new Vector<String>();
        Vector descendants = sparse.GetDescendants(nodal);
        int n = 0;
        while (n < descendants.size()) {
            Node heir = (Node)descendants.elementAt(n);
            if (sparse.IsLeafText(heir)) {
                texts.addElement(heir.getLabel());
            }
            ++n;
        }
        return texts;
    }

    public static Vector GetTextNodes(SynTree sparse, Node nodal) {
        Vector<Node> text_nodes = new Vector<Node>();
        Vector descendants = sparse.GetDescendants(nodal);
        int n = 0;
        while (n < descendants.size()) {
            Node heir = (Node)descendants.elementAt(n);
            if (sparse.IsLeafText(heir)) {
                text_nodes.addElement(heir);
            }
            ++n;
        }
        return text_nodes;
    }

    public static Node GetBoundaryNode(SynTree sparse, Node x_node) {
        Node forebear;
        if (Syntax.IsBoundary(sparse, x_node)) {
            return x_node;
        }
        Vector ancestors = sparse.GetAncestors(x_node);
        int i = 0;
        while (i < ancestors.size()) {
            forebear = (Node)ancestors.elementAt(i);
            if (Syntax.IsBoundary(sparse, forebear)) {
                return forebear;
            }
            ++i;
        }
        forebear = new Node("NULL");
        return forebear;
    }

    public static Node GetBoundaryNode(SynTree sparse, Node x_node, Node y_node) {
        Node forebear;
        Node everymom = sparse.GetCommonAncestor(x_node, y_node);
        if (Syntax.IsBoundary(sparse, everymom)) {
            return everymom;
        }
        Vector ancestors = sparse.GetAncestors(everymom);
        int i = 0;
        while (i < ancestors.size()) {
            forebear = (Node)ancestors.elementAt(i);
            if (Syntax.IsBoundary(sparse, forebear)) {
                return forebear;
            }
            ++i;
        }
        forebear = new Node("NULL");
        return forebear;
    }
}

