/*
 * Decompiled with CFR 0.152.
 */
package stats;

import java.io.PrintWriter;
import java.util.Vector;
import stats.StatsPerFile;

public class StatsPerSearch {
    private int hits = 0;
    private int tokens = 0;
    private int total = 0;
    private String command_name;
    private String dest_name;
    private Vector file_stats = new Vector();

    public void file_statsAdd(StatsPerFile stato) {
        this.hits += stato.getHits();
        this.tokens += stato.getTokens();
        this.total += stato.getTotal();
        this.file_stats.addElement(stato);
    }

    public StatsPerFile getStatsPerFile(int x) {
        return (StatsPerFile)this.file_stats.elementAt(x);
    }

    public int size() {
        return this.file_stats.size();
    }

    public void hitsAdd(int x) {
        this.hits += x;
    }

    public void tokensAdd1() {
        ++this.tokens;
    }

    public void totalAdd1() {
        ++this.total;
    }

    public int getHits() {
        return this.hits;
    }

    public int getTokens() {
        return this.tokens;
    }

    public int getTotal() {
        return this.total;
    }

    public void setCommandName(String name) {
        this.command_name = name;
    }

    public void setDestName(String name) {
        this.dest_name = name;
    }

    public String getCommandName() {
        return this.command_name;
    }

    public String getDestName() {
        return this.dest_name;
    }

    public void PrintToPrintWriter(PrintWriter outer) {
        String tabs_before_stats = "\t";
        outer.println("source files, hits/tokens/total");
        int i = 0;
        while (i < this.size()) {
            tabs_before_stats = "\t";
            StatsPerFile file_info = this.getStatsPerFile(i);
            String file_name = file_info.getFileID();
            outer.print("  " + file_name);
            if (file_name.length() < 6) {
                tabs_before_stats = tabs_before_stats + "\t";
            }
            if (file_name.length() < 14) {
                tabs_before_stats = tabs_before_stats + "\t";
            }
            outer.print(tabs_before_stats);
            outer.print(file_info.getHits() + "/");
            outer.print(file_info.getTokens() + "/");
            outer.println(file_info.getTotal());
            ++i;
        }
        outer.println("whole search, hits/tokens/total");
        outer.print(tabs_before_stats);
        outer.print("\t" + this.getHits() + "/");
        outer.print(this.getTokens() + "/");
        outer.println(this.getTotal());
    }

    public StatsPerSearch() {
    }

    public StatsPerSearch(String command_name, String dest_name) {
        this.setCommandName(command_name);
        this.setDestName(dest_name);
    }
}

