/*
 * Decompiled with CFR 0.152.
 */
package syntree;

import java.util.Vector;
import syntree.Node;
import syntree.SynTree;

public class ChangeTree
extends SynTree {
    Vector index_changes;
    Integer minus1 = new Integer(-1);

    public void setConstantNodes() {
        super.setConstantNodes();
    }

    private void changesInit(int siz) {
        this.index_changes = new Vector();
        int i = 0;
        while (i < siz) {
            Integer dex = new Integer(i);
            this.index_changes.addElement(dex);
            ++i;
        }
    }

    private void update(int old_dex, int how_much) {
        Integer old_update = (Integer)this.index_changes.elementAt(old_dex);
        Integer new_Int = new Integer(old_update + how_much);
        this.index_changes.setElementAt(new_Int, old_dex);
        super.setConstantNodes();
    }

    public int getUpdate(int old) {
        Integer old_Int = (Integer)this.index_changes.elementAt(old);
        return old_Int;
    }

    public int getUpdate(Integer old) {
        Integer old_Int = (Integer)this.index_changes.elementAt(old);
        return old_Int;
    }

    public Node NodeAt(Integer dex) {
        return super.NodeAt(dex);
    }

    public Node NodeAt(int dex) {
        return super.NodeAt(dex);
    }

    public boolean AddInternalNode(String new_label, int start, int finish) {
        int up_finish = this.getUpdate(finish);
        up_finish = super.EndDexAt(up_finish);
        int up_start = this.getUpdate(start);
        if (!this.isLegalInternalNode(up_start, up_finish)) {
            return false;
        }
        this.ShiftPreEnds(up_start, up_finish, 1);
        this.ShiftRight(up_start, 1);
        int i = start;
        while (i < this.index_changes.size()) {
            this.update(i, 1);
            ++i;
        }
        super.SetLabelAt(new_label, up_start);
        super.SetEndDexAt(up_finish + 1, up_start);
        return true;
    }

    public boolean isLegalInternalNode(int start, int finish) {
        int end;
        int i = 0;
        while (i < start) {
            end = super.EndDexAt(i);
            if (start <= end && end < finish) {
                return false;
            }
            ++i;
        }
        i = start;
        while (i < finish) {
            end = super.EndDexAt(i);
            if (end > finish) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean InsertLeafAfter(String pos_label, String text_label, int new_dex) {
        int start_dex = new_dex;
        int end_dex = super.EndDexAt(start_dex);
        try {
            try {
                int up_start_dex = this.getUpdate(start_dex);
                int up_end_dex = super.EndDexAt(up_start_dex);
                this.ShiftPreEnds(up_start_dex, up_end_dex, 2);
                this.ShiftRight(up_end_dex + 1, 2);
                int i = end_dex + 1;
                while (true) {
                    if (i >= this.index_changes.size()) {
                        super.SetLabelAt(pos_label, up_end_dex + 1);
                        super.SetEndDexAt(up_end_dex + 2, up_end_dex + 1);
                        super.SetLabelAt(text_label, up_end_dex + 2);
                        super.SetEndDexAt(up_end_dex + 2, up_end_dex + 2);
                        return true;
                    }
                    this.update(i, 2);
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean InsertLeaf(String pos_label, String text_label, int new_dex) {
        try {
            try {
                int up_new_dex = this.getUpdate(new_dex);
                this.ShiftPreEnds(up_new_dex, up_new_dex, 2);
                this.ShiftRight(up_new_dex, 2);
                int i = new_dex;
                while (true) {
                    if (i >= this.index_changes.size()) {
                        super.SetLabelAt(pos_label, up_new_dex);
                        super.SetEndDexAt(up_new_dex + 1, up_new_dex);
                        super.SetLabelAt(text_label, up_new_dex + 1);
                        super.SetEndDexAt(up_new_dex + 1, up_new_dex + 1);
                        return true;
                    }
                    this.update(i, 2);
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean DeleteInNode(int dex_to_delete) {
        try {
            try {
                int up_delete = this.getUpdate(dex_to_delete);
                if (super.IsLeafText(up_delete)) return true;
                if (super.IsLeafPOS(up_delete)) {
                    return true;
                }
                this.ShiftPreEnds(up_delete, up_delete, -1);
                super.DeleteNode(up_delete);
                this.ShiftFollowEnds(up_delete, -1);
                int i = dex_to_delete;
                while (i < this.index_changes.size()) {
                    this.update(i, -1);
                    ++i;
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean DeleteSubtree(int dex_to_delete) {
        try {
            try {
                Node mom;
                int up_delete = this.getUpdate(dex_to_delete);
                if (super.IsLeafText(up_delete)) return true;
                if (super.IsLeafPOS(up_delete)) {
                    return true;
                }
                Node child = super.NodeAt(up_delete);
                if (this.isFirstChild(child, mom = this.GetMother(up_delete)) && this.isLastChild(child, mom)) {
                    return true;
                }
                int move_end = super.EndDexAt(up_delete);
                int num_nodes = move_end - up_delete + 1;
                this.ShiftPreEnds(up_delete, up_delete, -num_nodes);
                int i = 0;
                while (true) {
                    if (i >= num_nodes) break;
                    super.DeleteNode(up_delete);
                    ++i;
                }
                this.ShiftFollowEnds(up_delete, -num_nodes);
                i = dex_to_delete;
                while (i < this.index_changes.size()) {
                    this.update(i, -num_nodes);
                    ++i;
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean DeleteLeaf(int dex_to_delete) {
        try {
            try {
                Node mom;
                Node child;
                int up_delete = this.getUpdate(dex_to_delete);
                if (super.IsLeafText(up_delete)) {
                    --dex_to_delete;
                    --up_delete;
                }
                if (this.isFirstChild(child = super.NodeAt(up_delete), mom = this.GetMother(up_delete)) && this.isLastChild(child, mom)) {
                    return true;
                }
                if (!super.IsLeafPOS(up_delete)) {
                    return true;
                }
                this.ShiftPreEnds(up_delete, up_delete, -2);
                super.DeleteNode(up_delete);
                super.DeleteNode(up_delete);
                this.ShiftFollowEnds(up_delete, -2);
                int i = dex_to_delete;
                while (i < this.index_changes.size()) {
                    this.update(i, -2);
                    ++i;
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    public boolean MoveUp(int dex_to_move) {
        int up_dex = this.getUpdate(dex_to_move);
        Node mother = this.GetMother(up_dex);
        Node child = super.NodeAt(up_dex);
        if (this.isFirstChild(child, mother) && !this.isLastChild(child, mother)) {
            return this.MoveUpLeft(child, mother, dex_to_move, up_dex);
        }
        if (this.isLastChild(child, mother) && !this.isFirstChild(child, mother)) {
            return this.MoveUpRight(child, mother);
        }
        return false;
    }

    public boolean MoveUpMulti(int start, int finish) {
        Node finish_mom;
        int up_start = this.getUpdate(start);
        int up_finish = this.getUpdate(finish);
        Node start_move = super.NodeAt(up_start);
        Node finish_move = super.NodeAt(up_finish);
        Node start_mom = this.GetMother(up_start);
        if (start_mom.equals(finish_mom = this.GetMother(up_finish))) {
            if (this.isFirstChild(start_move, start_mom) && !this.isLastChild(finish_move, start_mom)) {
                return this.MoveUpLeftMulti(start_move, finish_move, start_mom, start, finish);
            }
            if (this.isLastChild(finish_move, start_mom) && !this.isFirstChild(start_move, start_mom)) {
                return this.MoveUpRightMulti(start_move, finish_move, start_mom);
            }
            return false;
        }
        Node ancestor = this.GetCommonAncestor(start, finish);
        return this.MoveUp(ancestor.getIndex_int());
    }

    public boolean isFirstChild(Node child, Node mother) {
        return child.getIndex_int() == mother.getIndex_int() + 1;
    }

    public boolean isLastChild(Node child, Node mother) {
        Integer mom_end = super.EndDexAt(mother.getIndex());
        Integer child_end = super.EndDexAt(child.getIndex());
        return child_end.equals(mom_end);
    }

    public boolean MoveUpRight(Node child, Node mother) {
        super.SetEndDexAt(child.getIndex_int() - 1, (int)mother.getIndex());
        return true;
    }

    public boolean MoveUpLeft(Node child, Node mother, int dex_to_move, int up_dex) {
        int old_spot;
        int move_end = super.EndDexAt(up_dex);
        int num_nodes = move_end - up_dex + 1;
        int mom_dex = mother.getIndex_int();
        this.ShiftRight(mom_dex, num_nodes);
        int diff = up_dex - mom_dex;
        int i = 0;
        while (i < num_nodes) {
            old_spot = mom_dex + num_nodes + diff + i;
            int new_spot = mom_dex + i;
            String label = super.LabelAt(old_spot);
            super.SetLabelAt(label, new_spot);
            int old_dex = super.EndDexAt(old_spot);
            super.SetEndDexAt(old_dex - num_nodes - diff, new_spot);
            ++i;
        }
        i = 0;
        while (i < num_nodes) {
            old_spot = mom_dex + num_nodes + diff;
            super.DeleteNode(old_spot);
            ++i;
        }
        this.ShiftFollowEnds(mom_dex + num_nodes, -num_nodes);
        i = 0;
        while (i < num_nodes) {
            this.update(dex_to_move + i, -diff);
            ++i;
        }
        this.update(dex_to_move - 1, num_nodes);
        return true;
    }

    public boolean MoveUpRightMulti(Node start_move, Node finish_move, Node start_mom) {
        super.SetEndDexAt(start_move.getIndex_int() - 1, (int)start_mom.getIndex());
        return true;
    }

    public boolean MoveUpLeftMulti(Node start_move, Node finish_move, Node mother, int start, int finish) {
        int old_spot;
        int finish_dex = finish_move.getIndex_int();
        int up_dex = start_move.getIndex_int();
        int move_end = super.EndDexAt(finish_dex);
        int num_nodes = move_end - up_dex + 1;
        int mom_dex = mother.getIndex_int();
        this.ShiftRight(mom_dex, num_nodes);
        int diff = up_dex - mom_dex;
        int i = 0;
        while (i < num_nodes) {
            old_spot = mom_dex + num_nodes + diff + i;
            int new_spot = mom_dex + i;
            String label = super.LabelAt(old_spot);
            super.SetLabelAt(label, new_spot);
            int old_dex = super.EndDexAt(old_spot);
            super.SetEndDexAt(old_dex - num_nodes - diff, new_spot);
            ++i;
        }
        i = 0;
        while (i < num_nodes) {
            old_spot = mom_dex + num_nodes + diff;
            super.DeleteNode(old_spot);
            ++i;
        }
        this.ShiftFollowEnds(mom_dex + num_nodes, -num_nodes);
        i = 0;
        while (i < num_nodes) {
            this.update(start + i, -diff);
            ++i;
        }
        this.update(start - 1, num_nodes);
        return true;
    }

    public void ChangeLabel(String newlabel, int x) {
        int new_x = this.getUpdate(x);
        super.SetLabelAt(newlabel, new_x);
    }

    public void ChangeLabel(String taskname, String newlabel, int x) {
        int new_x = this.getUpdate(x);
        String oldlabel = super.LabelAt(new_x);
        String changed = this.changedLabel(taskname, newlabel, oldlabel);
        super.SetLabelAt(changed, new_x);
    }

    private String changedLabel(String taskname, String newlabel, String oldlabel) {
        if (taskname.equals("replace_label")) {
            return newlabel;
        }
        if (taskname.equals("append_label")) {
            return oldlabel + newlabel;
        }
        if (taskname.equals("prepend_label")) {
            return newlabel + oldlabel;
        }
        if (taskname.equals("post_crop_label")) {
            return oldlabel.substring(0, oldlabel.indexOf(newlabel));
        }
        if (taskname.equals("pre_crop_label")) {
            return oldlabel.substring(oldlabel.indexOf(newlabel) + 1, oldlabel.length());
        }
        return "BULLWINKLE";
    }

    private void ShiftRight(int from, int how_much) {
        int i = super.size() - 1;
        while (i >= from) {
            super.SetLabelAt(super.LabelAt(i), i + how_much);
            super.SetEndDexAt(super.EndDexAt(i) + how_much, i + how_much);
            --i;
        }
    }

    private void ShiftLeft(int from, int how_much) {
        int i = super.size() - 1;
        while (i >= from) {
            super.SetLabelAt(super.LabelAt(i), i + how_much);
            super.SetEndDexAt(super.EndDexAt(i) + how_much, i + how_much);
            --i;
        }
    }

    private void ShiftPreEnds(int to, int finish, int how_much) {
        int i = 0;
        while (i < to) {
            int old_end = super.EndDexAt(i);
            if (old_end >= finish) {
                super.SetEndDexAt(old_end + how_much, i);
            }
            ++i;
        }
    }

    private void ShiftFollowEnds(int from, int how_much) {
        int i = super.size() - 1;
        while (i >= from) {
            int old_end = super.EndDexAt(i);
            super.SetEndDexAt(old_end + how_much, i);
            --i;
        }
    }

    public static void main(String[] args) {
        ChangeTree sparse = new ChangeTree("EXAMPLE");
        sparse.PrintToSystemErr();
        System.err.println("");
        sparse.AddInternalNode("CONJP", 1, 2);
        sparse.PrintToSystemErr();
    }

    public ChangeTree() {
    }

    public ChangeTree(SynTree sparse) {
        super.setSparseMatrix(sparse);
        this.changesInit(sparse.size());
    }

    public ChangeTree(String Example) {
    }
}

