/*
 * Decompiled with CFR 0.152.
 */
package syntree;

import java.io.PrintWriter;
import java.util.Vector;
import syntree.Node;
import syntree.SynTree;

public class SparseMatrix {
    private Vector label_vec;
    private Vector end_vec;
    private Integer minus1 = new Integer(-1);

    public void setSample() {
        String labels = "IP-MAT CONJ(And ADVP(ADV(so PP P(by NP(NS(meanes NP-SBJ ";
        labels = labels + "NPR(kynge NPR(Uther VBD(send PP P(for NP D(this N(duk ";
        labels = labels + "IP-PPL VAG(chargyng NP-OB1(PRO(hym IP-INF TO(to VB(brynge";
        labels = labels + " NP-OB1 PRO$(his N(wyf PP P(with NP(PRO(hym E_S(, ";
        labels = labels + "ID(CMMALORY,2.8";
        String indices = "50 2 5 11 8 11 16 14 16 18 26 21 26 24 26 48 29 32 48 ";
        indices = indices + "35 37 42 40 42 48 45 48 50 52";
        this.buildFromStrings(labels, indices);
    }

    public void setSparseMatrix(SynTree spaz) {
        this.label_vec = spaz.GetLabelVector();
        this.end_vec = spaz.GetEndVector();
    }

    public Vector GetLabelVector() {
        return this.label_vec;
    }

    public Vector GetEndVector() {
        return this.end_vec;
    }

    public void buildFromStrings(String labels, String indices) {
        this.space_split(labels, this.label_vec, false);
        this.space_split(indices, this.end_vec, true);
    }

    public void space_split(String to_split, Vector to_store, boolean to_Int) {
        int prev_dex = 0;
        while (prev_dex < to_split.length()) {
            Integer dex;
            String item;
            int space_dex = to_split.indexOf(" ", prev_dex);
            if (space_dex < 0) {
                item = to_split.substring(prev_dex, to_split.length());
                if (to_Int) {
                    dex = new Integer(item);
                    to_store.addElement(dex);
                    break;
                }
                to_store.addElement(item);
                break;
            }
            item = to_split.substring(prev_dex, space_dex);
            if (to_Int) {
                dex = new Integer(item);
                to_store.addElement(dex);
            } else {
                to_store.addElement(item);
            }
            prev_dex = space_dex + 1;
        }
    }

    public boolean isEmpty() {
        return this.label_vec.isEmpty();
    }

    public void RemoveAllElements() {
        this.label_vec.removeAllElements();
        this.end_vec.removeAllElements();
    }

    public int size() {
        return this.label_vec.size();
    }

    public Node NodeAt(Integer x) {
        return new Node(x, this.LabelAt(x));
    }

    public Node NodeAt(int x) {
        Integer index = new Integer(x);
        return this.NodeAt(index);
    }

    public void SetLabelAt(String label, int x) {
        while (x >= this.label_vec.size()) {
            this.label_vec.addElement("_");
        }
        this.label_vec.setElementAt(label, x);
    }

    public void SetEndDexAt(Integer dex, int x) {
        while (x >= this.end_vec.size()) {
            this.end_vec.addElement(this.minus1);
        }
        this.end_vec.setElementAt(dex, x);
    }

    public void SetEndDexAt(int dex, int x) {
        Integer dex_Int = new Integer(dex);
        this.SetEndDexAt(dex_Int, x);
    }

    public void SetEndDexAt(Integer dexInt, Integer xInt) {
        this.SetEndDexAt(dexInt, (int)xInt);
    }

    public String LabelAt(int x) {
        return (String)this.label_vec.elementAt(x);
    }

    public String LabelAt(Integer x) {
        return this.LabelAt((int)x);
    }

    public int intEndDexAt(int x) {
        return this.EndDexAt(x);
    }

    public Integer EndDexAt(Integer x) {
        return this.EndDexAt((int)x);
    }

    public Integer EndDexAt(int x) {
        if (x >= this.end_vec.size() || x < 0) {
            return this.minus1;
        }
        return (Integer)this.end_vec.elementAt(x);
    }

    public void AddItem(String new_label, Integer new_end_dex) {
        this.label_vec.addElement(new_label);
        this.end_vec.addElement(new_end_dex);
    }

    public void InsertItem(String label, Integer end_dex, int where) {
        this.label_vec.insertElementAt(label, where);
        this.end_vec.insertElementAt(end_dex, where);
    }

    public void AddLabel(String label) {
        this.label_vec.addElement(label);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void AddDex(Integer x) {
        try {
            try {
                this.end_vec.addElement(x);
                return;
            }
            catch (Exception e) {
                System.err.println("in SparseMatrix: AddDex:  ");
                System.err.println(e.getMessage());
                e.printStackTrace();
                System.exit(0);
                return;
            }
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void AddDex(int x) {
        Integer new_x = new Integer(x);
        this.AddDex(new_x);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void AddDex(String dex_str) {
        try {
            try {
                Integer Int_str = new Integer(Integer.parseInt(dex_str));
                this.AddDex(Int_str);
                return;
            }
            catch (Exception e) {
                System.err.print("in SparseMatrix.AddDex:  ");
                System.err.print("could not parse to Int: ");
                System.err.println(dex_str);
                System.err.println(e.getMessage());
                e.printStackTrace();
                System.exit(0);
                return;
            }
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void DeleteNode(int index) {
        this.end_vec.removeElementAt(index);
        this.label_vec.removeElementAt(index);
    }

    public boolean Verify() {
        if (this.end_vec.size() != this.label_vec.size()) {
            System.err.print("ERROR!  label_vec and end_vec ");
            System.err.println("not the same size:");
            System.err.print("label_vec.size, end_vec.size:  ");
            System.err.println(this.label_vec.size() + ", " + this.end_vec.size());
            return false;
        }
        return true;
    }

    public void PrintToPrintWriter(PrintWriter outrage) {
        int j = 0;
        while (j < this.size()) {
            outrage.print(this.LabelAt(j) + " ");
            ++j;
        }
        outrage.println("");
        j = 0;
        while (j < this.size()) {
            outrage.print(this.EndDexAt(j).toString() + " ");
            ++j;
        }
        outrage.println("");
        outrage.println("");
        outrage.flush();
    }

    public void PrintToSystemErr() {
        int j = 0;
        while (j < this.size()) {
            System.err.print(j + ".  " + this.LabelAt(j) + " ");
            System.err.println(this.EndDexAt(j).toString());
            ++j;
        }
    }

    public static void main(String[] args) {
        SparseMatrix sparse = new SparseMatrix("EXAMPLE");
        sparse.PrintToSystemErr();
    }

    public SparseMatrix() {
        this.label_vec = new Vector();
        this.end_vec = new Vector();
    }

    public SparseMatrix(String Example) {
        this.label_vec = new Vector();
        this.end_vec = new Vector();
        this.setSample();
    }
}

