/*
 * Decompiled with CFR 0.152.
 */
package syntree;

import java.util.Vector;
import syntree.Node;
import syntree.SparseMatrix;

public class SynTree
extends SparseMatrix {
    public Node ROOT;
    public Node METAROOT;
    public Node ID_POS;
    public Node ID_TEXT;

    public Vector GetDescendants(Integer mom_start_dex) {
        Vector<Node> daughters = new Vector<Node>();
        int mom_end_dex_int = super.EndDexAt(mom_start_dex);
        int n = mom_start_dex + 1;
        while (n <= mom_end_dex_int) {
            Node one_daughter = super.NodeAt(n);
            daughters.addElement(one_daughter);
            ++n;
        }
        return daughters;
    }

    public Vector GetDescendants(Node nodal) {
        Integer dex = nodal.getIndex();
        return this.GetDescendants(dex);
    }

    public Vector GetDescendants(int n) {
        Integer n_Int = new Integer(n);
        return this.GetDescendants(n_Int);
    }

    public Vector GetDaughters(int your_mom) {
        Integer mom_start_dex = new Integer(your_mom);
        return this.GetDaughters(mom_start_dex);
    }

    public Vector GetDaughters(Node mom_node) {
        Integer mom_start_dex = mom_node.getIndex();
        return this.GetDaughters(mom_start_dex);
    }

    public Vector GetDaughters(Integer mom_start_dex) {
        Vector<Node> daughters = new Vector<Node>();
        Integer curr_end_dex = new Integer(0);
        int mom_end_dex_int = super.EndDexAt(mom_start_dex);
        int n = mom_start_dex + 1;
        while (n <= mom_end_dex_int) {
            Integer prev_end_dex = curr_end_dex;
            curr_end_dex = super.EndDexAt(n);
            Node one_daughter = super.NodeAt(n);
            if (!curr_end_dex.equals(prev_end_dex) || this.IsLeafPOS(curr_end_dex)) {
                daughters.addElement(one_daughter);
            }
            if (curr_end_dex > n + 1) {
                n = curr_end_dex - 1;
            }
            ++n;
        }
        return daughters;
    }

    public Node FirstDaughter(Integer mom_start_dex) {
        if (this.IsLeafText(mom_start_dex) || mom_start_dex < 0) {
            return new Node("NULL");
        }
        return super.NodeAt(mom_start_dex + 1);
    }

    public Node FirstDaughter(Node mom_node) {
        Integer mom_dex = mom_node.getIndex();
        return this.FirstDaughter(mom_dex);
    }

    public Node FirstDaughter(int mom_int) {
        Integer mom_dex = new Integer(mom_int);
        return this.FirstDaughter(mom_dex);
    }

    public Node GetMother(int x) {
        Integer dex = new Integer(x);
        return this.GetMother(dex);
    }

    public Node GetMother(Node nodal) {
        Integer dex = nodal.getIndex();
        return this.GetMother(dex);
    }

    public Node GetMother(Integer dex) {
        Integer orig_end = super.EndDexAt(dex);
        Integer mom_dex = dex;
        while (mom_dex > 0) {
            Integer mom_end_dex = super.EndDexAt(mom_dex = new Integer(mom_dex - 1));
            if (mom_end_dex < orig_end) continue;
            Node mother = super.NodeAt(mom_dex);
            return mother;
        }
        Node negative = new Node("NULL");
        return negative;
    }

    public Vector GetAncestors(Node nodal) {
        Vector<Node> ancestors = new Vector<Node>();
        Node mom = nodal;
        while (!mom.IsNullNode()) {
            if ((mom = this.GetMother(mom)).IsNullNode()) continue;
            ancestors.addElement(mom);
        }
        return ancestors;
    }

    public Vector GetAncestors(int n) {
        Node nodal = super.NodeAt(n);
        return this.GetAncestors(nodal);
    }

    public Node GetCommonAncestor(Node node1, Node node2) {
        return this.GetCommonAncestor(node1.getIndex(), node2.getIndex());
    }

    public Node GetCommonAncestor(int int1, int int2) {
        Integer dex1 = new Integer(int1);
        Integer dex2 = new Integer(int2);
        return this.GetCommonAncestor(dex1, dex2);
    }

    public Node GetCommonAncestor(Integer dex1, Integer dex2) {
        Vector<Node> mom1_list = new Vector<Node>();
        Node mom1 = this.GetMother(dex1);
        while (!mom1.IsNullNode()) {
            mom1_list.addElement(mom1);
            mom1 = this.GetMother(mom1);
        }
        Node mom2 = this.GetMother(dex2);
        while (!mom2.IsNullNode()) {
            int i = 0;
            while (i < mom1_list.size()) {
                if (mom2.equals((Node)mom1_list.elementAt(i))) {
                    return mom2;
                }
                ++i;
            }
            mom2 = this.GetMother(mom2);
        }
        Node fruitless = new Node("NULL");
        return fruitless;
    }

    public Vector GetSisters(Node nodal) {
        return this.GetSisters(nodal.getIndex_int());
    }

    public Vector GetSisters(Integer nInt) {
        return this.GetSisters((int)nInt);
    }

    public Vector GetSisters(int dex) {
        Vector<Node> sisters = new Vector<Node>();
        Node mother = this.GetMother(dex);
        int mom_dex = mother.getIndex_int();
        if (mom_dex == -1) {
            return sisters;
        }
        int mom_end_dex = super.intEndDexAt(mom_dex);
        int sis_dex = super.intEndDexAt(dex) + 1;
        while (sis_dex <= mom_end_dex) {
            Node one_sister = super.NodeAt(sis_dex);
            sisters.addElement(one_sister);
            sis_dex = super.intEndDexAt(sis_dex) + 1;
        }
        return sisters;
    }

    public Vector GetAllSisters(int n) {
        Integer n_Int = new Integer(n);
        return this.GetAllSisters(n_Int);
    }

    public Vector GetAllSisters(Node nodal) {
        Integer dex = nodal.getIndex();
        return this.GetAllSisters(dex);
    }

    public Vector GetAllSisters(Integer dex) {
        Vector sisters = new Vector();
        Node mother = this.GetMother(dex);
        sisters = this.GetDaughters(mother);
        return sisters;
    }

    public boolean IsRightMost(Node nodal) {
        Integer nodal_end;
        Node mother = this.GetMother(nodal);
        Integer mom_end = this.EndDexAt(mother.getIndex());
        return mom_end.equals(nodal_end = this.EndDexAt(nodal.getIndex()));
    }

    public boolean IsLeftMost(Node nodal) {
        Node mother = this.GetMother(nodal);
        Integer mom_start = mother.getIndex();
        Integer nodal_start = nodal.getIndex();
        return mom_start + 1 == nodal_start;
    }

    public boolean IsLeafPOS(Integer dex) {
        Integer start_plus_1;
        Integer end_dex_1;
        Integer end_dex_0 = super.EndDexAt(dex);
        return end_dex_0.equals(end_dex_1 = super.EndDexAt(start_plus_1 = new Integer(dex + 1))) && end_dex_1.equals(start_plus_1);
    }

    public boolean IsLeafPOS(int dex) {
        Integer dex_Int = new Integer(dex);
        return this.IsLeafPOS(dex_Int);
    }

    public boolean IsLeafPOS(Node nodal) {
        Integer node_dex = nodal.getIndex();
        return this.IsLeafPOS(node_dex);
    }

    public boolean IsLeafText(Integer dex) {
        Integer end_dex = super.EndDexAt(dex);
        return end_dex.equals(dex);
    }

    public boolean IsLeafText(int dex) {
        Integer dex_Int = new Integer(dex);
        return this.IsLeafText(dex_Int);
    }

    public boolean IsLeafText(Node nodal) {
        Integer node_dex = nodal.getIndex();
        return this.IsLeafText(node_dex);
    }

    public boolean dominates(Node x, Node y) {
        int x_index = x.getIndex_int();
        int y_index = y.getIndex_int();
        if (y_index <= x_index) {
            return false;
        }
        int end_x = super.EndDexAt(x_index);
        return y_index <= end_x;
    }

    public Vector getText(Node nodal) {
        Vector<Node> text = new Vector<Node>();
        Vector descendants = this.GetDescendants(nodal);
        int i = 0;
        while (i < descendants.size()) {
            Node descend = (Node)descendants.elementAt(i);
            if (this.IsLeafText(descend)) {
                text.addElement(descend);
            }
            ++i;
        }
        return text;
    }

    public void setIDs() {
        int end = super.size() - 1;
        while (end > 0) {
            Node id = super.NodeAt(end);
            if (id.getLabel().equals("ID")) {
                this.ID_POS = id;
                this.ID_TEXT = super.NodeAt(end + 1);
                return;
            }
            --end;
        }
        this.ID_POS = new Node("NULL");
        this.ID_TEXT = new Node("NULL");
    }

    public boolean isRoot(Node nodal) {
        return this.ROOT.equals(nodal);
    }

    public boolean isMetaRoot(Node x) {
        return this.METAROOT.equals(x);
    }

    public void setConstantNodes() {
        this.setRoot();
        this.setIDs();
    }

    public void setRoot() {
        if (super.isEmpty()) {
            return;
        }
        this.ROOT = this.getRootNode();
        this.METAROOT = super.NodeAt(0);
    }

    public Node getRootNode() {
        String root_label = "";
        int root_dex = 0;
        root_label = super.LabelAt(root_dex);
        while (root_label.length() == 0 || this.IsLeafPOS(root_dex) || this.IsLeafText(root_dex)) {
            if (this.IsLeafPOS(++root_dex) && root_dex + 2 >= super.size()) {
                return super.NodeAt(root_dex);
            }
            if (root_dex >= super.size()) {
                root_dex = 0;
                break;
            }
            root_label = super.LabelAt(root_dex);
        }
        return super.NodeAt(root_dex);
    }

    public static void main(String[] args) {
        SynTree sparse = new SynTree("EXAMPLE");
        Node everymom = sparse.GetCommonAncestor(7, 9);
        System.err.println("everymom:  ");
        everymom.PrintToSystemErr();
        System.err.println("");
    }

    public SynTree() {
    }

    public SynTree(String Example) {
    }
}

