# This is a perl script

# Modifications: (By alexis@edu.upenn.cis.unagi (Alexis Dimitriadis))
#
# Modified to correspond to the encoding actually used in the data files;
# Changed ascii mapping to 1-1 mapping.
#
# Options:
# -latex:	Produce latex input with Greek characters (with stresses).
#
# -stressed:	Produce an ascii transliteration, with apostrophes after 
#		stressed (non-capital) letters denoting the stress.
#
# <default>	Produce ascii transliteration, omitting the stresses.  This
#		is easier for Greeks to read than -stressed, but contains
#		less information.
#
#  The transliteration is that used by Cosmos News, a regular poster of
# news bulletins in the newsgroup soc.culture.greek.  All Greek characters
# are represented by ascii letters, and the capital/lowercase version of
# each character is represented by an upper/lower case pair in English.
#
# # Alexis Dimitriadis 


# Convert greek iso-latin-7 coded files into an ascii transliterated form

$option = $ARGV[0];
if( $option =~ /^-/ ){
    shift;
    if( $option =~ /-la?t?e?x?/ )
	{ $option = "latex" }
    elsif ( $option =~ /-st?r?e?s?s?e?d?/ )
	{ $option = "stressed" } 
    else 
	{ $option = "" }
};
    
if( $option eq "latex"){
    print "\\documentstyle{article}\n\\begin{document}\n";
    print "\\begin{tabbing}\n";
    while(<>){

	s/#/\\#/g;
	s/\$/\\\$/g;
	s/%/\\%/g;
	s/&/\\&/g;
	s/_/\\_/g;
	s/{/\\{/g;
	s/}/\\}/g;
	s/</\$\\langle\$/g;
	s/>/\$\\rangle\$/g;
	s/\n/\\\\\n/;
	s/ /\\ /g;

    s//\$\\alpha\$/g;
    s//A/g;
    s//\$\\beta\$/g;
    s//B/g;
    s//\$\\gamma\$/g;
    s//\$\\Gamma\$/g;
    s//\$\\delta\$/g;
    s//\$\\Delta\$/g;
    s//\$\\epsilon\$/g;
    s//E/g;
    s//\$\\zeta\$/g;
    s//Z/g;
    s//\$\\eta\$/g;
    s//H/g;
    s//\$\\theta\$/g;
    s//\$\\Theta\$/g;
    s//\$\\iota\$/g;
    s//I/g;
    s//\$\\kappa\$/g;
    s//K/g;
    s//\$\\lambda\$/g;
    s//\$\\Lambda\$/g;
    s//\$\\mu\$/g;
    s//M/g;
    s//\$\\nu\$/g;
    s//N/g;
    s//\$\\xi\$/g;
    s//\$\\Xi\$/g;
    s//o/g;
    s//O/g;
    s//\$\\pi\$/g;
    s//\$\\Pi\$/g;
    s//\$\\rho\$/g;
    s//P/g;
    s//\$\\sigma\$/g;
    s//\$\\Sigma\$/g;
    s//\$\\varsigma\$/g;
    s//\$\\tau\$/g;
    s//T/g;
    s//\$\\upsilon\$/g;
    s//\$\\Upsilon\$/g;
    s//\$\\phi\$/g;
    s//\$\\Phi\$/g;
    s//\$\\chi\$/g;
    s//X/g;
    s//\$\\psi\$/g;
    s//\$\\Psi\$/g;
    s//\$\\omega\$/g;
    s//\$\\Omega\$/g;

    s//\$\\acute{\\alpha}\$/g;
    s//A/g;
    s//\$\\acute{\\epsilon}\$/g;
    s//E/g;
    s//\$\\acute{\\eta}\$/g;
    s//H/g;
    s//\$\\ddot{\\iota}\$/g;
    s//\$\\ddot{I}\$/g;
    s//\$\\acute{\\iota}\$/g;
    s//I/g;
    s//\$\\acute{\\ddot{\\iota}}\$/g;
    s//\$\\acute{o}\$/g;
    s//O/g; 
    s//\$\\ddot{\\upsilon}\$/g;
    s//\$\\ddot{\\Upsilon}\$/g;
    s//\$\\acute{\\upsilon}\$/g;
    s//\$\\Upsilon\$/g;
    s//\$\\acute{\\ddot{\\upsilon}}\$/g;
    s//\$\\acute{\\omega}\$/g;
    s//\$\\Omega\$/g;
    print;
};
    print "\\end{tabbing}\n";
    print "\\end{document}\n";
} else {
while(<>){
    s//a/g;
    s//A/g;
    s//b/g;
    s//B/g;
    s//g/g;
    s//G/g;
    s//d/g;
    s//D/g;
    s//e/g;
    s//E/g;
    s//z/g;
    s//Z/g;
    s//h/g;
    s//H/g;
    s//q/g;
    s//Q/g;
    s//i/g;
    s//I/g;
    s//k/g;
    s//K/g;
    s//l/g;
    s//L/g;
    s//m/g;
    s//M/g;
    s//n/g;
    s//N/g;
    s//j/g;
    s//J/g;
    s//o/g;
    s//O/g;
    s//p/g;
    s//P/g;
    s//r/g;
    s//R/g;
    s//s/g;
    s//S/g;
    s//s/g;
    s//t/g;
    s//T/g;
    s//y/g;
    s//Y/g;
    s//f/g;
    s//F/g;
    s//x/g;
    s//X/g;
    s//c/g;
    s//C/g;
    s//w/g;
    s//W/g;

    s//A/g;# Used for A, apostrophe, and prevocalic stress :-(
    s//E/g;#
    s//H/g;#
    s//I/g;#
    s//O/g; #
    s//Y/g;#
    s//W/g; #

  if( $option eq "stressed"){
    s//a'/g;
    s//e'/g;
    s//h'/g;
    s//I"/g;
    s//i"/g;
    s//i'/g;
    s//i"'/g;
    s//o'/g;
    s//y"/g;
    s//Y"/g;
    s//y'/g;
    s//y"'/g;
    s//w'/g;
  } else {
    s//a/g;
    s//e/g;
    s//h/g;
    s//I/g;
    s//i/g;
    s//i/g;
    s//i/g;
    s//o/g;
    s//y/g;
    s//Y/g;
    s//y/g;
    s//y/g;
    s//w/g;
  }
    
    print;
}
}
