/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import uk.ac.bham.clg.cue.corpus.CueAdmin;
import uk.ac.bham.clg.cue.corpus.Heap;
import uk.ac.bham.clg.cue.corpus.NTreeWordList;
import uk.ac.bham.clg.cue.corpus.TextResource;
import uk.ac.bham.clg.cue.corpus.WordList;

class CodeGen {
    static final boolean DEBUG = false;

    protected CodeGen(String string, String string2, boolean bl) throws IOException, IndexOutOfBoundsException {
        CueAdmin cueAdmin = CueAdmin.getInstance();
        String string3 = new String(String.valueOf(cueAdmin.getCodeDir()) + File.separatorChar + string2);
        File file = new File(String.valueOf(string3) + ".wrd");
        if (file.exists()) {
            return;
        }
        TextResource textResource = new TextResource(string);
        int n = 0;
        NTreeWordList nTreeWordList = null;
        if (bl) {
            nTreeWordList = new NTreeWordList();
        }
        ((WordList)nTreeWordList).doProcessing(textResource, string3);
        n = ((WordList)nTreeWordList).getWordCount();
        nTreeWordList = null;
        WordListIndexer wordListIndexer = new WordListIndexer(String.valueOf(string3) + ".wrd", String.valueOf(string3) + ".wdi");
        wordListIndexer.start();
        FileInputStream fileInputStream = new FileInputStream(String.valueOf(string3) + ".frq");
        Heap heap = new Heap(n, new DataInputStream(fileInputStream));
        heap.sort(0);
        heap.buildCodeTree();
        heap.writeCode(string3);
        try {
            wordListIndexer.join();
        }
        catch (InterruptedException interruptedException) {
            System.err.println(interruptedException);
        }
    }

    public static void main(String[] stringArray) {
        try {
            CodeGen codeGen = new CodeGen(stringArray[0], stringArray[1], true);
        }
        catch (Exception exception) {
            System.err.println("Ooops, something went wrong... : " + exception);
        }
    }

    private class WordListIndexer
    extends Thread {
        DataInputStream dis;
        DataOutputStream dos;
        long fileSize;
        int done;

        public WordListIndexer(String string, String string2) throws IOException {
            this.dis = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
            this.dos = new DataOutputStream(new FileOutputStream(string2));
            this.done = 0;
        }

        public void run() {
            char c = '\u0000';
            int n = 0;
            try {
                this.dos.writeInt(0);
                while (this.dis.available() > 0) {
                    c = (char)this.dis.readUnsignedByte();
                    ++n;
                    if (c != '\n') continue;
                    this.dos.writeInt(n);
                }
            }
            catch (EOFException eOFException) {
                System.err.println("WordListIndexer: " + eOFException + " at " + n + " (what=" + c + ")");
            }
            catch (IOException iOException) {
                System.err.println("WordListIndexer: " + iOException + " at " + n);
            }
            try {
                this.dis.close();
                this.dos.close();
            }
            catch (IOException iOException) {
                System.err.println("WordListIndexer: " + iOException);
            }
        }
    }
}

