/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import uk.ac.bham.clg.cue.corpus.Collocate;
import uk.ac.bham.clg.cue.corpus.Concordances;
import uk.ac.bham.clg.cue.corpus.Cue;
import uk.ac.bham.clg.cue.corpus.ProgressCounter;
import uk.ac.bham.clg.cue.corpus.statistics.EvaluationFunction;
import uk.ac.bham.clg.cue.utils.Comparable;
import uk.ac.bham.clg.cue.utils.Lemmatiser;
import uk.ac.bham.clg.cue.utils.Tagger;
import uk.ac.bham.clg.cue.utils.VectorSort;

public class Collocations {
    private Concordances concSet = null;
    private Hashtable candidates = null;
    private Hashtable nodeWords = null;
    private Cue app = null;
    private boolean clean = false;
    private Lemmatiser lemmatiser = null;
    private Tagger tagger = null;
    private int leftSpan = 4;
    private int rightSpan = 4;
    private int cutOff = 1;
    private boolean caseFold = false;
    private boolean direction = false;
    private final boolean DEBUG = false;
    public static final String LEFTSTRING = " [left]";
    public static final String RIGHTSTRING = " [right]";

    public Collocations(Cue cue, Concordances concordances) {
        this.app = cue;
        this.concSet = concordances;
    }

    public Collocate[] calculate(boolean bl, ProgressCounter progressCounter) {
        int n;
        this.candidates = this.collectCandidates(null);
        if (this.candidates == null) {
            System.err.println("Collocations (calculate): no candidates found");
            return null;
        }
        if (this.nodeWords == null) {
            System.err.println("Collocations (calculate): no nodewords found");
            return null;
        }
        int n2 = this.app.getSize();
        int n3 = 0;
        Enumeration enumeration = this.nodeWords.keys();
        while (enumeration.hasMoreElements()) {
            n3 += this.app.getFreq((String)enumeration.nextElement());
        }
        int n4 = this.concSet.getSize();
        boolean bl2 = false;
        boolean bl3 = false;
        int n5 = this.leftSpan * n4;
        int n6 = this.rightSpan * n4;
        int n7 = n5 + n6;
        String string = null;
        Entry entry = null;
        double d = 0.0;
        boolean bl4 = false;
        Vector<Entry> vector = new Vector<Entry>();
        EvaluationFunction evaluationFunction = (EvaluationFunction)this.app.getValue("collocation.evalfunc");
        boolean bl5 = false;
        boolean bl6 = false;
        enumeration = this.candidates.keys();
        if (progressCounter != null) {
            progressCounter.setMinimum(0);
            progressCounter.setValue(0);
            progressCounter.setMaximum(this.candidates.size() - 1);
            progressCounter.start("Scoring Collocates");
        }
        while (enumeration.hasMoreElements()) {
            if (progressCounter != null) {
                progressCounter.inc();
                if (progressCounter.isCanceled()) {
                    return null;
                }
            }
            if ((entry = (Entry)this.candidates.get(string = (String)enumeration.nextElement())) == null) continue;
            int n8 = entry.getFreq(-1);
            n = entry.getFreq(1);
            int n9 = entry.getTotal(this.app);
            if (this.direction) {
                Entry entry2;
                if (n8 > this.cutOff && n5 > 0) {
                    d = evaluationFunction.calculateScore(n2, n5, n4, n3, n8, n9);
                    if (Double.isInfinite(d) || Double.isNaN(d)) {
                        System.err.println(String.valueOf(string) + " " + d);
                    } else {
                        entry2 = new Entry(String.valueOf(string) + LEFTSTRING, 0, 0);
                        entry2.freq = n8;
                        entry2.total = entry.getTotal();
                        entry2.setScore(d);
                        vector.addElement(entry2);
                    }
                }
                if (n > this.cutOff && n6 > 0) {
                    d = evaluationFunction.calculateScore(n2, n6, n4, n3, n, n9);
                    if (Double.isInfinite(d) || Double.isNaN(d)) {
                        System.err.println(String.valueOf(string) + " " + d);
                    } else {
                        entry2 = new Entry(String.valueOf(string) + RIGHTSTRING, 0, 0);
                        entry2.freq = n;
                        entry2.total = entry.getTotal();
                        entry2.setScore(d);
                        vector.addElement(entry2);
                    }
                }
            }
            if (n8 + n <= this.cutOff || n7 <= 0) continue;
            d = evaluationFunction.calculateScore(n2, n7, n4, n3, n8 + n, n9);
            if (Double.isInfinite(d) || Double.isNaN(d)) {
                System.err.println(String.valueOf(string) + " " + d);
                continue;
            }
            entry.setScore(d);
            entry.freq = n8 + n;
            entry.left = null;
            entry.right = null;
            vector.addElement(entry);
        }
        VectorSort.quickSort(vector);
        Collocate[] collocateArray = new Collocate[vector.size()];
        n = 0;
        while (n < vector.size()) {
            Entry entry3 = (Entry)vector.elementAt(n);
            collocateArray[n] = new Collocate(entry3.getWord(), entry3.freq, entry3.getTotal(), entry3.getScore());
            ++n;
        }
        vector = null;
        return collocateArray;
    }

    private Hashtable collectCandidates(ProgressCounter progressCounter) {
        this.leftSpan = (Integer)this.app.getValue("collocation.span.left");
        this.rightSpan = (Integer)this.app.getValue("collocation.span.right");
        this.cutOff = (Integer)this.app.getValue("collocation.cutoff");
        this.caseFold = (Boolean)this.app.getValue("collocation.casefold");
        this.direction = (Boolean)this.app.getValue("collocation.direction");
        if (this.concSet == null) {
            return null;
        }
        int n = this.concSet.getSize();
        String[] stringArray = new String[this.leftSpan];
        String[] stringArray2 = new String[this.rightSpan];
        String string = null;
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>(n * (this.leftSpan + this.rightSpan));
        this.nodeWords = new Hashtable();
        if (progressCounter != null) {
            progressCounter.setMinimum(0);
            progressCounter.setMaximum(n - 1);
            progressCounter.start("Collecting Collocates");
        }
        int n2 = 0;
        while (n2 < n) {
            Object object;
            string = this.concSet.getContext(n2, stringArray, stringArray2);
            if (progressCounter != null) {
                progressCounter.setValue(n2);
                if (progressCounter.isCanceled()) {
                    return null;
                }
            }
            if (string != null) {
                this.nodeWords.put(string, string);
            }
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (stringArray[n3] != null) {
                    String string2 = stringArray[n3];
                    if (this.lemmatiser != null) {
                        string2 = (String)this.lemmatiser.getLemma(string2).pop();
                    }
                    if (this.caseFold) {
                        string2 = string2.toUpperCase();
                    }
                    if ((object = (Entry)hashtable.get(string2)) == null) {
                        object = new Entry(string2, this.leftSpan, this.rightSpan);
                        hashtable.put(string2, object);
                    }
                    ((Entry)object).add(stringArray[n3], -(n3 + 1));
                }
                ++n3;
            }
            int n4 = 0;
            while (n4 < stringArray2.length) {
                if (stringArray2[n4] != null) {
                    Entry entry;
                    object = stringArray2[n4];
                    if (this.lemmatiser != null) {
                        object = (String)this.lemmatiser.getLemma((String)object).pop();
                    }
                    if (this.caseFold) {
                        object = ((String)object).toUpperCase();
                    }
                    if ((entry = (Entry)hashtable.get(object)) == null) {
                        entry = new Entry((String)object, this.leftSpan, this.rightSpan);
                        hashtable.put(object, entry);
                    }
                    entry.add(stringArray2[n4], n4 + 1);
                }
                ++n4;
            }
            ++n2;
        }
        if (progressCounter != null) {
            progressCounter.setValue(n * 5);
        }
        return hashtable;
    }

    private class Entry
    implements Comparable {
        String theCollocate = null;
        int[] left = null;
        int[] right = null;
        double score = 0.0;
        int total = 0;
        int freq = 0;
        Vector collated = new Vector();

        public Entry(String string, int n, int n2) {
            this.collated.addElement(string);
            this.theCollocate = string;
            this.left = new int[n];
            this.right = new int[n2];
        }

        public void add(String string, int n) {
            if (n < 0) {
                int n2 = -n - 1;
                this.left[n2] = this.left[n2] + 1;
            }
            if (n > 0) {
                int n3 = n - 1;
                this.right[n3] = this.right[n3] + 1;
            }
            ++this.freq;
            if (string != null && this.collated.indexOf(string) < 0) {
                this.collated.addElement(string);
            }
        }

        public int compareTo(Comparable comparable) {
            if (this.score > ((Entry)comparable).getScore()) {
                return -1;
            }
            if (this.score < ((Entry)comparable).getScore()) {
                return 1;
            }
            return this.theCollocate.compareTo(((Entry)comparable).getWord());
        }

        public int getFreq(int n) {
            int[] nArray = null;
            if (n < 0) {
                nArray = this.left;
            }
            if (n > 0) {
                nArray = this.right;
            }
            int n2 = 0;
            if (nArray != null) {
                int n3 = 0;
                while (n3 < nArray.length) {
                    n2 += nArray[n3];
                    ++n3;
                }
            }
            return n2;
        }

        public double getScore() {
            return this.score;
        }

        public int getTotal() {
            return this.total;
        }

        public int getTotal(Cue cue) {
            this.total = 0;
            int n = 0;
            while (n < this.collated.size()) {
                String string = (String)this.collated.elementAt(n);
                this.total += cue.getFreq(string);
                ++n;
            }
            return this.total;
        }

        public String getWord() {
            return this.theCollocate;
        }

        public void setScore(double d) {
            this.score = d;
        }

        public void setWord(String string) {
            this.theCollocate = string;
        }
    }
}

