/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.CollationKey;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Vector;
import uk.ac.bham.clg.cue.corpus.ConcordanceLine;
import uk.ac.bham.clg.cue.corpus.Corpus;
import uk.ac.bham.clg.cue.corpus.CorpusException;
import uk.ac.bham.clg.cue.corpus.CorpusPosition;
import uk.ac.bham.clg.cue.corpus.Cue;
import uk.ac.bham.clg.cue.corpus.CueResult;
import uk.ac.bham.clg.cue.corpus.Item;
import uk.ac.bham.clg.cue.corpus.ProgressCounter;
import uk.ac.bham.clg.util.HashInc;

public class Concordances {
    private CueResult data = null;
    private int[] refs = null;
    private int size = 0;
    private Vector dynRefs = null;
    private Vector corRefs = null;
    public static final int WORD = 0;
    public static final int TAG = 1;
    public int MAXSORTDEPTH = 6;
    private ProgressCounter pm = null;
    public static final int UNIDIR = 0;
    public static final int INTERLEAVED = 1;

    public Concordances() {
    }

    public Concordances(Cue cue, ObjectInput objectInput) throws IOException {
        try {
            this.data = new CueResult(cue, objectInput);
            this.refs = (int[])objectInput.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException);
        }
        this.size = this.data.getSize();
    }

    public Concordances(CueResult cueResult) {
        this.data = cueResult;
        this.size = this.data == null ? 0 : this.data.getSize();
        this.refs = new int[this.size];
        int n = 0;
        while (n < this.size) {
            this.refs[n] = n;
            ++n;
        }
    }

    public void add(Item item) {
        if (this.dynRefs == null) {
            this.dynRefs = new Vector();
        }
        this.dynRefs.addElement(item);
    }

    public void convert() {
        CorpusPosition[] corpusPositionArray;
        if (this.dynRefs == null) {
            return;
        }
        HashInc hashInc = new HashInc();
        Vector<CorpusPosition[]> vector = new Vector<CorpusPosition[]>();
        int n = 0;
        while (n < this.dynRefs.size()) {
            corpusPositionArray = ((Item)this.dynRefs.elementAt(n)).getCorpus();
            hashInc.put(corpusPositionArray);
            if (!vector.contains(corpusPositionArray)) {
                vector.addElement(corpusPositionArray);
            }
            ++n;
        }
        corpusPositionArray = new CorpusPosition[vector.size()];
        int n2 = 0;
        int n3 = 0;
        while (n3 < vector.size()) {
            Corpus corpus = (Corpus)vector.elementAt(n3);
            int[] nArray = new int[hashInc.get(corpus)];
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.dynRefs.size()) {
                Item item = (Item)this.dynRefs.elementAt(n5);
                if (item.getCorpus() == corpus) {
                    nArray[n4++] = item.getOffset();
                }
                ++n5;
            }
            if (n4 != hashInc.get(corpus)) {
                System.err.println("Only found " + n4 + " occurrences (Concordances.convert)");
            }
            corpusPositionArray[n2++] = new CorpusPosition(corpus, nArray);
            ++n3;
        }
        this.data = new CueResult(corpusPositionArray);
        this.size = this.data.getSize();
        this.refs = new int[this.size];
        int n6 = 0;
        while (n6 < this.size) {
            this.refs[n6] = n6;
            ++n6;
        }
        this.dynRefs = null;
    }

    public void delete(int n) {
        if (n >= 0 && n < this.size) {
            --this.size;
            int n2 = n;
            while (n2 < this.size) {
                this.refs[n2] = this.refs[n2 + 1];
                ++n2;
            }
        }
    }

    public void deleteAll() {
        this.refs = null;
        this.size = 0;
        this.data = null;
    }

    public void fill(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this.add((Item)enumeration.nextElement());
        }
    }

    public ConcordanceLine getConcordanceLine(int n, int n2) throws CorpusException {
        if (n >= this.size) {
            return null;
        }
        Item item = this.data.getItem(this.refs[n]);
        return new ConcordanceLine(item, n2);
    }

    public ConcordanceLine[] getConcordanceLine(int n, int n2, int n3) throws CorpusException {
        if (n + n2 > this.size) {
            n2 = this.size - n;
        }
        if (n2 < 1) {
            return null;
        }
        ConcordanceLine[] concordanceLineArray = new ConcordanceLine[n2];
        int n4 = 0;
        while (n4 < n2) {
            concordanceLineArray[n4] = this.getConcordanceLine(n + n4, n3);
            ++n4;
        }
        return concordanceLineArray;
    }

    public String getContext(int n, String[] stringArray, String[] stringArray2) {
        return this.data.getContext(this.refs[n], stringArray, stringArray2);
    }

    public Item getItem(int n) {
        Item item = this.data.getItem(this.refs[n]);
        return item;
    }

    private CollationKey getKey(int n) {
        return this.data.getKey(this.refs[n]);
    }

    public String getKwic(int n, int n2) {
        int[] nArray = new int[]{this.refs[n]};
        String[] stringArray = this.data.getKwicLines(nArray, n2);
        return stringArray[0];
    }

    public String[] getKwic(int n, int n2, int n3) {
        if (n + n2 > this.size) {
            n2 = this.size - n;
        }
        if (n2 < 1) {
            return null;
        }
        int[] nArray = new int[n2];
        int n4 = 0;
        while (n4 < n2) {
            nArray[n4] = this.refs[n + n4];
            ++n4;
        }
        return this.data.getKwicLines(nArray, n3);
    }

    public int getSize() {
        return this.size;
    }

    public String[] getSlotWordList(int n) {
        String[] stringArray = new String[this.size];
        int n2 = 0;
        while (n2 < this.size) {
            stringArray[n2] = this.data.getWordOffset(n2, n);
            ++n2;
        }
        return stringArray;
    }

    private byte getTag(int n) {
        return this.data.getTag(this.refs[n]);
    }

    private void qsort(int[] nArray, int n, int n2, int n3) {
        if (n >= n2) {
            return;
        }
        this.swap(nArray, n, (n + n2) / 2);
        int n4 = n;
        int n5 = n + 1;
        while (n5 <= n2) {
            if (this.pm != null) {
                this.pm.inc();
                if (this.pm.isCanceled()) {
                    return;
                }
            }
            switch (n3) {
                case 0: {
                    if (this.getKey(n5).compareTo(this.getKey(n)) >= 0) break;
                    this.swap(nArray, ++n4, n5);
                    break;
                }
                case 1: {
                    if (this.getTag(n5) >= this.getTag(n)) break;
                    this.swap(nArray, ++n4, n5);
                    break;
                }
                default: {
                    return;
                }
            }
            ++n5;
        }
        this.swap(nArray, n, n4);
        this.qsort(nArray, n, n4 - 1, n3);
        this.qsort(nArray, n4 + 1, n2, n3);
    }

    public void save(ObjectOutput objectOutput) throws IOException {
        this.data.save(objectOutput);
        objectOutput.writeObject(this.refs);
    }

    public void sort(int n, int n2, int n3) {
        if (this.data.calcCollationKeys(n, null)) {
            this.qsort(this.refs, n2, n3, 0);
        }
    }

    public void sort(int n, ProgressCounter progressCounter) {
        if (progressCounter != null) {
            this.pm = progressCounter;
            int n2 = this.size + 15 * (int)((double)this.size * Math.log(this.size));
            progressCounter.setMaximum(n2);
            progressCounter.start("Sorting " + NumberFormat.getInstance().format(this.size) + " lines");
        }
        if (!this.data.calcCollationKeys(n, progressCounter)) {
            return;
        }
        this.qsort(this.refs, 0, this.size - 1, 0);
        if (progressCounter != null) {
            progressCounter.setValue(progressCounter.getMaximum() + 1);
            progressCounter.stop();
        }
        this.pm = null;
    }

    public void stagedSort(int n, int n2) {
    }

    private void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }
}

