/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import uk.ac.bham.clg.cue.corpus.CorpusException;
import uk.ac.bham.clg.cue.corpus.CorpusPosition;
import uk.ac.bham.clg.cue.corpus.Cue;
import uk.ac.bham.clg.cue.corpus.HuffmanCode;
import uk.ac.bham.clg.cue.corpus.Stream;
import uk.ac.bham.clg.cue.corpus.TextIndexer;
import uk.ac.bham.clg.cue.corpus.annotation.Annotation;
import uk.ac.bham.clg.cue.corpus.annotation.Tag;
import uk.ac.bham.clg.cue.corpus.query.TagListNode;
import uk.ac.bham.clg.cue.corpus.query.TagNode;

public class Corpus {
    private static final boolean DEBUG = false;
    private Cue application = null;
    private boolean active = false;
    private String name = null;
    private String label = null;
    private String description = null;
    private String language = null;
    private Locale locale = null;
    private String country = null;
    private int revision = 0;
    private int size = 0;
    private Stream[] streams = null;
    private String location = null;
    private String textTags = null;
    private String headerTags = null;
    private String docTags = null;
    private String markupStatus = null;
    private boolean remote = false;
    private String host = null;
    private int nextStream = 0;

    public Corpus(Cue cue, String string) throws CorpusException {
        this.application = cue;
        this.location = String.valueOf(this.application.getCorpusDir()) + File.separatorChar + string;
        boolean bl = false;
        if (this.location.startsWith("remote:")) {
            this.remote = true;
            throw new CorpusException("remote corpora not implemented yet!");
        }
        this.remote = false;
        Properties properties = Corpus.readConfig(this.location);
        this.name = properties.getProperty("name", string);
        this.label = properties.getProperty("label", string);
        this.description = properties.getProperty("description", "(none available)");
        this.language = properties.getProperty("language", "null");
        this.country = properties.getProperty("country", "null");
        if (this.language.equals("null") || this.country.equals("null")) {
            this.locale = Locale.getDefault();
            this.language = this.locale.getLanguage();
            this.country = this.locale.getCountry();
        } else {
            this.locale = new Locale(this.language, this.country);
        }
        this.size = Integer.parseInt(properties.getProperty("size", "0"));
        this.revision = Integer.parseInt(properties.getProperty("revision", "0"));
        this.textTags = properties.getProperty("texttags", null);
        this.headerTags = properties.getProperty("headertags", null);
        this.docTags = properties.getProperty("doctags", null);
        this.markupStatus = properties.getProperty("markupstatus", "unknown");
        int n = Integer.parseInt(properties.getProperty("streamnumber", "0"));
        this.streams = new Stream[n];
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith("stream-")) continue;
            Properties properties2 = new Properties();
            String string3 = properties.getProperty(string2);
            ((Hashtable)properties2).put("corpus", string);
            ((Hashtable)properties2).put("directory", this.location);
            ((Hashtable)properties2).put("size", String.valueOf(this.size));
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
            ((Hashtable)properties2).put("name", stringTokenizer.nextToken());
            ((Hashtable)properties2).put("granularity", stringTokenizer.nextToken());
            ((Hashtable)properties2).put("code", stringTokenizer.nextToken());
            try {
                Stream stream = new Stream(this.application, this, properties2);
                if (stream == null) continue;
                this.addStream(stream);
            }
            catch (IOException iOException) {
                throw new CorpusException("Corpus (stream init): " + iOException);
            }
        }
        this.activate();
    }

    public void activate() {
        this.active = true;
    }

    private void addStream(Stream stream) {
        if (stream != null && this.nextStream < this.streams.length) {
            this.streams[this.nextStream++] = stream;
        }
    }

    public void deactivate() {
        this.active = false;
    }

    public Cue getApp() {
        return this.application;
    }

    public String[] getContext(int n, int n2, String string) throws CorpusException {
        if (this.remote) {
            throw new CorpusException("remote corpora not implemented yet!");
        }
        int n3 = 0;
        while (n3 < this.streams.length) {
            if (this.streams[n3].getName().equals(string)) {
                try {
                    return this.streams[n3].getContext(n, n2);
                }
                catch (IOException iOException) {
                    throw new CorpusException("Corpus.getContext (reading): " + iOException);
                }
            }
            ++n3;
        }
        return null;
    }

    public Vector getContext(int n, int n2, String string, Vector vector) throws CorpusException {
        if (this.remote) {
            throw new CorpusException("remote corpora not implemented yet!");
        }
        String[] stringArray = null;
        int n3 = 0;
        while (n3 < this.streams.length) {
            if (this.streams[n3].getName().equals(string)) {
                try {
                    stringArray = this.streams[n3].getContext(n, n2);
                    break;
                }
                catch (IOException iOException) {
                    throw new CorpusException("Corpus.getContext (reading): " + iOException);
                }
            }
            ++n3;
        }
        if (stringArray == null) {
            return null;
        }
        int n4 = 0;
        while (n4 < vector.size()) {
            vector.setElementAt(new TagNode((String)vector.elementAt(n4), 3, null), n4);
            ++n4;
        }
        TagListNode tagListNode = new TagListNode(vector, 3);
        tagListNode = (TagListNode)tagListNode.instantiate(this);
        Vector<String> vector2 = new Vector<String>();
        Stack<Tag> stack = new Stack<Tag>();
        Tag tag = null;
        Tag tag2 = null;
        Tag tag3 = null;
        tag = tagListNode.getNextTag();
        tag3 = tagListNode.getNextTag();
        int n5 = 0;
        while (n5 < stringArray.length) {
            if (tag != null && tag.getStart() <= n + n5) {
                vector2.addElement(tag.toString(1));
                if (tag3 != null && tag3.getStart() < tag.getEnd()) {
                    stack.push(tag);
                    tag = tag3;
                    tag3 = tagListNode.getNextTag();
                    continue;
                }
                tag2 = tag;
                tag = null;
                continue;
            }
            if (tag2 != null && tag2.getEnd() < n + n5) {
                vector2.addElement(tag2.toString(2));
                if (!stack.empty() && tag3 != null) {
                    tag2 = (Tag)stack.peek();
                    if (tag2.getEnd() < tag3.getStart()) {
                        stack.pop();
                        continue;
                    }
                    tag2 = null;
                    tag = tag3;
                    tag3 = tagListNode.getNextTag();
                    continue;
                }
                tag2 = null;
                tag = tag3;
                tag3 = tagListNode.getNextTag();
                continue;
            }
            vector2.addElement(stringArray[n5]);
            ++n5;
        }
        if (tag2 != null) {
            vector2.addElement(tag2.toString(2));
        }
        while (!stack.empty()) {
            tag2 = (Tag)stack.pop();
            vector2.addElement(tag2.toString(2));
        }
        return vector2;
    }

    public String getDesc() {
        return this.description;
    }

    public String getDocTags() {
        return this.docTags;
    }

    public int getFreq(String string) throws CorpusException {
        return this.getFreq(string, "text");
    }

    public int getFreq(String string, String string2) throws CorpusException {
        if (this.remote) {
            throw new CorpusException("remote corpora not implemented yet!");
        }
        int n = 0;
        while (n < this.streams.length) {
            if (this.streams[n].getName().equals(string2)) {
                return this.streams[n].getFreq(string);
            }
            ++n;
        }
        return 0;
    }

    public int getFreq(String[] stringArray) throws CorpusException {
        if (this.remote) {
            throw new CorpusException("remote corpora not implemented yet!");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            n += this.getFreq(stringArray[n2], "text");
            ++n2;
        }
        return n;
    }

    public int getFreq(String[] stringArray, String string) throws CorpusException {
        if (this.remote) {
            throw new CorpusException("remote corpora not implemented yet!");
        }
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.streams.length) {
            if (this.streams[n3].getName().equals(string)) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 >= 0) {
            int n4 = 0;
            while (n4 < stringArray.length) {
                n += this.streams[n2].getFreq(stringArray[n4]);
                ++n4;
            }
        }
        return n;
    }

    public String getHeaderTags() {
        return this.headerTags;
    }

    public String getKwic(int n, int n2, String string) throws CorpusException {
        if (this.remote) {
            throw new CorpusException("remote corpora not implemented yet!");
        }
        int n3 = 0;
        while (n3 < this.streams.length) {
            if (this.streams[n3].getName().equals(string)) {
                char[] cArray = new char[n2];
                try {
                    this.streams[n3].kwic(n, cArray);
                    return new String(cArray);
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            ++n3;
        }
        return null;
    }

    public String getLabel() {
        return this.label;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMarkupStatus() {
        return this.markupStatus;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public String getTextTags() {
        return this.textTags;
    }

    protected void indexStream(String string) throws IOException {
        if (this.remote) {
            throw new IOException("remote corpora not implemented yet!");
        }
        int n = 0;
        while (n < this.streams.length) {
            if (this.streams[n].getName().equals(string)) {
                HuffmanCode huffmanCode = this.streams[n].getCode();
                String string2 = huffmanCode.getName();
                TextIndexer textIndexer = new TextIndexer(this.name, this.location, string, string2, this.size);
            }
            ++n;
        }
    }

    public boolean isActive() {
        return this.active;
    }

    static Properties readConfig(String string) throws CorpusException {
        Object object;
        Properties properties = new Properties();
        try {
            object = new BufferedInputStream(new FileInputStream(String.valueOf(string) + File.separatorChar + "config"));
            properties.load((InputStream)object);
            ((BufferedInputStream)object).close();
        }
        catch (IOException iOException) {
            throw new CorpusException("Cannot load `" + string + File.separatorChar + "config: " + iOException);
        }
        ((Hashtable)properties).put("directory", string);
        object = null;
        String string2 = null;
        int n = 0;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            string2 = properties.getProperty((String)object);
            if (((String)object).equals("desc")) {
                properties.setProperty("description", string2);
                continue;
            }
            if (((String)object).equals("lang")) {
                properties.setProperty("language", string2);
                continue;
            }
            if (!((String)object).startsWith("stream")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
            String string3 = new String(String.valueOf(stringTokenizer.nextToken()) + "|" + stringTokenizer.nextToken() + "|" + stringTokenizer.nextToken());
            properties.setProperty("stream-" + n++, string3);
        }
        properties.setProperty("streamnumber", String.valueOf(n));
        return properties;
    }

    public Enumeration retrieveItem(String string, String string2, int n) throws CorpusException {
        if (this.remote) {
            throw new CorpusException("remote corpora not implemented yet!");
        }
        int n2 = 0;
        while (n2 < this.streams.length) {
            if (this.streams[n2].getName().equals(string2)) {
                return this.streams[n2].retrieveItem(string, n);
            }
            ++n2;
        }
        return null;
    }

    public Enumeration retrieveTag(String string, Properties properties) throws IOException, CorpusException {
        if (this.remote) {
            throw new CorpusException("remote corpora not implemented yet!");
        }
        Annotation annotation = new Annotation(this);
        return annotation.getInstances(string, properties);
    }

    public CorpusPosition retrieveWord(String string, String string2, int n) throws CorpusException {
        if (this.remote) {
            throw new CorpusException("remote corpora not implemented yet!");
        }
        int n2 = 0;
        while (n2 < this.streams.length) {
            int[] nArray;
            if (this.streams[n2].getName().equals(string2) && (nArray = this.streams[n2].retrieve(string, n)) != null) {
                CorpusPosition corpusPosition = new CorpusPosition(this, nArray);
                return corpusPosition;
            }
            ++n2;
        }
        return null;
    }

    static void writeConfig(String string, Properties properties) throws IOException {
        String string2 = new String(String.valueOf(string) + File.separatorChar + "config");
        File file = new File(string2);
        if (file.exists() && !file.canWrite()) {
            throw new IOException("writeConfig: Cannot overwrite existing file");
        }
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            properties.store(bufferedOutputStream, "CUE Corpus Configuration");
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            throw new IOException("Corpus.writeConfig (while writing vector): " + iOException);
        }
    }
}

