/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Vector;
import uk.ac.bham.clg.cue.corpus.Corpus;
import uk.ac.bham.clg.cue.corpus.CorpusException;
import uk.ac.bham.clg.cue.corpus.Cue;
import uk.ac.bham.clg.cue.corpus.Item;

public class CorpusPosition {
    private Corpus corpus;
    private int[] offset;
    private byte[] tag = null;
    private CollationKey[] key = null;
    private static final boolean DEBUG = false;

    public CorpusPosition(Vector vector) throws NullPointerException {
        if (vector == null || vector.size() < 1) {
            throw new NullPointerException("CorpusPosition 2nd constructor");
        }
        Item item = (Item)vector.elementAt(0);
        this.corpus = item.getCorpus();
        Vector vector2 = new Vector();
        int n = vector.size() - 1;
        while (n >= 0) {
            if (((Item)vector.elementAt(n)).getCorpus() == this.corpus) {
                vector2.addElement(vector.elementAt(n));
                vector.removeElementAt(n);
            }
            --n;
        }
        this.offset = new int[vector2.size()];
        int n2 = 0;
        int n3 = vector2.size() - 1;
        while (n3 >= 0) {
            this.offset[n2++] = ((Item)vector2.elementAt(n3)).getOffset();
            --n3;
        }
        vector2.removeAllElements();
    }

    public CorpusPosition(Corpus corpus, int[] nArray) throws NullPointerException {
        if (corpus == null || nArray == null) {
            throw new NullPointerException("CorpusPosition (constructor)");
        }
        this.corpus = corpus;
        this.offset = nArray;
    }

    public CorpusPosition(Cue cue, ObjectInput objectInput) throws IOException {
        try {
            String string = objectInput.readUTF();
            this.corpus = cue.addCorpus(string);
            this.offset = (int[])objectInput.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException);
        }
    }

    public void calcCollationKeys(int n) {
        Collator collator = this.getCollator();
        if (this.key == null) {
            this.key = new CollationKey[this.offset.length];
        }
        int n2 = 0;
        while (n2 < this.offset.length) {
            String string;
            try {
                String[] stringArray = this.corpus.getContext(this.offset[n2] + n, 1, "text");
                string = stringArray != null && stringArray.length > 0 ? stringArray[0] : "[e]";
            }
            catch (CorpusException corpusException) {
                string = "[e]";
            }
            this.key[n2] = collator.getCollationKey(string);
            ++n2;
        }
    }

    public Cue getApp() {
        return this.corpus.getApp();
    }

    public Collator getCollator() {
        return Collator.getInstance(this.corpus.getLocale());
    }

    public Corpus getCorpus() {
        return this.corpus;
    }

    public Item getItem(int n) {
        if (n < 0 || n >= this.offset.length) {
            return null;
        }
        return new Item(this.corpus, this.offset[n]);
    }

    public CollationKey getKey(int n) throws ArrayIndexOutOfBoundsException {
        if (this.key == null) {
            return null;
        }
        return this.key[n];
    }

    public int getOffset(int n) throws ArrayIndexOutOfBoundsException {
        return this.offset[n];
    }

    public int getSize() {
        return this.offset.length;
    }

    public byte getTag(int n) throws ArrayIndexOutOfBoundsException {
        if (this.tag == null) {
            return 0;
        }
        return this.tag[n];
    }

    public void save(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.corpus.getName());
        objectOutput.writeObject(this.offset);
    }
}

