/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import uk.ac.bham.clg.cue.corpus.Corpus;
import uk.ac.bham.clg.cue.corpus.CorpusException;
import uk.ac.bham.clg.cue.corpus.CorpusPosition;
import uk.ac.bham.clg.cue.corpus.CueAdmin;
import uk.ac.bham.clg.cue.corpus.CueResult;
import uk.ac.bham.clg.cue.corpus.HuffmanCode;
import uk.ac.bham.clg.cue.corpus.ProgressCounter;
import uk.ac.bham.clg.cue.corpus.query.ParseError;
import uk.ac.bham.clg.cue.corpus.query.QueryNode;
import uk.ac.bham.clg.cue.corpus.query.QueryNodeEnumerator;
import uk.ac.bham.clg.cue.corpus.query.QueryParser;
import uk.ac.bham.clg.util.EnumerationSequence;
import uk.ac.bham.clg.util.ISO2UTF;
import uk.ac.bham.clg.util.options.ValueModel;
import uk.ac.bham.clg.util.parser.OptionParser;

public class Cue {
    public static final boolean DEBUG = false;
    private CueAdmin admin = CueAdmin.getInstance();
    private String[] corpusList = null;
    private int corpusSize;
    private int leftSpan;
    private int rightSpan;
    private Properties corpusLocations = null;
    private Hashtable corpusTable = null;
    private Hashtable codeTable = null;
    private Hashtable optionTable = null;
    private Properties systemSettings = null;

    public Cue() throws FileNotFoundException {
        Properties properties = System.getProperties();
        this.corpusList = this.admin.getAvailableCorpora();
        try {
            FileReader fileReader = new FileReader(String.valueOf(this.admin.getLibDir()) + "/cue-options.sgml");
            this.readOptions(fileReader);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    private HuffmanCode addCode(String string) {
        HuffmanCode huffmanCode = null;
        if (this.codeTable != null && this.codeTable.containsKey(string)) {
            huffmanCode = (HuffmanCode)this.codeTable.get(string);
        } else {
            if (this.codeTable == null) {
                this.codeTable = new Hashtable();
            }
            try {
                huffmanCode = new HuffmanCode(this, string);
                this.codeTable.put(string, huffmanCode);
            }
            catch (IOException iOException) {
                System.err.println("Cue.addCode " + iOException.toString());
                huffmanCode = null;
            }
        }
        return huffmanCode;
    }

    public int addCorpora(String[] stringArray) {
        if (stringArray == null) {
            return 0;
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < stringArray.length) {
            Corpus corpus = this.addCorpus(stringArray[n2]);
            if (corpus != null) {
                --n;
            }
            ++n2;
        }
        return n;
    }

    public Corpus addCorpus(String string) {
        Corpus corpus;
        boolean bl = false;
        if (this.corpusTable != null && this.corpusTable.containsKey(string)) {
            corpus = (Corpus)this.corpusTable.get(string);
            corpus.activate();
        } else {
            if (this.corpusTable == null) {
                this.corpusTable = new Hashtable();
            }
            if (this.inArray(this.corpusList, string)) {
                try {
                    corpus = new Corpus(this, string);
                    this.corpusTable.put(string, corpus);
                }
                catch (CorpusException corpusException) {
                    System.err.println("addCorpus() " + corpusException.toString());
                    corpus = null;
                }
            } else {
                corpus = null;
            }
        }
        return corpus;
    }

    public boolean getActive(String string) {
        Corpus corpus = this.corpusTable == null ? null : (Corpus)this.corpusTable.get(string);
        if (corpus != null) {
            return corpus.isActive();
        }
        return false;
    }

    public Vector getActiveCorpora() {
        if (this.corpusTable == null) {
            return null;
        }
        Vector<Corpus> vector = new Vector<Corpus>();
        Enumeration enumeration = this.corpusTable.elements();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Corpus corpus = (Corpus)enumeration.nextElement();
                if (corpus == null || !corpus.isActive()) continue;
                vector.addElement(corpus);
            }
        }
        return vector;
    }

    public String[] getActiveCorporaNames() {
        Vector vector = this.getActiveCorpora();
        if (vector != null && vector.size() > 0) {
            String[] stringArray = new String[vector.size()];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = ((Corpus)vector.elementAt(n)).getName();
                ++n;
            }
            return stringArray;
        }
        return null;
    }

    public String[] getAvailableCorpora() {
        return this.admin.getAvailableCorpora();
    }

    public String getCodeDir() {
        return this.admin.getCodeDir();
    }

    public Corpus getCorpus(String string) {
        Corpus corpus = this.corpusTable == null ? null : (Corpus)this.corpusTable.get(string);
        return corpus;
    }

    public String getCorpusDir() {
        return this.admin.getCorpusDir();
    }

    public Properties getCorpusProperties(String string) {
        return this.admin.getCorpusProperties(string);
    }

    public int getFreq(String string) {
        int n = 0;
        Vector vector = this.getActiveCorpora();
        int n2 = 0;
        while (n2 < vector.size()) {
            try {
                Corpus corpus = (Corpus)vector.elementAt(n2);
                n += corpus.getFreq(string);
            }
            catch (CorpusException corpusException) {
                System.err.println("Cue.getFreq() " + corpusException.toString());
            }
            ++n2;
        }
        return n;
    }

    public String getHomeDir() {
        return this.admin.getHomeDir();
    }

    public String getLibDir() {
        return this.admin.getLibDir();
    }

    public int getSize() {
        int n = 0;
        Vector vector = this.getActiveCorpora();
        if (vector != null) {
            int n2 = 0;
            while (n2 < vector.size()) {
                Corpus corpus = (Corpus)vector.elementAt(n2);
                n += corpus.getSize();
                ++n2;
            }
        }
        return n;
    }

    public int[] getSpan() {
        int[] nArray = new int[]{this.leftSpan, this.rightSpan};
        return nArray;
    }

    public Object getValue(String string) throws NullPointerException {
        if (string == null) {
            throw new NullPointerException("empty request");
        }
        ValueModel valueModel = (ValueModel)this.optionTable.get(string);
        if (valueModel == null) {
            return null;
        }
        return valueModel.getValue();
    }

    public ValueModel getValueModel(String string) {
        if (string == null) {
            throw new NullPointerException("empty request");
        }
        ValueModel valueModel = (ValueModel)this.optionTable.get(string);
        if (valueModel == null) {
            System.err.println("Unable to get ValueModel " + string);
        }
        return valueModel;
    }

    public boolean inArray(String[] stringArray, String string) {
        if (stringArray == null || string == null) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static void main(String[] stringArray) throws FileNotFoundException {
        Cue cue = new Cue();
        String[] stringArray2 = cue.getAvailableCorpora();
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println(stringArray2[n]);
            ++n;
        }
    }

    public Enumeration query(String string) throws ParseError {
        return this.query(string, null);
    }

    public Enumeration query(String string, ProgressCounter progressCounter) throws ParseError {
        Object object;
        Vector vector = this.getActiveCorpora();
        if (vector == null) {
            return null;
        }
        Object var4_4 = null;
        Vector<QueryNodeEnumerator> vector2 = new Vector<QueryNodeEnumerator>(vector.size());
        if (string.indexOf(38) > -1) {
            try {
                object = ISO2UTF.getInstance();
                string = ((ISO2UTF)object).convertString(string);
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }
        if (progressCounter != null) {
            progressCounter.setMinimum(0);
            progressCounter.setMaximum(vector.size() - 1);
            progressCounter.start("Executing Query");
        }
        int n = 0;
        while (n < vector.size()) {
            Corpus corpus;
            String string2;
            if (progressCounter != null) {
                if (progressCounter.isCanceled()) break;
                progressCounter.inc();
            }
            object = (string2 = (corpus = (Corpus)vector.elementAt(n)).getTextTags()) != null && string.indexOf("within") < 0 ? QueryParser.parseQuery("(" + string + ") within(" + string2 + ")") : QueryParser.parseQuery(string);
            QueryNode queryNode = ((QueryNode)object).instantiate(corpus);
            QueryNodeEnumerator queryNodeEnumerator = new QueryNodeEnumerator(queryNode);
            vector2.addElement(queryNodeEnumerator);
            ++n;
        }
        return new EnumerationSequence(vector2);
    }

    public static int readInt(RandomAccessFile randomAccessFile, int n) throws IOException {
        if (randomAccessFile == null) {
            throw new IOException("Cue.readInt: invalid file pointer");
        }
        try {
            randomAccessFile.seek(n * 4);
        }
        catch (IOException iOException) {
            throw new IOException("Cue.readInt (seek): " + iOException);
        }
        try {
            int n2 = randomAccessFile.readInt();
            return n2;
        }
        catch (IOException iOException) {
            throw new IOException("Cue.readInt (read): " + iOException);
        }
    }

    private void readOptions(InputStreamReader inputStreamReader) throws IOException {
        if (this.optionTable == null) {
            this.optionTable = new Hashtable();
        }
        OptionParser optionParser = new OptionParser(inputStreamReader);
        try {
            ValueModel valueModel;
            while ((valueModel = new ValueModel(optionParser)) != null) {
                this.optionTable.put(valueModel.getName(), valueModel);
            }
        }
        catch (uk.ac.bham.clg.util.parser.ParseError parseError) {
            System.err.println(parseError);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException);
        }
        catch (IOException iOException) {
        }
    }

    public CueResult retrieve(String string, int n) {
        Object object;
        Object object2;
        if (string.indexOf(38) > -1) {
            try {
                object2 = ISO2UTF.getInstance();
                string = ((ISO2UTF)object2).convertString(string);
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }
        object2 = this.getActiveCorpora();
        CorpusPosition corpusPosition = null;
        Vector<CorpusPosition> vector = new Vector<CorpusPosition>(((Vector)object2).size());
        int n2 = 0;
        while (n2 < ((Vector)object2).size() && n != 0) {
            object = (Corpus)((Vector)object2).elementAt(n2);
            try {
                corpusPosition = ((Corpus)object).retrieveWord(string, "text", n);
                if (corpusPosition != null) {
                    vector.addElement(corpusPosition);
                    if (n != -1) {
                        n -= corpusPosition.getSize();
                    }
                }
            }
            catch (CorpusException corpusException) {
                System.err.println("Cue.retrieve(" + string + "): " + corpusException);
            }
            ++n2;
        }
        object = new CorpusPosition[vector.size()];
        vector.copyInto((Object[])object);
        CueResult cueResult = new CueResult((CorpusPosition[])object);
        return cueResult;
    }

    public boolean setActive(String string, boolean bl) {
        Corpus corpus = this.corpusTable == null ? null : (Corpus)this.corpusTable.get(string);
        if (corpus != null) {
            if (bl) {
                corpus.activate();
            } else {
                corpus.deactivate();
            }
        } else if (bl) {
            return this.addCorpus(string) != null;
        }
        return true;
    }

    public void setSpan(int n, int n2) {
        this.leftSpan = n;
        this.rightSpan = n2;
    }

    public boolean setValue(String string, Object object) {
        if (string == null) {
            throw new NullPointerException("empty request");
        }
        ValueModel valueModel = (ValueModel)this.optionTable.get(string);
        if (valueModel != null) {
            return valueModel.setValue(object);
        }
        return false;
    }
}

