/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import uk.ac.bham.clg.cue.corpus.CodeGen;
import uk.ac.bham.clg.cue.corpus.Corpus;
import uk.ac.bham.clg.cue.corpus.CueAdmin;
import uk.ac.bham.clg.cue.corpus.TextEncoder;
import uk.ac.bham.clg.cue.corpus.TextIndexer;
import uk.ac.bham.clg.cue.corpus.TextResource;
import uk.ac.bham.clg.cue.corpus.TextVerifier;
import uk.ac.bham.clg.cue.utils.WordListResource;

public class CueAdd {
    static final boolean DEBUG = false;
    static final boolean VERBOSE = true;
    static final String DEFAULT_LANGUAGE = "en";
    private CueAdmin admin = CueAdmin.getInstance();
    String inputFile = null;
    String corpusName = null;
    String corpusLabel = null;
    int streamColumn = 0;
    String streamName = "text";
    boolean indexStream = true;

    public CueAdd(String string, String string2, String string3) throws RuntimeException {
        Object object;
        Object object2;
        int n;
        Object object3;
        File file = new File(string);
        if (file.isDirectory()) {
            System.err.println("CueAdd: directory mode not implemented yet");
        }
        if (!(file.exists() && file.isFile() && file.canRead())) {
            throw new RuntimeException("CueAdd failed: can't open input file");
        }
        String string4 = this.admin.getCorpusDir();
        String string5 = String.valueOf(string4) + File.separatorChar + string2;
        file = new File(string4);
        if (!file.canWrite()) {
            throw new RuntimeException("CueAdd failed: cannot write in " + string4);
        }
        Object object4 = new File(string5);
        if (((File)object4).exists()) {
            object3 = ((File)object4).list();
            n = 0;
            while (n < ((String[])object3).length) {
                object2 = new File(String.valueOf(string5) + File.separatorChar + object3[n]);
                ((File)object2).delete();
                ++n;
            }
        } else {
            ((File)object4).mkdir();
        }
        if (!((File)object4).exists()) {
            throw new RuntimeException("CueAdd failed: cannot create " + string5);
        }
        if (string3 == null) {
            string3 = String.valueOf(string2) + "-code";
        }
        object4 = this.admin.getCodeDir();
        System.err.println("Generating code");
        file = new File((String)object4);
        if (!file.canWrite()) {
            throw new RuntimeException("CueAdd failed: cannot write in " + (String)object4);
        }
        try {
            object3 = new CodeGen(string, string3, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            throw new RuntimeException("CueAdd failed: i/o problem with code");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(System.err);
            throw new RuntimeException("CueAdd failed: index problem with code");
        }
        object3 = new Properties();
        ((Hashtable)object3).put("name", string2);
        ((Hashtable)object3).put("label", string2.toUpperCase());
        ((Hashtable)object3).put("description", "[description goes here]");
        ((Hashtable)object3).put("language", DEFAULT_LANGUAGE);
        ((Hashtable)object3).put("revision", "1");
        ((Hashtable)object3).put("stream-1", "text|128|" + string3);
        System.err.println("Encoding file");
        n = 0;
        try {
            object2 = new TextResource(string);
            object = new TextEncoder((WordListResource)object2, string3, "text", String.valueOf(string5) + File.separatorChar + string2);
            n = ((TextEncoder)object).getSize();
            ((Hashtable)object3).put("size", String.valueOf(n));
            System.err.println("size=" + n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            throw new RuntimeException("CueAdd failed: encoding problem: " + iOException);
        }
        try {
            Corpus.writeConfig(string5, (Properties)object3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            throw new RuntimeException("CueAdd failed: config creation problem:" + iOException);
        }
        System.err.println("Verifying the encoding");
        try {
            object2 = new TextResource(string);
            object = new TextVerifier((WordListResource)object2, string2, string5, "text", string3, n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            throw new RuntimeException("CueAdd failed: verifier error:" + iOException);
        }
        System.err.println("Indexing file");
        try {
            object2 = new TextIndexer(string2, string5, "text", string3, n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            throw new RuntimeException("CueAdd failed: indexing problem:" + iOException);
        }
        try {
            Corpus.writeConfig(string5, (Properties)object3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            throw new RuntimeException("CueAdd failed: config creation problem:" + iOException);
        }
        System.err.println("Indexing tags");
        file = new File(String.valueOf(string5) + File.separatorChar + "tags");
        if (file.exists()) {
            System.err.println("Keeping existing tag files");
        } else {
            file.mkdir();
        }
        if (!file.exists()) {
            throw new RuntimeException("CueAdd failed: cannot create " + string5);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2 && stringArray.length != 3) {
            System.err.println("Usage: CueAdd inputFile corpusName (codename)");
            System.exit(1);
        }
        String string = stringArray.length == 3 ? stringArray[2] : null;
        CueAdd cueAdd = new CueAdd(stringArray[0], stringArray[1], string);
    }
}

