/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import uk.ac.bham.clg.cue.corpus.Corpus;
import uk.ac.bham.clg.cue.corpus.CorpusException;

public class CueAdmin {
    private static CueAdmin instance = null;
    private String cueDir = null;
    private String libDir = null;
    private String corpusDir = null;
    private String codeDir = null;
    private String tmpDir = null;
    private String[] corpusList = null;
    private Properties systemSettings = null;

    private CueAdmin() throws FileNotFoundException {
        Properties properties = System.getProperties();
        this.cueDir = properties.getProperty("cue.home", ".");
        File file = new File(this.cueDir);
        if (!(file.exists() || file.isDirectory() || file.canRead())) {
            throw new FileNotFoundException(this.cueDir);
        }
        try {
            this.cueDir = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            System.err.println("CueAdmin: " + iOException);
            this.cueDir = file.getAbsolutePath();
        }
        this.codeDir = String.valueOf(this.cueDir) + "/codes";
        file = new File(this.codeDir);
        if (!(file.exists() || file.isDirectory() || file.canRead())) {
            throw new FileNotFoundException(this.codeDir);
        }
        this.libDir = String.valueOf(this.cueDir) + "/lib";
        file = new File(this.libDir);
        if (!(file.exists() || file.isDirectory() || file.canRead())) {
            throw new FileNotFoundException(this.libDir);
        }
        this.tmpDir = properties.getProperty("tmp", String.valueOf(this.cueDir) + "/tmp");
        file = new File(this.tmpDir);
        if (!(file.exists() || file.isDirectory() || file.canRead())) {
            throw new FileNotFoundException(this.tmpDir);
        }
        this.corpusDir = String.valueOf(this.cueDir) + "/corpora";
        file = new File(this.corpusDir);
        if (!(file.exists() || file.isDirectory() || file.canRead())) {
            throw new FileNotFoundException(this.corpusDir);
        }
        this.corpusList = file.list();
        this.systemSettings = this.readConfiguration(String.valueOf(this.libDir) + "config");
        if (this.corpusList == null || this.corpusList.length == 0) {
            System.err.println("Did not find any corpora in " + this.corpusDir);
        }
    }

    public String[] getAvailableCorpora() {
        return this.corpusList;
    }

    public String getCodeDir() {
        return this.codeDir;
    }

    public String getCorpusDir() {
        return this.corpusDir;
    }

    public Properties getCorpusProperties(String string) {
        String string2 = String.valueOf(this.corpusDir) + "/" + string;
        try {
            Properties properties = Corpus.readConfig(string2);
            return properties;
        }
        catch (CorpusException corpusException) {
            return null;
        }
    }

    public String getHomeDir() {
        return this.cueDir;
    }

    public static CueAdmin getInstance() {
        try {
            if (instance == null) {
                instance = new CueAdmin();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException);
            System.exit(1);
        }
        return instance;
    }

    public String getLibDir() {
        return this.libDir;
    }

    public String getProperty(String string) {
        if (this.systemSettings == null) {
            return null;
        }
        String string2 = this.systemSettings.getProperty(string);
        return string2;
    }

    public String getProperty(String string, String string2) {
        String string3 = this.systemSettings.getProperty(string, string2);
        return string3;
    }

    public String getTmpDir() {
        return this.tmpDir;
    }

    private Properties readConfiguration(String string) {
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(new BufferedInputStream(fileInputStream));
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            properties = null;
        }
        catch (IOException iOException) {
            System.err.println("Cue.readConfiguration(" + string + "): " + iOException);
            properties = null;
        }
        return properties;
    }
}

