/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.CollationKey;
import java.text.Collator;
import uk.ac.bham.clg.cue.corpus.CorpusException;
import uk.ac.bham.clg.cue.corpus.CorpusPosition;
import uk.ac.bham.clg.cue.corpus.Cue;
import uk.ac.bham.clg.cue.corpus.Item;
import uk.ac.bham.clg.cue.corpus.ProgressCounter;

public class CueResult {
    private CorpusPosition[] positions = null;
    private int[] cumFreq = null;
    private static final boolean DEBUG = false;

    public CueResult(Cue cue, ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        this.positions = new CorpusPosition[n];
        int n2 = 0;
        while (n2 < n) {
            this.positions[n2] = new CorpusPosition(cue, objectInput);
            ++n2;
        }
        this.cumFreq = new int[this.positions.length + 1];
        this.cumFreq[0] = 0;
        int n3 = 1;
        while (n3 < this.cumFreq.length) {
            this.cumFreq[n3] = this.cumFreq[n3 - 1] + this.positions[n3 - 1].getSize();
            ++n3;
        }
    }

    public CueResult(CorpusPosition[] corpusPositionArray) throws NullPointerException {
        int n;
        if (corpusPositionArray == null) {
            throw new NullPointerException("empty data");
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < corpusPositionArray.length) {
            if (corpusPositionArray[n3] == null) {
                ++n2;
            }
            ++n3;
        }
        if (n2 == 0) {
            this.positions = corpusPositionArray;
        } else {
            n = 0;
            this.positions = new CorpusPosition[corpusPositionArray.length - n2];
            int n4 = 0;
            while (n4 < corpusPositionArray.length) {
                if (corpusPositionArray[n4] != null) {
                    this.positions[n++] = corpusPositionArray[n4];
                }
                ++n4;
            }
        }
        this.cumFreq = new int[this.positions.length + 1];
        this.cumFreq[0] = 0;
        n = 1;
        while (n < this.cumFreq.length) {
            this.cumFreq[n] = this.cumFreq[n - 1] + this.positions[n - 1].getSize();
            ++n;
        }
    }

    public boolean calcCollationKeys(int n, ProgressCounter progressCounter) {
        int n2 = 0;
        while (n2 < this.positions.length) {
            if (progressCounter != null) {
                progressCounter.inc();
                if (progressCounter.isCanceled()) {
                    return false;
                }
            }
            this.positions[n2].calcCollationKeys(n);
            ++n2;
        }
        return true;
    }

    public Cue getApp() {
        return this.positions[0].getApp();
    }

    public Collator getCollator() {
        return this.positions[0].getCollator();
    }

    public String getContext(int n, String[] stringArray, String[] stringArray2) {
        try {
            Item item = this.getItem(n);
            if (item == null) {
                return null;
            }
            String[] stringArray3 = item.getContext(stringArray.length, stringArray2.length, "text");
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = stringArray3[n2];
                ++n2;
            }
            int n3 = stringArray.length + 1;
            int n4 = 0;
            while (n4 < stringArray2.length) {
                stringArray2[n4] = stringArray3[n3 + n4];
                ++n4;
            }
            return stringArray3[stringArray.length];
        }
        catch (CorpusException corpusException) {
            return null;
        }
    }

    public Item getItem(int n) {
        if (n >= 0) {
            int n2 = 0;
            while (n2 < this.positions.length) {
                if (n < this.positions[n2].getSize()) {
                    return this.positions[n2].getItem(n);
                }
                n -= this.positions[n2].getSize();
                ++n2;
            }
        }
        return null;
    }

    public CollationKey getKey(int n) {
        if (n >= 0) {
            int n2 = 0;
            while (n2 < this.positions.length) {
                if (n < this.positions[n2].getSize()) {
                    return this.positions[n2].getKey(n);
                }
                n -= this.positions[n2].getSize();
                ++n2;
            }
        }
        return null;
    }

    public String[] getKwicLines(int[] nArray, int n) {
        if (nArray == null) {
            return null;
        }
        String[] stringArray = new String[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            Item item = this.getItem(nArray[n2]);
            if (item != null) {
                try {
                    stringArray[n2] = item.getKwic(n);
                    if (stringArray[n2] == null) {
                        stringArray[n2] = "-*- empty -*-";
                    }
                }
                catch (CorpusException corpusException) {
                    stringArray[n2] = new String("<<Exception: " + corpusException + ">>");
                }
            }
            ++n2;
        }
        return stringArray;
    }

    public int getSize() {
        return this.cumFreq[this.cumFreq.length - 1];
    }

    public byte getTag(int n) {
        if (n >= 0) {
            int n2 = 0;
            while (n2 < this.positions.length) {
                if (n < this.positions[n2].getSize()) {
                    return this.positions[n2].getTag(n);
                }
                n -= this.positions[n2].getSize();
                ++n2;
            }
        }
        return 0;
    }

    public String getWordOffset(int n, int n2) {
        Item item = this.getItem(n);
        if (item != null) {
            return item.getWord(n2);
        }
        return "[e]";
    }

    public void save(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.positions.length);
        int n = 0;
        while (n < this.positions.length) {
            this.positions[n].save(objectOutput);
            ++n;
        }
    }
}

