/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import uk.ac.bham.clg.cue.corpus.Corpus;
import uk.ac.bham.clg.cue.corpus.CorpusException;

class DocumentEnumeration
implements Enumeration {
    private int currentPosition = 0;
    private int lastPosition = 0;
    private Corpus sourceCorpus;

    DocumentEnumeration(Corpus corpus, int n, int n2) {
        this.sourceCorpus = corpus;
        this.currentPosition = n;
        this.lastPosition = n2;
    }

    public boolean hasMoreElements() {
        return this.currentPosition <= this.lastPosition;
    }

    public Object nextElement() {
        if (this.currentPosition > this.lastPosition) {
            throw new NoSuchElementException("End of Document reached");
        }
        try {
            String[] stringArray = this.sourceCorpus.getContext(this.currentPosition, 1, "text");
            ++this.currentPosition;
            if (stringArray == null) {
                return null;
            }
            return stringArray[0];
        }
        catch (CorpusException corpusException) {
            return null;
        }
    }
}

