/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class Heap {
    protected static final int MINHEAP = 0;
    protected static final int MAXHEAP = 1;
    protected static final boolean DEBUG = false;
    private int[] A;
    private int h;
    private int n;
    private int[] numberLength;
    private byte[] length = null;
    private int[] firstCode;
    private int[] symbolIndex;
    private int[] nextCode;
    private int[] codeWord = null;
    private int[] symbol = null;

    protected Heap(int n, DataInputStream dataInputStream) {
        this.n = n;
        this.h = this.n - 1;
        this.A = new int[n * 2];
        try {
            int n2 = 0;
            while (n2 < n) {
                this.A[this.n + n2] = dataInputStream.readInt();
                this.A[n2] = this.n + n2;
                ++n2;
            }
        }
        catch (IOException iOException) {
            System.err.println("Heap: " + iOException + " while reading " + n + " items");
        }
    }

    protected void buildCodeTree() throws IndexOutOfBoundsException {
        while (this.h > 0) {
            int n = this.A[0];
            this.A[0] = this.A[this.h];
            --this.h;
            this.sift(0, this.h, 0);
            int n2 = this.A[0];
            this.A[this.h + 1] = this.A[n] + this.A[n2];
            this.A[0] = this.h + 1;
            this.A[n] = this.h + 1;
            this.A[n2] = this.h + 1;
            this.sift(0, this.h, 0);
        }
        this.A[1] = 0;
        int n = 2;
        while (n < 2 * this.n) {
            this.A[n] = this.A[this.A[n]] + 1;
            ++n;
        }
        byte by = 0;
        this.length = new byte[this.n];
        this.codeWord = new int[this.n];
        this.symbol = new int[this.n];
        this.firstCode = new int[33];
        this.symbolIndex = new int[33];
        this.nextCode = new int[33];
        int[] nArray = new int[33];
        int n3 = 0;
        while (n3 < 33) {
            this.nextCode[n3] = 0;
            this.firstCode[n3] = 0;
            this.symbolIndex[n3] = 0;
            nArray[n3] = 0;
            ++n3;
        }
        n3 = 0;
        while (n3 < this.n) {
            this.length[n3] = (byte)this.A[this.n + n3];
            if (by < this.length[n3]) {
                by = this.length[n3];
            }
            if (by > 32) {
                throw new IndexOutOfBoundsException("Maximal codelength is " + by + " and thus larger than 32 bits");
            }
            byte by2 = this.length[n3];
            nArray[by2] = nArray[by2] + 1;
            ++n3;
        }
        this.firstCode[by] = 0;
        this.nextCode[by] = 0;
        n3 = by - 1;
        while (n3 > 0) {
            this.firstCode[n3] = (this.firstCode[n3 + 1] + nArray[n3 + 1]) / 2;
            this.nextCode[n3] = this.firstCode[n3];
            --n3;
        }
        n3 = 2;
        while (n3 < 33) {
            this.symbolIndex[n3] = this.symbolIndex[n3 - 1] + nArray[n3 - 1];
            ++n3;
        }
        n3 = 0;
        while (n3 < this.n) {
            byte by3 = this.length[n3];
            this.codeWord[n3] = this.nextCode[by3];
            this.symbol[this.symbolIndex[by3] + this.nextCode[by3] - this.firstCode[by3]] = n3++;
            byte by4 = by3;
            this.nextCode[by4] = this.nextCode[by4] + 1;
        }
    }

    private void recursive_sort(int n, int n2, int n3) {
        int n4 = (n + 1) * 2 - 1;
        int n5 = n4 + 1;
        if (n4 < n2) {
            this.recursive_sort(n4, n2, n3);
        }
        if (n5 < n2) {
            this.recursive_sort(n5, n2, n3);
        }
        this.sift(n, n2, n3);
    }

    protected void sift(int n, int n2, int n3) {
        if (n >= n2) {
            return;
        }
        if (n3 != 0 && n3 != 1) {
            System.err.println("Illegal mode value for sift.  Assuming MINHEAP");
            n3 = 0;
        }
        int n4 = (n + 1) * 2 - 1;
        int n5 = n4 + 1;
        int n6 = 0;
        if (n4 > n2) {
            if (n5 > n2) {
                return;
            }
            if (n3 == 0 && this.A[this.A[n]] > this.A[this.A[n5]] || n3 == 1 && this.A[this.A[n]] < this.A[this.A[n5]]) {
                n6 = this.A[n];
                this.A[n] = this.A[n5];
                this.A[n5] = n6;
                this.sift(n5, n2, n3);
            }
            return;
        }
        if (n5 > n2) {
            if (n4 > n2) {
                return;
            }
            if (n3 == 0 && this.A[this.A[n]] > this.A[this.A[n4]] || n3 == 1 && this.A[this.A[n]] < this.A[this.A[n4]]) {
                n6 = this.A[n];
                this.A[n] = this.A[n4];
                this.A[n4] = n6;
                this.sift(n4, n2, n3);
            }
            return;
        }
        switch (n3) {
            case 0: {
                int n7;
                int n8 = n7 = this.A[this.A[n4]] < this.A[this.A[n5]] ? n4 : n5;
                if (this.A[this.A[n7]] < this.A[this.A[n]]) {
                    n6 = this.A[n];
                    this.A[n] = this.A[n7];
                    this.A[n7] = n6;
                    this.sift(n7, n2, n3);
                }
                return;
            }
            case 1: {
                int n9;
                int n10 = n9 = this.A[this.A[n4]] > this.A[this.A[n5]] ? n4 : n5;
                if (this.A[this.A[n9]] > this.A[this.A[n]]) {
                    n6 = this.A[n];
                    this.A[n] = this.A[n9];
                    this.A[n9] = n6;
                    this.sift(n9, n2, n3);
                }
                return;
            }
        }
        System.err.println("Heap.sift: /*NOTREACHED*/ in switch");
    }

    protected void sort(int n) {
        this.recursive_sort(0, this.h, n);
    }

    protected void writeCode(String string) throws IOException {
        int n;
        OutputStream outputStream;
        String string2 = new String(String.valueOf(string) + ".cdw");
        String string3 = new String(String.valueOf(string) + ".clg");
        String string4 = new String(String.valueOf(string) + ".sym");
        String string5 = new String(String.valueOf(string) + ".six");
        String string6 = new String(String.valueOf(string) + ".1st");
        try {
            outputStream = new DataOutputStream(new FileOutputStream(string2));
            n = 0;
            while (n < this.codeWord.length) {
                ((DataOutputStream)outputStream).writeInt(this.codeWord[n]);
                ++n;
            }
            ((FilterOutputStream)outputStream).close();
        }
        catch (IOException iOException) {
            System.err.println("Error writing " + string2);
        }
        try {
            outputStream = new FileOutputStream(string3);
            ((FileOutputStream)outputStream).write(this.length);
            ((FileOutputStream)outputStream).close();
        }
        catch (IOException iOException) {
            System.err.println("Error writing " + string3);
        }
        try {
            outputStream = new DataOutputStream(new FileOutputStream(string4));
            n = 0;
            while (n < this.symbol.length) {
                ((DataOutputStream)outputStream).writeInt(this.symbol[n]);
                ++n;
            }
            ((FilterOutputStream)outputStream).close();
        }
        catch (IOException iOException) {
            System.err.println("Error writing " + string4);
        }
        try {
            outputStream = new DataOutputStream(new FileOutputStream(string5));
            n = 0;
            while (n < this.symbolIndex.length) {
                ((DataOutputStream)outputStream).writeInt(this.symbolIndex[n]);
                ++n;
            }
            ((FilterOutputStream)outputStream).close();
        }
        catch (IOException iOException) {
            System.err.println("Error writing " + string5);
        }
        try {
            outputStream = new DataOutputStream(new FileOutputStream(string6));
            n = 0;
            while (n < this.firstCode.length) {
                ((DataOutputStream)outputStream).writeInt(this.firstCode[n]);
                ++n;
            }
            ((FilterOutputStream)outputStream).close();
        }
        catch (IOException iOException) {
            System.err.println("Error writing " + string6);
        }
    }
}

