/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import uk.ac.bham.clg.cue.corpus.Cue;
import uk.ac.bham.clg.cue.corpus.CueAdmin;
import uk.ac.bham.clg.cue.corpus.SimpleIndex;
import uk.ac.bham.clg.cue.utils.WordIndex;

public class HuffmanCode {
    private static final boolean DEBUG = false;
    static final int MAXCODEWLEN = 32;
    private String name = null;
    private int size = -1;
    private Cue application = null;
    private WordIndex wordIndex = null;
    private int[] symbolIndex = null;
    private int[] indexIndex = null;
    private int[] first = null;

    public HuffmanCode(Cue cue, String string) throws IOException {
        DataInputStream dataInputStream;
        this.name = string;
        this.application = cue;
        CueAdmin cueAdmin = CueAdmin.getInstance();
        String string2 = cueAdmin.getCodeDir();
        try {
            this.wordIndex = new SimpleIndex(String.valueOf(string2) + File.separator + this.name);
        }
        catch (IOException iOException) {
            throw new IOException("HuffmanCode (index init): " + iOException);
        }
        File file = new File(String.valueOf(string2) + File.separator + this.name + ".sym");
        this.size = (int)(file.length() / 4L);
        this.indexIndex = new int[this.size];
        try {
            dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(String.valueOf(string2) + File.separator + this.name + ".sym")));
            int n = 0;
            while (n < this.size) {
                this.indexIndex[n] = dataInputStream.readInt();
                ++n;
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            throw new IOException("HuffmanCode (read SYMbol list): " + iOException);
        }
        this.symbolIndex = new int[32];
        this.first = new int[32];
        try {
            dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(String.valueOf(string2) + File.separator + this.name + ".1st")));
            DataInputStream dataInputStream2 = new DataInputStream(new BufferedInputStream(new FileInputStream(String.valueOf(string2) + File.separator + this.name + ".six")));
            int n = 0;
            while (n < 32) {
                this.symbolIndex[n] = dataInputStream2.readInt();
                this.first[n] = dataInputStream.readInt();
                ++n;
            }
            dataInputStream2.close();
            dataInputStream.close();
        }
        catch (IOException iOException) {
            throw new IOException("HuffmanCode (1st/six init): " + iOException);
        }
    }

    public int decode(int n, int n2) {
        if (n2 < 1 && n2 > 32) {
            return -1;
        }
        if (n < this.first[n2]) {
            return -1;
        }
        return this.indexIndex[this.symbolIndex[n2] + n - this.first[n2]];
    }

    public int first(int n) {
        if (n <= 0 || n > this.first.length) {
            return 0;
        }
        return this.first[n - 1];
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public int getSymbol(int n, int n2) {
        int n3 = this.index(n2);
        int n4 = this.symbol(n3 + n - this.first[n2]);
        return n4;
    }

    public int index(int n) {
        if (n < 0 || n >= this.indexIndex.length) {
            return -1;
        }
        return this.indexIndex[n];
    }

    public boolean isValid(int n, int n2) {
        return n2 <= 32 && n < this.first[n2];
    }

    public int[] starMatch(int n, String string, String string2, String string3) throws IllegalArgumentException {
        Object object;
        Enumeration enumeration;
        switch (n) {
            case 1: {
                if (string3 != null) break;
                throw new IllegalArgumentException("empty suffix");
            }
            case 2: {
                if (string != null) break;
                throw new IllegalArgumentException("empty prefix");
            }
            case 3: {
                if (string2 != null) break;
                throw new IllegalArgumentException("empty infix");
            }
            case 4: {
                if (string != null && string3 != null) break;
                throw new IllegalArgumentException("empty circumfix");
            }
            default: {
                throw new IllegalArgumentException("illegal mode (" + n + ")");
            }
        }
        if ((enumeration = this.wordIndex.getWords()) == null) {
            System.err.println("Cannot access word index");
            return null;
        }
        Vector<Integer> vector = new Vector<Integer>();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (object != null) {
                switch (n) {
                    case 1: {
                        if (!((String)object).endsWith(string3)) break;
                        vector.addElement(new Integer(n2));
                        break;
                    }
                    case 2: {
                        if (!((String)object).startsWith(string)) break;
                        vector.addElement(new Integer(n2));
                        break;
                    }
                    case 3: {
                        if (((String)object).indexOf(string2) <= -1) break;
                        vector.addElement(new Integer(n2));
                        break;
                    }
                    case 4: {
                        if (!((String)object).startsWith(string) || !((String)object).endsWith(string3) || ((String)object).length() < string.length() + string3.length()) break;
                        vector.addElement(new Integer(n2));
                        break;
                    }
                }
            }
            ++n2;
        }
        object = new int[vector.size()];
        int n3 = 0;
        while (n3 < ((int[])object).length) {
            object[n3] = (Integer)vector.elementAt(n3);
            ++n3;
        }
        return object;
    }

    public String string(int n) {
        return this.wordIndex.indexLookup(n);
    }

    public int symbol(int n) {
        if (n < 0 || n >= this.symbolIndex.length) {
            return -1;
        }
        return this.symbolIndex[n];
    }

    public int translate(String string) {
        int n = this.wordIndex.wordLookup(string);
        return n;
    }

    public int[] translate(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            nArray[n] = this.wordIndex.wordLookup(stringArray[n]);
            ++n;
        }
        return nArray;
    }
}

