/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus;

import uk.ac.bham.clg.cue.corpus.Corpus;
import uk.ac.bham.clg.cue.corpus.CorpusException;

public class Item {
    private Corpus corpus;
    private int offset;
    private static final boolean DEBUG = false;

    public Item(Corpus corpus, int n) throws NullPointerException, IllegalArgumentException {
        if (corpus == null) {
            throw new NullPointerException("Item (constructor): Corpus is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Item (constructor): Offset=" + n);
        }
        this.corpus = corpus;
        this.offset = n;
    }

    public String[] getContext(int n, int n2) throws CorpusException {
        return this.corpus.getContext(this.offset - n, n + n2 + 1, "text");
    }

    public String[] getContext(int n, int n2, String string) throws CorpusException {
        String[] stringArray = this.corpus.getContext(this.offset - n, n + n2 + 1, string);
        return stringArray;
    }

    public Corpus getCorpus() {
        return this.corpus;
    }

    public String getKwic(int n) throws CorpusException {
        return this.corpus.getKwic(this.offset, n, "text");
    }

    public int getOffset() {
        return this.offset;
    }

    public String getWord(int n) {
        String[] stringArray;
        try {
            stringArray = this.corpus.getContext(this.offset + n, 1, "text");
        }
        catch (CorpusException corpusException) {
            return null;
        }
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public String getWord(int n, String string) {
        String[] stringArray;
        try {
            stringArray = this.corpus.getContext(this.offset + n, 1, string);
        }
        catch (CorpusException corpusException) {
            return null;
        }
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }
}

