/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import java.util.Vector;
import uk.ac.bham.clg.cue.corpus.VerticalText;
import uk.ac.bham.clg.cue.corpus.WordList;
import uk.ac.bham.clg.cue.utils.WordListResource;
import uk.ac.bham.clg.util.ISO2UTF;

public class NTreeWordList
extends WordList {
    private char[] ctab = new char[this.initialCapacity];
    private int[] vtab = new int[this.initialCapacity];
    private int currentMax = 0;
    private int initialCapacity = 500000;
    private int capacityIncrement = 20000;
    private int wordCount = 0;

    private int addLetter(char c) {
        if (this.ctab.length <= this.currentMax + 1) {
            this.expandArrays();
        }
        this.ctab[this.currentMax] = c;
        this.vtab[this.currentMax] = 0;
        return this.currentMax++;
    }

    public void doProcessing(WordListResource wordListResource, String string) throws IOException {
        String string2 = null;
        this.wordCount = 0;
        int n = 0;
        ISO2UTF iSO2UTF = ISO2UTF.getInstance();
        while (wordListResource.hasMoreWords()) {
            try {
                string2 = wordListResource.getNextWord();
                if (string2.startsWith("<")) continue;
                if (++n % 1000 == 0) {
                    System.err.print("count " + n + " types " + this.wordCount + "\r");
                }
                if (string2.indexOf("&") > -1 && string2.indexOf(";") > -1) {
                    string2 = iSO2UTF.convertString(string2);
                }
                if (string2 == null || !this.insertWord(0, String.valueOf(string2) + '\u0000', 0)) continue;
                ++this.wordCount;
            }
            catch (NoSuchElementException noSuchElementException) {
                System.err.println(noSuchElementException);
            }
        }
        this.wordCount = 0;
        this.dump(string);
        this.ctab = null;
        this.vtab = null;
        System.err.println("NTreeWordList final array size: " + this.currentMax);
    }

    private void dump(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(string) + ".wrd");
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(String.valueOf(string) + ".frq"));
        this.dumpDict(fileOutputStream, dataOutputStream, 0, "");
        fileOutputStream.close();
        dataOutputStream.close();
        System.err.println("\nwrote " + this.wordCount + " items");
    }

    private void dumpDict(OutputStream outputStream, DataOutputStream dataOutputStream, int n, String string) throws IOException {
        Vector<BranchPointer> vector = new Vector<BranchPointer>();
        BranchPointer branchPointer = new BranchPointer(this.ctab[n], n + 1);
        vector.addElement(branchPointer);
        int n2 = this.vtab[n];
        while (n2 != 0) {
            branchPointer = new BranchPointer(this.ctab[n2], n2 + 1);
            int n3 = 0;
            while (n3 < vector.size() && branchPointer.greaterThan((BranchPointer)vector.elementAt(n3))) {
                ++n3;
            }
            vector.insertElementAt(branchPointer, n3);
            n = n2;
            n2 = this.vtab[n2];
        }
        while (vector.size() > 0) {
            branchPointer = (BranchPointer)vector.elementAt(0);
            vector.removeElementAt(0);
            if (branchPointer.character == '\u0000') {
                ISO2UTF.writelnUTF(outputStream, string);
                dataOutputStream.writeInt(this.vtab[branchPointer.pointer]);
                ++this.wordCount;
                continue;
            }
            this.dumpDict(outputStream, dataOutputStream, branchPointer.pointer, String.valueOf(string) + branchPointer.character);
        }
    }

    private void ensureCapacity(int n) {
        if (this.ctab.length <= this.currentMax + n) {
            this.expandArrays();
        }
    }

    private void expandArrays() {
        System.err.println("expand array from " + this.ctab.length + " by " + this.capacityIncrement);
        int n = this.ctab.length + this.capacityIncrement;
        int[] nArray = this.vtab;
        this.vtab = new int[n];
        System.arraycopy(nArray, 0, this.vtab, 0, this.currentMax);
        char[] cArray = this.ctab;
        this.ctab = new char[n];
        System.arraycopy(cArray, 0, this.ctab, 0, this.currentMax);
    }

    public int getWordCount() {
        return this.wordCount;
    }

    private boolean insertWord(int n, String string, int n2) {
        if (this.ctab[n] == string.charAt(n2)) {
            if (++n2 == string.length()) {
                int n3 = n + 1;
                this.vtab[n3] = this.vtab[n3] + 1;
                return false;
            }
            return this.insertWord(n + 1, string, n2);
        }
        if (this.vtab[n] == 0) {
            this.vtab[n] = this.currentMax;
            this.ensureCapacity(string.length() - n2);
            int n4 = n2;
            while (n4 < string.length()) {
                this.ctab[this.currentMax] = string.charAt(n4);
                this.vtab[this.currentMax] = 0;
                ++this.currentMax;
                ++n4;
            }
            this.ensureCapacity(1);
            this.ctab[this.currentMax] = '\u0000';
            this.vtab[this.currentMax] = 1;
            ++this.currentMax;
            return true;
        }
        return this.insertWord(this.vtab[n], string, n2);
    }

    public static void main(String[] stringArray) throws IOException {
        VerticalText verticalText = new VerticalText(stringArray[0]);
        NTreeWordList nTreeWordList = new NTreeWordList();
        nTreeWordList.doProcessing(verticalText, stringArray[1]);
    }

    private int retrieveWord(int n, String string, int n2) {
        while (string.charAt(n2) == this.ctab[n]) {
            if (this.ctab[n] == '\u0000') {
                return this.vtab[n + 1];
            }
            ++n2;
            ++n;
        }
        int n3 = this.vtab[n];
        if (n3 == 0) {
            return 0;
        }
        return this.retrieveWord(n3, string, n2);
    }

    private class BranchPointer {
        char character;
        int pointer;

        BranchPointer(char c, int n) {
            this.character = c;
            this.pointer = n;
        }

        boolean greaterThan(BranchPointer branchPointer) {
            return this.character > branchPointer.character;
        }

        boolean lessThan(BranchPointer branchPointer) {
            return this.character < branchPointer.character;
        }
    }
}

