/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import uk.ac.bham.clg.cue.corpus.VerticalText;
import uk.ac.bham.clg.cue.utils.WordIndex;

public class SimpleIndex
implements WordIndex {
    private int size = -1;
    private String name = null;
    RandomAccessFile wordCharsFile = null;
    RandomAccessFile wordIndexFile = null;
    private final boolean DEBUG = false;

    public SimpleIndex(String string) throws IOException {
        this.name = string;
        this.wordCharsFile = new RandomAccessFile(String.valueOf(string) + ".wrd", "r");
        this.wordIndexFile = new RandomAccessFile(String.valueOf(string) + ".wdi", "r");
        File file = new File(String.valueOf(string) + ".wdi");
        this.size = (int)(file.length() / 4L);
    }

    public void finalize() {
        try {
            this.wordCharsFile.close();
            this.wordIndexFile.close();
        }
        catch (IOException iOException) {}
    }

    public String[] getPrefix(String string) {
        return null;
    }

    public int getSize() {
        return this.size;
    }

    public Enumeration getWords() {
        return new Enumeration(){
            private int count = 0;

            public boolean hasMoreElements() {
                return this.count < SimpleIndex.this.size;
            }

            public Object nextElement() throws NoSuchElementException {
                if (this.hasMoreElements()) {
                    return SimpleIndex.this.indexLookup(this.count++);
                }
                throw new NoSuchElementException();
            }
        };
    }

    public String indexLookup(int n) {
        if (this.wordCharsFile == null || this.wordIndexFile == null || n < 0 || n >= this.size) {
            return "[e]";
        }
        String string = null;
        try {
            int n2;
            try {
                this.wordIndexFile.seek(n * 4);
                n2 = this.wordIndexFile.readInt();
            }
            catch (IOException iOException) {
                System.err.println("wordIndexFile access(" + n * 4 + ") failed.");
                return null;
            }
            try {
                this.wordCharsFile.seek(n2);
            }
            catch (IOException iOException) {
                System.err.println("wordCharsFile.seek(" + n2 + ") failed.");
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            VerticalText.readUTF(this.wordCharsFile, stringBuffer);
            string = stringBuffer.toString();
        }
        catch (IOException iOException) {
            System.err.println("wordCharsFile lookup " + n + " failed: " + iOException);
            return null;
        }
        return string;
    }

    public int wordLookup(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        if (string == null) {
            return -1;
        }
        n = this.size - 1;
        while (n2 <= n) {
            int n4 = (n2 + n) / 2;
            String string2 = this.indexLookup(n4);
            if (string2 == null) break;
            int n5 = string.compareTo(string2);
            if (n5 == 0) {
                n3 = n4;
                break;
            }
            if (n5 < 0) {
                n = n4 - 1;
                continue;
            }
            if (n5 <= 0) continue;
            n2 = n4 + 1;
        }
        return n3;
    }
}

