/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import uk.ac.bham.clg.cue.corpus.Corpus;
import uk.ac.bham.clg.cue.corpus.Cue;
import uk.ac.bham.clg.cue.corpus.HuffmanCode;
import uk.ac.bham.clg.cue.corpus.StreamIndex;
import uk.ac.bham.clg.cue.corpus.WordRetriever;
import uk.ac.bham.clg.cue.io.BitInputStream;
import uk.ac.bham.clg.util.EnumerationSequence;

public class Stream {
    private static final boolean DEBUG = false;
    private static final boolean THREADED = false;
    private int threshold = 50000;
    private Corpus theCorpus = null;
    private String streamName = null;
    private String corpusName = null;
    private String streamDirectory = null;
    private int streamGranularity = 0;
    private int streamSize = 0;
    private StreamIndex streamIndex = null;
    private HuffmanCode streamCode = null;
    private String dataFileName = null;
    private String syncFileName = null;
    private String freqFileName = null;
    private BitInputStream dataFile;
    private RandomAccessFile syncFile;
    private RandomAccessFile freqFile;
    private boolean filesOpen = false;
    private boolean isIndexed = false;
    private Object codeLock = new Object();

    public Stream(Cue cue, Corpus corpus, Properties properties) throws IllegalArgumentException, IOException {
        String string = null;
        this.theCorpus = corpus;
        this.streamName = properties.getProperty("name", "text");
        this.corpusName = corpus != null ? corpus.getName() : properties.getProperty("corpus", "text");
        this.streamDirectory = properties.getProperty("directory", ".");
        string = properties.getProperty("code");
        String string2 = properties.getProperty("granularity", "128");
        this.streamGranularity = Integer.parseInt(string2);
        string2 = properties.getProperty("size", "-1");
        this.streamSize = Integer.parseInt(string2);
        try {
            this.streamIndex = new StreamIndex(this, this.corpusName, this.streamName, this.streamDirectory);
            this.isIndexed = true;
        }
        catch (IOException iOException) {
            this.isIndexed = false;
        }
        if (string == null) {
            throw new IllegalArgumentException("Stream: no code specified");
        }
        try {
            this.streamCode = new HuffmanCode(cue, string);
        }
        catch (IOException iOException) {
            throw new IOException("Stream (code initialisation): " + iOException);
        }
        this.dataFileName = String.valueOf(this.streamDirectory) + File.separator + this.corpusName + "-" + this.streamName + ".data";
        this.syncFileName = String.valueOf(this.streamDirectory) + File.separator + this.corpusName + "-" + this.streamName + ".sync";
        this.freqFileName = String.valueOf(this.streamDirectory) + File.separator + this.corpusName + "-" + this.streamName + ".freq";
        File file = new File(this.dataFileName);
        if (!file.canRead()) {
            throw new IOException("Stream: cannot read " + this.dataFileName);
        }
        file = new File(this.syncFileName);
        if (!file.canRead()) {
            throw new IOException("Stream: cannot read " + this.syncFileName);
        }
        file = new File(this.freqFileName);
        if (!file.canRead()) {
            throw new IOException("Stream: cannot read " + this.freqFileName);
        }
    }

    public void close() {
        try {
            this.dataFile.close();
            this.syncFile.close();
            this.freqFile.close();
            this.filesOpen = false;
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
    }

    protected HuffmanCode getCode() {
        Object object = this.codeLock;
        synchronized (object) {
            HuffmanCode huffmanCode = this.streamCode;
            Object var3_3 = null;
            return huffmanCode;
        }
    }

    public String[] getContext(int n, int n2) throws IOException {
        int[] nArray = new int[n2];
        String[] stringArray = new String[n2];
        this.read(n, nArray);
        int n3 = 0;
        while (n3 < nArray.length) {
            stringArray[n3] = this.streamCode.string(nArray[n3]);
            ++n3;
        }
        return stringArray;
    }

    protected Corpus getCorpus() {
        return this.theCorpus;
    }

    public int getFreq(String string) {
        int n;
        block5: {
            int n2 = this.streamCode.translate(string);
            n = 0;
            if (n2 <= -1) break block5;
            try {
                boolean bl = false;
                if (!this.filesOpen) {
                    bl = true;
                }
                if (bl) {
                    this.open();
                }
                n = Cue.readInt(this.freqFile, n2);
                if (bl) {
                    this.close();
                }
            }
            catch (IOException iOException) {
                n = -1;
            }
        }
        return n;
    }

    public String getName() {
        return this.streamName;
    }

    public boolean isIndexed() {
        return this.isIndexed;
    }

    public void kwic(int n, char[] cArray) throws IOException {
        int n2;
        int n3 = cArray.length;
        int n4 = n2 = n3 / 4;
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n2 + 1];
        this.read(n - n4, nArray);
        this.read(n, nArray2);
        String string = new String("<" + this.streamCode.string(nArray2[0]) + ">");
        int n5 = (n3 - string.length()) / 2 - 1;
        StringBuffer stringBuffer = new StringBuffer(n3 + 20);
        int n6 = 0;
        while (n6 < n4) {
            stringBuffer.append(String.valueOf(this.streamCode.string(nArray[n6])) + " ");
            ++n6;
        }
        while (stringBuffer.length() < n5) {
            stringBuffer.insert(0, "  ");
        }
        StringBuffer stringBuffer2 = stringBuffer.reverse();
        stringBuffer2.setLength(n5);
        stringBuffer = stringBuffer2.reverse();
        stringBuffer.append(string);
        n6 = 1;
        while (n6 < n2 + 1 && stringBuffer.length() < n3) {
            stringBuffer.append(" " + this.streamCode.string(nArray2[n6]));
            ++n6;
        }
        n6 = 0;
        while (n6 < cArray.length) {
            cArray[n6] = stringBuffer.charAt(n6);
            ++n6;
        }
    }

    public void open() throws IOException {
        this.dataFile = new BitInputStream(new RandomAccessFile(this.dataFileName, "r"));
        this.syncFile = new RandomAccessFile(this.syncFileName, "r");
        this.freqFile = new RandomAccessFile(this.freqFileName, "r");
        this.filesOpen = true;
    }

    /*
     * Unable to fully structure code
     */
    public int read(int var1_1, int[] var2_2) throws IOException {
        if (!this.filesOpen) {
            this.open();
        }
        var3_3 = 0;
        while (var3_3 < var2_2.length) {
            var2_2[var3_3] = -1;
            ++var3_3;
        }
        var4_4 = 0;
        var5_5 = var2_2.length;
        if (var1_1 + var5_5 > this.streamSize) {
            var5_5 = this.streamSize - var1_1;
        }
        if (var1_1 < this.streamSize) ** GOTO lbl16
        return 0;
lbl-1000:
        // 1 sources

        {
            ++var1_1;
            ++var4_4;
lbl16:
            // 2 sources

            ** while (var1_1 < 0 && var4_4 < var5_5)
        }
lbl17:
        // 1 sources

        if (var4_4 == var5_5) {
            return 0;
        }
        var6_6 = 0;
        while (var1_1 >= this.streamGranularity) {
            ++var6_6;
            var1_1 -= this.streamGranularity;
        }
        var7_7 = Cue.readInt(this.syncFile, var6_6);
        try {
            this.dataFile.seek(var7_7);
        }
        catch (EOFException v0) {
            System.err.println("Stream (read): EOFException occurred");
        }
        var9_8 = false;
        while (var1_1 > 0) {
            var8_9 = this.readWord();
            --var1_1;
        }
        while (var4_4 < var5_5) {
            var2_2[var4_4] = this.readWord();
            ++var4_4;
        }
        if (!this.filesOpen) {
            this.close();
        }
        return var4_4;
    }

    public int readWord() throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        boolean bl = false;
        if (this.dataFile == null) {
            this.open();
            bl = true;
        }
        try {
            while (n3 < 0) {
                if (n2++ > 32) {
                    throw new IOException("codeword length overflow");
                }
                n = 2 * n + this.dataFile.readBit();
                n3 = this.streamCode.decode(n, n2);
            }
        }
        catch (EOFException eOFException) {
            return -1;
        }
        if (bl) {
            this.close();
        }
        return n3;
    }

    public int[] retrieve(int n, int n2) {
        if (!this.isIndexed || n < 0) {
            return null;
        }
        try {
            return this.streamIndex.retrieve(n, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Stream.retrieve: " + illegalArgumentException);
            return null;
        }
        catch (IOException iOException) {
            System.err.println("Stream.retrieve: " + iOException);
            return null;
        }
    }

    public int[] retrieve(String string, int n) {
        int n2;
        if (string.indexOf(42) < 0) {
            int n3 = this.streamCode.translate(string);
            if (n3 < 0) {
                return null;
            }
            return this.retrieve(n3, n);
        }
        int n4 = 0;
        if (string.startsWith("*")) {
            ++n4;
        }
        if (string.endsWith("*")) {
            n4 += 2;
        }
        if (n4 == 0) {
            n4 = 4;
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if ((n4 & 1) == 1) {
            string2 = null;
        } else {
            n2 = string.indexOf(42);
            if (n2 > -1) {
                string2 = string.substring(0, n2);
                string = string.substring(n2);
            }
        }
        if ((n4 & 2) == 2) {
            string3 = null;
        } else {
            n2 = string.lastIndexOf(42);
            if (n2 > -1) {
                string3 = string.substring(n2 + 1);
                string = string.substring(0, n2);
            }
        }
        string4 = n4 != 3 ? null : string;
        int[] nArray = this.streamCode.starMatch(n4, string2, string4, string3);
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        return this.retrieve(nArray, n);
    }

    public int[] retrieve(int[] nArray, int n) {
        if (!this.isIndexed) {
            return null;
        }
        try {
            return this.streamIndex.retrieve(nArray, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Stream.retrieve: " + illegalArgumentException);
            return null;
        }
        catch (IOException iOException) {
            System.err.println("Stream.retrieve: " + iOException);
            return null;
        }
    }

    public Enumeration retrieveItem(String string, int n) {
        if (!this.isIndexed) {
            return null;
        }
        if (string.indexOf("*") >= 0 && !string.equals("*")) {
            int[] nArray = this.transWild(string);
            Vector<WordRetriever> vector = new Vector<WordRetriever>(nArray.length);
            int n2 = 0;
            while (n2 < nArray.length) {
                try {
                    WordRetriever wordRetriever = this.streamIndex.retrieve(nArray[n2], n, this.threshold);
                    vector.addElement(wordRetriever);
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
                ++n2;
            }
            return new EnumerationSequence(vector);
        }
        int n3 = this.streamCode.translate(string);
        if (n3 < 0) {
            return null;
        }
        try {
            return this.streamIndex.retrieve(n3, n, this.threshold);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Stream.retrieve: " + illegalArgumentException);
            return null;
        }
        catch (IOException iOException) {
            System.err.println("Stream.retrieve: " + iOException);
            return null;
        }
    }

    protected void setCode(HuffmanCode huffmanCode) {
        if (huffmanCode != null) {
            this.streamCode = huffmanCode;
        }
    }

    protected String string(int n) {
        return this.streamCode.string(n);
    }

    private int[] transWild(String string) {
        int n;
        if (string.indexOf("*") < 0) {
            return null;
        }
        int n2 = 0;
        if (string.startsWith("*")) {
            ++n2;
        }
        if (string.endsWith("*")) {
            n2 += 2;
        }
        if (n2 == 0) {
            n2 = 4;
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if ((n2 & 1) == 1) {
            string2 = null;
        } else {
            n = string.indexOf(42);
            if (n > -1) {
                string2 = string.substring(0, n);
                string = string.substring(n);
            }
        }
        if ((n2 & 2) == 2) {
            string3 = null;
        } else {
            n = string.lastIndexOf(42);
            if (n > -1) {
                string3 = string.substring(n + 1);
                string = string.substring(0, n);
            }
        }
        string4 = n2 != 3 ? null : string;
        int[] nArray = this.streamCode.starMatch(n2, string2, string4, string3);
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        return nArray;
    }

    private class CodeLoader
    extends Thread {
        private Stream parent;
        private String codeName;
        private Cue application;

        public CodeLoader(Stream stream2, Cue cue, String string) {
            this.application = cue;
            this.parent = stream2;
            this.codeName = string;
        }

        public void run() {
            try {
                this.parent.setCode(new HuffmanCode(this.application, this.codeName));
            }
            catch (IOException iOException) {
                this.parent.setCode(null);
            }
        }
    }
}

