/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import uk.ac.bham.clg.cue.corpus.Corpus;
import uk.ac.bham.clg.cue.corpus.Cue;
import uk.ac.bham.clg.cue.corpus.Stream;
import uk.ac.bham.clg.cue.corpus.WordRetriever;
import uk.ac.bham.clg.cue.io.BitInputStream;

public class StreamIndex {
    private final boolean DEBUG = false;
    BitInputStream indexFile = null;
    RandomAccessFile pointerFile = null;
    RandomAccessFile freqFile = null;
    String indexFileName = null;
    String pointerFileName = null;
    String freqFileName = null;
    int typeNumber = 0;
    boolean filesOpen = false;
    private Stream stream = null;

    public StreamIndex(Stream stream, String string, String string2, String string3) throws IOException {
        this.stream = stream;
        this.indexFileName = new String(String.valueOf(string3) + File.separator + string + "-" + string2 + ".gamma");
        this.pointerFileName = new String(String.valueOf(string3) + File.separator + string + "-" + string2 + ".ptr");
        this.freqFileName = new String(String.valueOf(string3) + File.separator + string + "-" + string2 + ".freq");
        File file = new File(this.indexFileName);
        if (!file.canRead()) {
            throw new IOException("StreamIndex: cannot read " + this.indexFileName);
        }
        file = new File(this.pointerFileName);
        if (!file.canRead()) {
            throw new IOException("StreamIndex: cannot read " + this.pointerFileName);
        }
        file = new File(this.freqFileName);
        if (!file.canRead()) {
            throw new IOException("StreamIndex: cannot read " + this.freqFileName);
        }
        this.typeNumber = (int)(file.length() / 4L);
    }

    public void close() throws IOException {
        try {
            this.indexFile.close();
            this.indexFile = null;
            this.pointerFile.close();
            this.pointerFile = null;
            this.freqFile.close();
            this.freqFile = null;
            this.filesOpen = false;
        }
        catch (IOException iOException) {
            throw new IOException("StreamIndex.close: " + iOException);
        }
    }

    public void open() throws IOException {
        try {
            this.indexFile = new BitInputStream(new RandomAccessFile(this.indexFileName, "r"));
            this.pointerFile = new RandomAccessFile(this.pointerFileName, "r");
            this.freqFile = new RandomAccessFile(this.freqFileName, "r");
            this.filesOpen = true;
        }
        catch (IOException iOException) {
            throw new IOException("StreamIndex.open: " + iOException);
        }
    }

    public int[] retrieve(int n, int n2) throws IllegalArgumentException, IOException {
        int[] nArray = null;
        if (n < 0 || n >= this.typeNumber) {
            throw new IllegalArgumentException("StreamIndex: cannot retrieve index word #" + n);
        }
        if (!this.filesOpen) {
            this.open();
        }
        try {
            int n3 = Cue.readInt(this.freqFile, n);
            if (n2 != -1 && n2 < n3) {
                n3 = n2;
            }
            int n4 = Cue.readInt(this.pointerFile, n);
            nArray = new int[n3];
            this.indexFile.seek(n4);
            nArray[0] = this.indexFile.readGamma() - 1;
            int n5 = 1;
            while (n5 < n3) {
                nArray[n5] = nArray[n5 - 1] + this.indexFile.readGamma();
                ++n5;
            }
        }
        finally {
            Object var5_7 = null;
            if (!this.filesOpen) {
                this.close();
            }
        }
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WordRetriever retrieve(int n, int n2, int n3) throws IllegalArgumentException, IOException {
        WordRetriever wordRetriever;
        if (n < 0) throw new IllegalArgumentException("StreamIndex: cannot retrieve index word #" + n);
        if (n >= this.typeNumber) {
            throw new IllegalArgumentException("StreamIndex: cannot retrieve index word #" + n);
        }
        if (!this.filesOpen) {
            this.open();
        }
        Corpus corpus = this.stream.getCorpus();
        try {
            int n4 = Cue.readInt(this.freqFile, n);
            if (n2 != -1 && n2 < n4) {
                n4 = n2;
            }
            int n5 = Cue.readInt(this.pointerFile, n);
            this.indexFile.seek(n5);
            if (n4 < n3) {
                int[] nArray = new int[n4];
                nArray[0] = this.indexFile.readGamma() - 1;
                int n6 = 1;
                while (true) {
                    if (n6 >= n4) {
                        if (!this.filesOpen) {
                            this.close();
                        }
                        break;
                    }
                    nArray[n6] = nArray[n6 - 1] + this.indexFile.readGamma();
                    ++n6;
                }
                WordRetriever wordRetriever2 = new WordRetriever(corpus, nArray);
                Object var7_11 = null;
                if (this.filesOpen) return wordRetriever2;
                this.close();
                return wordRetriever2;
            }
            wordRetriever = new WordRetriever(corpus, this, n4, this.indexFile);
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            if (this.filesOpen) throw throwable;
            this.close();
            throw throwable;
        }
        Object var7_12 = null;
        if (this.filesOpen) return wordRetriever;
        this.close();
        return wordRetriever;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] retrieve(int[] nArray, int n) throws IllegalArgumentException, IOException, NullPointerException {
        if (nArray == null) {
            throw new NullPointerException("null array passed to retrieve");
        }
        int[] nArray2 = null;
        if (!this.filesOpen) {
            this.open();
        }
        try {
            int n2 = 0;
            int[] nArray3 = new int[nArray.length];
            int n3 = 0;
            while (n3 < nArray.length) {
                if (nArray[n3] < 0) throw new IllegalArgumentException("cannot retrieve index word #" + nArray[n3]);
                if (nArray[n3] >= this.typeNumber) {
                    throw new IllegalArgumentException("cannot retrieve index word #" + nArray[n3]);
                }
                nArray3[n3] = Cue.readInt(this.freqFile, nArray[n3]);
                n2 += nArray3[n3];
                ++n3;
            }
            if (n != -1 && n < n2) {
                n2 = n;
            }
            nArray2 = new int[n2];
            int n4 = 0;
            int n5 = 0;
            boolean bl = true;
            do {
                if (!bl || (bl = false) || !true) {
                    int n6 = Cue.readInt(this.pointerFile, nArray[n5]);
                    this.indexFile.seek(n6);
                    nArray2[n4++] = this.indexFile.readGamma() - 1;
                    int n7 = 1;
                    while (n7 < nArray3[n5]) {
                        nArray2[n4] = nArray2[n4 - 1] + this.indexFile.readGamma();
                        ++n4;
                        ++n7;
                    }
                    ++n5;
                }
                if (n5 >= nArray.length) break;
            } while (n4 < n2);
        }
        catch (Throwable throwable) {
            Object var5_12 = null;
            if (this.filesOpen) throw throwable;
            this.close();
            throw throwable;
        }
        Object var5_11 = null;
        if (this.filesOpen) return nArray2;
        this.close();
        return nArray2;
    }
}

