/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.NoSuchElementException;
import uk.ac.bham.clg.cue.io.TokenisedReader;
import uk.ac.bham.clg.cue.utils.WordListResource;
import uk.ac.bham.clg.util.ISO2UTF;

public class TextResource
implements WordListResource {
    private TokenisedReader resource = null;
    private String resourceName = null;
    private boolean moreLines = false;
    private String nextLine = null;
    private ISO2UTF isoConverter = null;

    public TextResource(String string) throws IOException {
        this.open(string);
        this.resourceName = string;
        this.fillBuffer();
        this.isoConverter = ISO2UTF.getInstance();
    }

    private void fillBuffer() {
        this.moreLines = false;
        try {
            this.nextLine = this.resource.readLine();
            if (this.nextLine != null) {
                this.moreLines = true;
            }
        }
        catch (IOException iOException) {
            this.nextLine = null;
        }
    }

    public char[] getAlphabet() {
        return null;
    }

    public String getNextWord() throws NoSuchElementException {
        if (this.nextLine == null) {
            throw new NoSuchElementException("WordListResource");
        }
        String string = this.nextLine;
        this.fillBuffer();
        return string;
    }

    public void getNextWord(StringBuffer stringBuffer) {
        if (this.nextLine == null) {
            throw new NoSuchElementException("WordListResource");
        }
        stringBuffer.setLength(0);
        stringBuffer.append(this.nextLine);
        this.fillBuffer();
    }

    public boolean hasMoreWords() {
        return this.moreLines;
    }

    public static void main(String[] stringArray) throws IOException {
        TextResource textResource = new TextResource(stringArray[0]);
        int n = 0;
        while (textResource.hasMoreWords()) {
            String string = textResource.getNextWord();
            if (string.startsWith("<")) {
                System.out.println(String.valueOf(n) + ": " + string);
            }
            if (string.startsWith("<")) continue;
            ++n;
        }
    }

    private void open(String string) throws IOException {
        if (this.resource != null) {
            this.resource.close();
        }
        this.resource = new TokenisedReader(new BufferedReader(new FileReader(string)));
    }

    public void rewind() throws IOException {
        this.open(this.resourceName);
        this.fillBuffer();
    }
}

