/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import uk.ac.bham.clg.cue.corpus.Stream;
import uk.ac.bham.clg.cue.utils.WordListResource;
import uk.ac.bham.clg.util.ISO2UTF;

public class TextVerifier {
    static final boolean DEBUG = false;
    private ISO2UTF isoConverter = ISO2UTF.getInstance();

    public TextVerifier(WordListResource wordListResource, String string, String string2, String string3, String string4, int n) throws IOException {
        String string5 = new String(String.valueOf(string2) + File.separatorChar + string + "-" + string3);
        Properties properties = new Properties();
        ((Hashtable)properties).put("directory", string2);
        ((Hashtable)properties).put("corpus", string);
        ((Hashtable)properties).put("code", string4);
        ((Hashtable)properties).put("size", String.valueOf(n));
        Stream stream = null;
        try {
            stream = new Stream(null, null, properties);
        }
        catch (IOException iOException) {
            throw new IOException("TextVerifier (opening Stream): " + iOException);
        }
        if (stream == null) {
            throw new IOException("TextVerifier: Stream constructor failed");
        }
        stream.open();
        this.verifyData(wordListResource, stream, n);
        stream.close();
    }

    private void verifyData(WordListResource wordListResource, Stream stream, int n) throws IOException {
        wordListResource.rewind();
        int n2 = 0;
        while (wordListResource.hasMoreWords()) {
            String string = wordListResource.getNextWord();
            if (string == null) {
                throw new IOException("word is null @ position " + n2);
            }
            if (string.startsWith("<")) continue;
            int n3 = stream.readWord();
            String string2 = stream.string(n3);
            if (string.indexOf(38) > -1) {
                string = this.isoConverter.convertString(string);
            }
            if (!string2.equals(string)) {
                throw new IOException(String.valueOf(string) + " != " + string2 + " @ position " + n2);
            }
            if (++n2 % 1000 != 0) continue;
            System.err.print(String.valueOf(n2) + "\r");
        }
    }
}

