/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import uk.ac.bham.clg.cue.corpus.WordList;
import uk.ac.bham.clg.cue.utils.WordListResource;
import uk.ac.bham.clg.util.ISO2UTF;
import uk.ac.bham.clg.util.MutableInteger;
import uk.ac.bham.clg.util.Trie;

public class TrieWordList
extends WordList {
    private static boolean DEBUG = false;
    private BufferedReader reader = null;
    private int wordCount = 0;
    private int[] frequencyCount = null;

    public void doProcessing(WordListResource wordListResource, String string) {
        String string2 = null;
        int n = 0;
        int n2 = 0;
        MutableInteger mutableInteger = null;
        Trie trie = new Trie("tmptrie", "rw");
        while (wordListResource.hasMoreWords()) {
            try {
                string2 = wordListResource.getNextWord();
                if (string2.startsWith("<")) continue;
                if (++n % 100000 == 0 && DEBUG) {
                    System.err.println(String.valueOf(n) + " -> " + n2 + " mem: " + Runtime.getRuntime().freeMemory());
                }
                if (string2 == null) continue;
                mutableInteger = (MutableInteger)trie.get(string2);
                if (mutableInteger == null) {
                    mutableInteger = new MutableInteger(1);
                    trie.put(string2, (Object)mutableInteger);
                    ++n2;
                    continue;
                }
                mutableInteger.inc();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                System.err.println("TrieWordList: (line #" + n + ") " + outOfMemoryError);
                string2 = null;
                System.gc();
            }
        }
        wordListResource = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(string) + ".wrd");
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(String.valueOf(string) + ".frq"));
            if (DEBUG) {
                System.err.println("Collecting keys");
            }
            Enumeration enumeration = trie.keys();
            if (DEBUG) {
                System.err.println("Writing data into files");
            }
            this.wordCount = 0;
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                mutableInteger = (MutableInteger)trie.get(string3);
                ISO2UTF.writelnUTF(fileOutputStream, string3);
                dataOutputStream.writeInt(mutableInteger.intValue());
                ++this.wordCount;
            }
            fileOutputStream.close();
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public int getWordCount() {
        return this.wordCount;
    }
}

