/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.NoSuchElementException;
import uk.ac.bham.clg.cue.utils.WordListResource;
import uk.ac.bham.clg.util.ISO2UTF;

public class VerticalText
implements WordListResource {
    private DataInputStream resource = null;
    private String resourceName = null;
    private boolean moreLines = false;
    private String nextLine = null;
    private ISO2UTF isoConverter = null;

    public VerticalText(String string) throws IOException {
        this.open(string);
        this.resourceName = string;
        this.fillBuffer();
        this.isoConverter = ISO2UTF.getInstance();
    }

    private void fillBuffer() {
        this.moreLines = false;
        try {
            this.nextLine = ISO2UTF.readUTF(this.resource);
            if (this.nextLine != null) {
                this.moreLines = true;
                if (this.nextLine.indexOf("&") > -1 && this.nextLine.indexOf(";") > -1) {
                    this.nextLine = this.isoConverter.convertString(this.nextLine);
                }
            }
        }
        catch (IOException iOException) {
            this.nextLine = null;
        }
    }

    public char[] getAlphabet() {
        return null;
    }

    public String getNextWord() throws NoSuchElementException {
        if (this.nextLine == null) {
            throw new NoSuchElementException("WordListResource");
        }
        String string = this.nextLine;
        this.fillBuffer();
        return string;
    }

    public void getNextWord(StringBuffer stringBuffer) {
        if (this.nextLine == null) {
            throw new NoSuchElementException("WordListResource");
        }
        stringBuffer.setLength(0);
        stringBuffer.append(this.nextLine);
        this.fillBuffer();
    }

    public boolean hasMoreWords() {
        return this.moreLines;
    }

    private void open(String string) throws IOException {
        this.resource = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
    }

    public static void readUTF(DataInput dataInput, StringBuffer stringBuffer) throws IOException {
        block11: {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(80);
            }
            block5: while (true) {
                int n;
                if ((n = dataInput.readUnsignedByte()) == 10 || n == 13) {
                    if (stringBuffer.length() == 0) {
                        continue;
                    }
                    break block11;
                }
                switch (n >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        stringBuffer.append((char)n);
                        continue block5;
                    }
                    case 12: 
                    case 13: {
                        int n2 = dataInput.readUnsignedByte();
                        if ((n2 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        stringBuffer.append((char)((n & 0x1F) << 6 | n2 & 0x3F));
                        continue block5;
                    }
                    case 14: {
                        int n2 = dataInput.readUnsignedByte();
                        int n3 = dataInput.readUnsignedByte();
                        if ((n2 & 0xC0) != 128 || (n3 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        stringBuffer.append((char)((n & 0xF) << 12 | (n2 & 0x3F) << 6 | n3 & 0x3F));
                        continue block5;
                    }
                }
                break;
            }
            throw new UTFDataFormatException();
        }
    }

    public void rewind() throws IOException {
        this.open(this.resourceName);
        this.fillBuffer();
    }
}

