/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus;

import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import uk.ac.bham.clg.cue.corpus.Corpus;
import uk.ac.bham.clg.cue.corpus.Item;
import uk.ac.bham.clg.cue.corpus.StreamIndex;
import uk.ac.bham.clg.cue.io.BitInputStream;

public class WordRetriever
implements Enumeration {
    private BitInputStream bis = null;
    private Item currentItem = null;
    private StreamIndex theIndex = null;
    private int[] indexArray;
    private int number = 0;
    private int current = 0;
    private int currentIndex = -1;
    private Corpus theCorpus = null;

    public WordRetriever(Corpus corpus, StreamIndex streamIndex, int n, BitInputStream bitInputStream) {
        this.theIndex = streamIndex;
        this.theCorpus = corpus;
        this.bis = bitInputStream;
        this.number = n;
        this.currentItem = this.readNextElement();
    }

    public WordRetriever(Corpus corpus, int[] nArray) {
        this.theCorpus = corpus;
        this.bis = null;
        this.indexArray = nArray;
        this.number = nArray.length;
        this.currentItem = this.readNextElement();
    }

    public boolean hasMoreElements() {
        if (this.currentItem != null) {
            return true;
        }
        if (this.theIndex != null) {
            try {
                this.theIndex.close();
            }
            catch (IOException iOException) {
                System.err.println("WordRetriever: " + iOException);
            }
            this.theIndex = null;
        }
        return false;
    }

    public Object nextElement() {
        if (this.currentItem == null) {
            throw new NoSuchElementException("No more Items available");
        }
        Item item = this.currentItem;
        this.currentItem = this.readNextElement();
        return item;
    }

    private Item readNextElement() {
        if (this.current < this.number) {
            if (this.bis == null) {
                this.currentIndex = this.indexArray[this.current];
            } else {
                try {
                    this.currentIndex = this.current == 0 ? this.bis.readGamma() - 1 : (this.currentIndex += this.bis.readGamma());
                }
                catch (IOException iOException) {
                    System.err.println("WordRetriever: " + iOException);
                }
            }
            ++this.current;
            return new Item(this.theCorpus, this.currentIndex);
        }
        this.indexArray = null;
        return null;
    }
}

