/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus.annotation;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import uk.ac.bham.clg.cue.corpus.annotation.Tag;
import uk.ac.bham.clg.cue.corpus.annotation.TagOutputStream;
import uk.ac.bham.clg.cue.io.BitInputStream;
import uk.ac.bham.clg.util.HashInc;

public class AIndex {
    private static final boolean DEBUG = true;
    private String inputFileName = null;
    private String directory = null;
    private int skipped = 0;
    private char[] strbuf = new char[1024];

    public AIndex(String string, String string2) throws IOException {
        this.inputFileName = string;
        this.directory = string2;
        File file = new File(string);
        if (!file.exists() || !file.canRead()) {
            throw new IOException("AIndex: Cannot read input file " + string);
        }
        file = new File(string2);
        if (!file.exists()) {
            throw new IOException("AIndex: Cannot find output dir " + string2);
        }
        if (!file.isDirectory()) {
            throw new IOException("AIndex: Not a directory: " + string2);
        }
        if (!file.canWrite()) {
            throw new IOException("AIndex: Cannot write to " + string2);
        }
        this.index(string);
    }

    private HashInc getTagDistribution(BitInputStream bitInputStream) throws IOException {
        System.err.println("First pass through tag file");
        Tag tag = this.readTag(bitInputStream, null);
        int n = 0;
        HashInc hashInc = new HashInc();
        String string = null;
        while (tag != null) {
            string = tag.getLabel();
            if (string != null) {
                hashInc.put(string.intern());
                ++n;
            }
            tag = this.readTag(bitInputStream, tag);
            if (this.skipped % 100 == 0) {
                System.err.print(String.valueOf(this.skipped) + " / " + n + "\r");
            }
            if (this.skipped % 10000 != 0) continue;
            System.gc();
        }
        System.err.println("Processing " + n + " tags altogether");
        return hashInc;
    }

    public void index(String string) throws IOException {
        BitInputStream bitInputStream = new BitInputStream(new DataInputStream(new BufferedInputStream(new FileInputStream(string))));
        HashInc hashInc = this.getTagDistribution(bitInputStream);
        System.err.println("Processing " + hashInc.size() + " different tags");
        int n = 0;
        String string2 = null;
        int n2 = 0;
        String string3 = null;
        Enumeration enumeration = hashInc.keys();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            int n3 = hashInc.get(string3);
            if (n3 > n2) {
                n2 = n3;
                string2 = string3;
            }
            n += n3;
        }
        System.err.println("start indexing " + n + " tags, max. Tag is " + string2 + " with " + n2);
        TagOutputStream tagOutputStream = new TagOutputStream(this.directory, string2, n2);
        TagOutputStream tagOutputStream2 = new TagOutputStream(this.directory, "rest", n - n2);
        Tag tag = null;
        bitInputStream = new BitInputStream(new DataInputStream(new BufferedInputStream(new FileInputStream(string))));
        int n4 = 0;
        while (n4 < n) {
            if ((tag = this.readTag(bitInputStream, tag)) != null) {
                string3 = tag.getLabel();
                if (string2.equals(string3)) {
                    tagOutputStream.write(tag);
                } else {
                    tag.setAttribute("real-name", tag.getLabel());
                    tagOutputStream2.write(tag);
                }
                if (n4 % 100 == 0) {
                    System.err.print(String.valueOf(n4) + "\r");
                }
                if (n4 % 10000 == 0) {
                    System.gc();
                }
            } else {
                System.err.println("position " + n4 + ": tag is null");
            }
            ++n4;
        }
        tagOutputStream.close();
        tagOutputStream2.close();
        bitInputStream.close();
    }

    public static void main(String[] stringArray) throws IOException {
        AIndex aIndex = new AIndex(stringArray[0], stringArray[1]);
    }

    private Tag readTag(BitInputStream bitInputStream, Tag tag) throws IOException {
        try {
            boolean bl = false;
            while (!bl) {
                int n = bitInputStream.readGamma() - 2;
                int n2 = bitInputStream.readGamma() - 1;
                int n3 = bitInputStream.readGamma() - 1;
                if (n3 >= this.strbuf.length) {
                    this.strbuf = new char[n3];
                }
                int n4 = 0;
                while (n4 < n3) {
                    this.strbuf[n4] = (char)(bitInputStream.readGamma() + 30);
                    ++n4;
                }
                if ((tag = Tag.analyseTag(0, new String(this.strbuf, 0, n3), tag)) == null || tag.getLabel() == null) break;
                if (!tag.getLabel().equals("W")) {
                    bl = true;
                    tag.setStart(n);
                    tag.setEnd(n + n2);
                }
                ++this.skipped;
            }
            return tag;
        }
        catch (EOFException eOFException) {
            System.err.println("readTag: reached EOF");
            return null;
        }
    }
}

