/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus.annotation;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import uk.ac.bham.clg.cue.corpus.Corpus;
import uk.ac.bham.clg.cue.corpus.annotation.TagInputStream;
import uk.ac.bham.clg.cue.corpus.annotation.TagRetriever;

public class Annotation
implements FilenameFilter {
    private String workingDirectory = null;
    private Corpus corpus = null;

    public Annotation(Corpus corpus) {
        this.corpus = corpus;
        this.workingDirectory = String.valueOf(corpus.getLocation()) + File.separatorChar + "tags";
    }

    public boolean accept(File file, String string) {
        return string.endsWith(".tag");
    }

    public Enumeration getInstances(String string, Properties properties) throws IOException {
        TagInputStream tagInputStream = this.openTagIndex(string);
        if (tagInputStream == null) {
            return null;
        }
        return new TagRetriever(tagInputStream, properties);
    }

    public Enumeration getInstances(String string, Properties properties, int n, int n2) {
        TagInputStream tagInputStream = this.openTagIndex(string);
        if (tagInputStream == null) {
            return null;
        }
        return new TagRetriever(tagInputStream, properties, n, n2);
    }

    public Enumeration getTags() {
        File file = new File(this.workingDirectory);
        String[] stringArray = file.list(this);
        Vector<String> vector = new Vector<String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(stringArray[n].substring(0, stringArray[n].length() - 4));
            ++n;
        }
        return vector.elements();
    }

    public TagInputStream openTagIndex(String string) {
        TagInputStream tagInputStream;
        block2: {
            String string2 = String.valueOf(this.workingDirectory) + File.separatorChar + string.toUpperCase() + ".tag";
            tagInputStream = null;
            File file = new File(string2);
            if (!file.exists()) break block2;
            try {
                tagInputStream = new TagInputStream(string2);
            }
            catch (IOException iOException) {
                System.err.println("Annotation.openTagIndex(" + string + "): " + iOException);
            }
        }
        return tagInputStream;
    }
}

