/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus.annotation;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import uk.ac.bham.clg.cue.corpus.annotation.Tag;
import uk.ac.bham.clg.cue.corpus.annotation.TagInputStream;
import uk.ac.bham.clg.cue.corpus.annotation.TagOutputStream;
import uk.ac.bham.clg.cue.io.BitInputStream;
import uk.ac.bham.clg.util.HashInc;

public class AnnotationIndexer {
    private static final boolean DEBUG = true;
    private String inputFileName = null;
    private String directory = null;

    public AnnotationIndexer(String string, String string2) throws IOException {
        this.inputFileName = string;
        this.directory = string2;
        File file = new File(string);
        if (!file.exists() || !file.canRead()) {
            throw new IOException("AnnotationIndexer: Cannot read input file " + string);
        }
        file = new File(string2);
        if (!file.exists()) {
            throw new IOException("AnnotationIndexer: Cannot find output dir " + string2);
        }
        if (!file.isDirectory()) {
            throw new IOException("AnnotationIndexer: Not a directory: " + string2);
        }
        if (!file.canWrite()) {
            throw new IOException("AnnotationIndexer: Cannot write to " + string2);
        }
        this.index(string);
    }

    private HashInc getTagDistribution(TagInput tagInput) throws IOException {
        System.err.println("First pass through tag file");
        Tag tag = tagInput.readTag();
        int n = 0;
        HashInc hashInc = new HashInc();
        String string = null;
        while (tag != null) {
            string = tag.getLabel();
            if (string != null) {
                hashInc.put(string.intern());
                ++n;
            }
            tag = tagInput.readTag(tag);
            if (n % 100 == 0) {
                System.err.print(String.valueOf(n) + "\r");
            }
            if (n % 20000 != 0) continue;
            System.gc();
        }
        System.err.println("Processing " + n + " tags altogether");
        return hashInc;
    }

    public void index(String string) throws IOException {
        Tag tag;
        int n;
        Vector vector;
        Object object;
        int n2;
        TagInput tagInput = new TagInput(string);
        HashInc hashInc = this.getTagDistribution(tagInput);
        System.err.println("Processing " + hashInc.size() + " different tags");
        Enumeration enumeration = hashInc.keys();
        Hashtable hashtable = new Hashtable(hashInc.size());
        int n3 = 0;
        String string2 = null;
        int n4 = 0;
        String string3 = null;
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            n2 = hashInc.get(string3);
            if (n2 > n4) {
                n4 = n2;
                string2 = string3;
            }
            n3 += n2;
        }
        enumeration = hashInc.keys();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            n2 = hashInc.get(string3);
            if (string3.equals(string2)) continue;
            object = new Vector(n2);
            hashtable.put(string3.intern(), object);
        }
        System.err.println("start indexing " + n3 + " tags, max. Tag is " + string2);
        TagOutputStream tagOutputStream = new TagOutputStream(this.directory, string2, n4);
        object = null;
        tagInput.rewind();
        System.gc();
        int n5 = 0;
        while (n5 < n3) {
            object = tagInput.readTag();
            string3 = ((Tag)object).getLabel();
            if (string2.equals(string3)) {
                tagOutputStream.write((Tag)object);
            } else {
                vector = (Vector)hashtable.get(string3);
                if (vector == null) {
                    System.err.println("no storage found for " + string3);
                } else {
                    n = vector.size();
                    while (n > 0) {
                        tag = (Tag)vector.elementAt(n - 1);
                        if (tag.getStart() <= ((Tag)object).getStart()) break;
                        --n;
                    }
                    vector.insertElementAt(object, n);
                    int n6 = hashInc.get(string3);
                }
            }
            if (n5 % 100 == 0) {
                System.err.print(String.valueOf(n5) + "\r");
            }
            if (n5 % 10000 == 0) {
                System.gc();
            }
            ++n5;
        }
        tagOutputStream.close();
        tagInput.close();
        System.err.println("\nwriting out tags into files");
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            vector = (Vector)hashtable.get(string3);
            tagOutputStream = new TagOutputStream(this.directory, string3, vector.size());
            System.err.println("writing tag " + string3 + " (" + vector.size() + " occ)");
            n = 0;
            while (n < vector.size()) {
                tag = (Tag)vector.elementAt(n);
                tagOutputStream.write(tag);
                ++n;
            }
            tagOutputStream.close();
        }
    }

    public static void main(String[] stringArray) throws IOException {
        AnnotationIndexer annotationIndexer = new AnnotationIndexer(stringArray[0], stringArray[1]);
    }

    class TagInput {
        BitInputStream bis = null;
        TagInputStream tis = null;
        String filename = null;
        private char[] strbuf = new char[100];

        public TagInput(String string) throws IOException {
            this.filename = string;
            if (string.endsWith(".tag")) {
                this.tis = new TagInputStream(string);
            } else {
                this.bis = new BitInputStream(new DataInputStream(new FileInputStream(string)));
            }
        }

        public void close() throws IOException {
            if (this.bis != null) {
                this.bis.close();
            }
            if (this.tis != null) {
                this.tis.close();
            }
        }

        public Tag readTag() throws IOException {
            return this.readTag(null);
        }

        public Tag readTag(Tag tag) throws IOException {
            if (this.bis != null) {
                try {
                    int n = this.bis.readGamma() - 2;
                    int n2 = this.bis.readGamma() - 1;
                    int n3 = this.bis.readGamma() - 1;
                    if (n3 >= this.strbuf.length) {
                        this.strbuf = new char[n3];
                    }
                    int n4 = 0;
                    while (n4 < n3) {
                        this.strbuf[n4] = (char)(this.bis.readGamma() + 30);
                        ++n4;
                    }
                    if ((tag = Tag.analyseTag(0, new String(this.strbuf, 0, n3), tag)) != null) {
                        tag.setStart(n);
                        tag.setEnd(n + n2);
                        return tag;
                    }
                }
                catch (EOFException eOFException) {
                    System.err.println("\nreadTag: reached EOF");
                }
            } else {
                Tag tag2 = this.tis.read();
                if (tag2 == null) {
                    System.err.println("\nreadTag: reached EOF");
                } else {
                    String string;
                    tag2.label = string = tag2.getAttribute("real-name");
                    Properties properties = tag2.getAttrAsProp();
                    if (properties != null) {
                        ((Hashtable)properties).remove("real-name");
                    }
                    return tag2;
                }
            }
            return null;
        }

        public void rewind() throws IOException {
            if (this.bis != null) {
                this.bis.close();
                this.bis = new BitInputStream(new DataInputStream(new FileInputStream(this.filename)));
            }
            if (this.tis != null) {
                this.tis.close();
                this.tis = new TagInputStream(this.filename);
            }
        }
    }
}

