/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus.annotation;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import uk.ac.bham.clg.cue.corpus.annotation.Tag;
import uk.ac.bham.clg.cue.io.BitInputStream;

public class TagInputStream {
    private String label = null;
    private BitInputStream input = null;
    private FileInputStream fis = null;
    private String basename = null;
    private String[] attArray = null;
    private String[] valArray = null;
    private int number = 0;
    private int lastStart = 0;
    private boolean DEBUG = false;

    public TagInputStream(String string) throws IOException {
        InputStream inputStream;
        int n;
        String string2 = "";
        int n2 = string.lastIndexOf(File.separatorChar);
        if (n2 > 0) {
            string2 = string.substring(0, n2 + 1);
            string = string.substring(n2 + 1);
        }
        this.label = (n = string.lastIndexOf(".")) < 0 ? string : string.substring(0, n);
        File file = new File(String.valueOf(string2) + File.separatorChar + this.label + ".att");
        if (file.exists()) {
            this.fis = new FileInputStream(String.valueOf(string2) + File.separatorChar + this.label + ".att");
            if (this.DEBUG) {
                System.err.println("trying to open " + string2 + this.label + ".att");
            }
            try {
                Integer n3;
                String string3;
                inputStream = new ObjectInputStream(new BufferedInputStream(this.fis));
                Hashtable hashtable = (Hashtable)((ObjectInputStream)inputStream).readObject();
                Hashtable hashtable2 = (Hashtable)((ObjectInputStream)inputStream).readObject();
                if (this.DEBUG) {
                    System.err.println(String.valueOf(hashtable.size()) + " attributes found");
                }
                if (this.DEBUG) {
                    System.err.println(String.valueOf(hashtable2.size()) + " values found");
                }
                ((ObjectInputStream)inputStream).close();
                this.fis.close();
                this.attArray = new String[hashtable.size()];
                this.valArray = new String[hashtable2.size()];
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    string3 = (String)enumeration.nextElement();
                    n3 = (Integer)hashtable.get(string3);
                    this.attArray[n3.intValue()] = string3.intern();
                }
                enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    string3 = (String)enumeration.nextElement();
                    n3 = (Integer)hashtable2.get(string3);
                    this.valArray[n3.intValue()] = string3.intern();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Your setup is faulty: " + classNotFoundException);
            }
        }
        this.fis = new FileInputStream(String.valueOf(string2) + this.label + ".tag");
        inputStream = new DataInputStream(new BufferedInputStream(this.fis));
        this.input = new BitInputStream((DataInput)((Object)inputStream));
        this.number = this.input.readGamma() - 1;
        if (this.DEBUG) {
            System.err.println("file contains " + this.number + " tags");
        }
    }

    public void close() throws IOException {
        this.input.close();
        this.fis.close();
    }

    public String getAttrString(int n) {
        if (this.DEBUG) {
            System.err.println("getAttr:" + n);
        }
        return this.attArray[n - 1];
    }

    public final String getLabel() {
        return this.label;
    }

    public String getValueString(int n) {
        if (this.DEBUG) {
            System.err.println("getValue:" + n);
        }
        return this.valArray[n - 1];
    }

    public static void main(String[] stringArray) throws IOException {
        System.out.println("Reading tags from " + stringArray[0]);
        TagInputStream tagInputStream = new TagInputStream(stringArray[0]);
        int n = 0;
        Tag tag = tagInputStream.read();
        while (tag != null) {
            System.out.println(String.valueOf(++n) + ") [" + tag.getStart() + "-" + tag.getEnd() + "] " + tag.toString(1));
            tag = tagInputStream.read();
        }
    }

    public Tag read() throws IOException {
        int n;
        if (this.number == 0) {
            return null;
        }
        String string = this.getLabel().intern();
        this.lastStart = n = this.readGamma() + this.lastStart;
        int n2 = n + this.readGamma();
        Properties properties = this.readAttributes();
        Tag tag = new Tag(string, n - 1, n2 - 1, properties);
        --this.number;
        return tag;
    }

    public Properties readAttributes() throws IOException {
        if (this.attArray == null) {
            return null;
        }
        Properties properties = new Properties();
        int n = this.readGamma();
        if (this.DEBUG) {
            System.err.println("reading " + n + " attributes");
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.readGamma();
            int n4 = this.readGamma();
            if (this.DEBUG) {
                System.err.print("read attr " + n3 + "=" + n4);
            }
            String string = this.getAttrString(n3);
            String string2 = this.getValueString(n4);
            ((Hashtable)properties).put(string.intern(), string2.intern());
            ++n2;
        }
        if (this.DEBUG) {
            System.err.println("");
        }
        return properties;
    }

    public final int readDelta() throws IOException {
        int n = this.input.readBit();
        if (n == 0) {
            int n2 = this.input.readDelta() - 1;
            return n2;
        }
        int n3 = this.input.readDelta();
        return -n3;
    }

    public final int readGamma() throws IOException {
        int n = this.input.readBit();
        if (n == 0) {
            int n2 = this.input.readGamma() - 1;
            return n2;
        }
        int n3 = this.input.readGamma();
        return -n3;
    }
}

