/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus.annotation;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import uk.ac.bham.clg.cue.corpus.annotation.Tag;
import uk.ac.bham.clg.cue.io.BitOutputStream;

public class TagOutputStream {
    private BitOutputStream bos;
    private String label;
    private FileOutputStream fos = null;
    private String basename = null;
    private Hashtable attrTable = null;
    private Hashtable valTable = null;
    private int lastStart = 0;
    static final boolean DEBUG = false;

    public TagOutputStream(String string, String string2, int n) throws IOException {
        this.basename = String.valueOf(string) + File.separatorChar + string2;
        this.label = string2;
        this.fos = new FileOutputStream(String.valueOf(this.basename) + ".tag");
        this.bos = new BitOutputStream(new DataOutputStream(this.fos));
        if (this.bos == null) {
            throw new IOException("Cannot open " + this.basename + ".tag");
        }
        this.bos.writeGamma(n + 1);
        this.attrTable = new Hashtable();
        this.valTable = new Hashtable();
    }

    public void close() {
        try {
            this.bos.close();
            this.fos.close();
            if (this.attrTable.size() > 0) {
                this.fos = new FileOutputStream(String.valueOf(this.basename) + ".att");
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.fos);
                objectOutputStream.writeObject(this.attrTable);
                objectOutputStream.writeObject(this.valTable);
                objectOutputStream.close();
                this.fos.close();
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public int getAttrIndex(String string) {
        Integer n = (Integer)this.attrTable.get(string);
        if (n == null) {
            n = new Integer(this.attrTable.size());
            this.attrTable.put(string, n);
        }
        return n + 1;
    }

    public int getValueIndex(String string) {
        Integer n = (Integer)this.valTable.get(string);
        if (n == null) {
            n = new Integer(this.valTable.size());
            this.valTable.put(string, n);
        }
        return n + 1;
    }

    public void write(Tag tag) throws IOException {
        int n = tag.getStart() + 1;
        int n2 = tag.getEnd() + 1;
        this.writeGamma(n - this.lastStart);
        this.lastStart = n;
        this.writeGamma(n2 - n);
        this.writeAttributes(tag.getAttrAsProp());
    }

    public void writeAttributes(Properties properties) throws IOException {
        if (properties != null) {
            this.writeGamma(((Hashtable)properties).size());
            Enumeration<?> enumeration = properties.propertyNames();
            int n = 0;
            while (n < ((Hashtable)properties).size()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                int n2 = this.getAttrIndex(string);
                this.writeGamma(n2);
                n2 = this.getValueIndex(string2);
                this.writeGamma(n2);
                ++n;
            }
        } else {
            this.writeGamma(0);
        }
    }

    public final void writeBit(int n) throws IOException {
        this.bos.writeBit(n);
    }

    public final void writeDelta(int n) throws IOException {
        if (n < 0) {
            this.bos.writeBit(1);
            this.bos.writeDelta(-n);
        } else {
            this.bos.writeBit(0);
            this.bos.writeDelta(n + 1);
        }
    }

    public final void writeGamma(int n) throws IOException {
        if (n < 0) {
            this.bos.writeBit(1);
            this.bos.writeGamma(-n);
        } else {
            this.bos.writeBit(0);
            this.bos.writeGamma(n + 1);
        }
    }
}

