/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus.annotation;

import java.io.EOFException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import uk.ac.bham.clg.cue.corpus.annotation.Tag;
import uk.ac.bham.clg.cue.corpus.annotation.TagInputStream;

public class TagRetriever
implements Enumeration {
    private final int ALL = 0;
    private final int PART = 1;
    private final int FULL = 2;
    private int mode = 0;
    private int start = 0;
    private int end = 0;
    private int position = 0;
    private TagInputStream tis = null;
    private Tag currentTag = null;
    private String[] attributes = null;
    private String[] values = null;
    private final boolean DEBUG = false;
    private final boolean ATTRCASE = false;

    public TagRetriever(TagInputStream tagInputStream, Properties properties) {
        this.tis = tagInputStream;
        this.mode = 0;
        if (properties != null) {
            this.setAttr(properties);
        }
        this.currentTag = this.readNextElement();
    }

    public TagRetriever(TagInputStream tagInputStream, Properties properties, int n) {
        this.tis = tagInputStream;
        this.position = n;
        this.mode = 2;
        if (properties != null) {
            this.setAttr(properties);
        }
        this.currentTag = this.readNextElement();
    }

    public TagRetriever(TagInputStream tagInputStream, Properties properties, int n, int n2) {
        this.tis = tagInputStream;
        this.start = n;
        this.end = n2;
        this.mode = 1;
        if (properties != null) {
            this.setAttr(properties);
        }
        this.currentTag = this.readNextElement();
    }

    public boolean hasMoreElements() {
        return this.currentTag != null;
    }

    private boolean matches(String string, String string2) {
        if (string2 == null) {
            return string == null;
        }
        if (string2.endsWith("*")) {
            return string.startsWith(string2.substring(0, string2.length() - 1));
        }
        return string2.equals(string);
    }

    public Object nextElement() {
        if (this.currentTag == null) {
            throw new NoSuchElementException("No more Tags available");
        }
        Tag tag = this.currentTag;
        this.currentTag = this.readNextElement();
        return tag;
    }

    private Tag readNextElement() {
        Tag tag = null;
        boolean bl = false;
        block8: while (!bl) {
            try {
                tag = this.tis.read();
            }
            catch (EOFException eOFException) {
                break;
            }
            catch (IOException iOException) {
                break;
            }
            if (tag == null) {
                return null;
            }
            switch (this.mode) {
                case 0: {
                    bl = true;
                    break;
                }
                case 1: {
                    if (!tag.isValidFor(this.start, this.end)) break;
                    bl = true;
                    break;
                }
                case 2: {
                    if (!tag.isInRange(this.position)) break;
                    bl = true;
                    break;
                }
                default: {
                    System.err.println("TagRetriever: Unknown mode: " + this.mode);
                }
            }
            if (!bl || this.attributes == null) continue;
            int n = 0;
            while (n < this.attributes.length) {
                String string = tag.getAttribute(this.attributes[n], false);
                if (!this.matches(string, this.values[n])) {
                    bl = false;
                    continue block8;
                }
                ++n;
            }
        }
        if (!bl) {
            return null;
        }
        return tag;
    }

    private void setAttr(Properties properties) {
        this.attributes = new String[((Hashtable)properties).size()];
        this.values = new String[((Hashtable)properties).size()];
        Enumeration enumeration = ((Hashtable)properties).keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            try {
                this.attributes[n] = (String)enumeration.nextElement();
                this.attributes[n] = this.attributes[n].toLowerCase();
                this.values[n] = properties.getProperty(this.attributes[n]).toLowerCase();
                ++n;
            }
            catch (NoSuchElementException noSuchElementException) {
                System.err.println(noSuchElementException);
                break;
            }
        }
    }
}

