/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus.query;

import java.io.IOException;
import java.io.InputStream;

public final class ASCII_CharStream {
    int bufsize;
    int available;
    int tokenBegin;
    public int bufpos = -1;
    private int[] bufline;
    private int[] bufcolumn;
    private int column = 0;
    private int line = 1;
    private boolean prevCharIsCR = false;
    private boolean prevCharIsLF = false;
    private InputStream inputStream;
    private byte[] buffer;
    private int maxNextCharInd = 0;
    private int inBuf = 0;

    public ASCII_CharStream(InputStream inputStream, int n, int n2) {
        this.inputStream = inputStream;
        this.line = n;
        this.column = n2 - 1;
        this.bufsize = 4096;
        this.available = 4096;
        this.buffer = new byte[4096];
        this.bufline = new int[4096];
        this.bufcolumn = new int[4096];
    }

    public ASCII_CharStream(InputStream inputStream, int n, int n2, int n3) {
        this.inputStream = inputStream;
        this.line = n;
        this.column = n2 - 1;
        this.available = this.bufsize = n3;
        this.buffer = new byte[n3];
        this.bufline = new int[n3];
        this.bufcolumn = new int[n3];
    }

    public final char BeginToken() throws IOException {
        this.tokenBegin = -1;
        char c = this.readChar();
        this.tokenBegin = this.bufpos;
        return c;
    }

    public void Done() {
        this.buffer = null;
        this.bufline = null;
        this.bufcolumn = null;
    }

    private final void ExpandBuff(boolean bl) {
        byte[] byArray = new byte[this.bufsize + 2048];
        int[] nArray = new int[this.bufsize + 2048];
        int[] nArray2 = new int[this.bufsize + 2048];
        try {
            if (bl) {
                System.arraycopy(this.buffer, this.tokenBegin, byArray, 0, this.bufsize - this.tokenBegin);
                System.arraycopy(this.buffer, 0, byArray, this.bufsize - this.tokenBegin, this.bufpos);
                this.buffer = byArray;
                System.arraycopy(this.bufline, this.tokenBegin, nArray, 0, this.bufsize - this.tokenBegin);
                System.arraycopy(this.bufline, 0, nArray, this.bufsize - this.tokenBegin, this.bufpos);
                this.bufline = nArray;
                System.arraycopy(this.bufcolumn, this.tokenBegin, nArray2, 0, this.bufsize - this.tokenBegin);
                System.arraycopy(this.bufcolumn, 0, nArray2, this.bufsize - this.tokenBegin, this.bufpos);
                this.bufcolumn = nArray2;
                this.maxNextCharInd = this.bufpos += this.bufsize - this.tokenBegin;
            } else {
                System.arraycopy(this.buffer, this.tokenBegin, byArray, 0, this.bufsize - this.tokenBegin);
                this.buffer = byArray;
                System.arraycopy(this.bufline, this.tokenBegin, nArray, 0, this.bufsize - this.tokenBegin);
                this.bufline = nArray;
                System.arraycopy(this.bufcolumn, this.tokenBegin, nArray2, 0, this.bufsize - this.tokenBegin);
                this.bufcolumn = nArray2;
                this.maxNextCharInd = this.bufpos -= this.tokenBegin;
            }
        }
        catch (Throwable throwable) {
            System.out.println("Error : " + throwable.getClass().getName());
            throw new Error();
        }
        this.bufsize += 2048;
        this.available = this.bufsize;
        this.tokenBegin = 0;
    }

    private final void FillBuff() throws IOException {
        int n;
        if (this.maxNextCharInd == this.available) {
            if (this.available == this.bufsize) {
                if (this.tokenBegin > 2048) {
                    this.maxNextCharInd = 0;
                    this.bufpos = 0;
                    this.available = this.tokenBegin;
                } else if (this.tokenBegin < 0) {
                    this.maxNextCharInd = 0;
                    this.bufpos = 0;
                } else {
                    this.ExpandBuff(false);
                }
            } else if (this.available > this.tokenBegin) {
                this.available = this.bufsize;
            } else if (this.tokenBegin - this.available < 2048) {
                this.ExpandBuff(true);
            } else {
                this.available = this.tokenBegin;
            }
        }
        if ((n = this.inputStream.read(this.buffer, this.maxNextCharInd, this.available - this.maxNextCharInd)) == -1) {
            --this.bufpos;
            this.backup(0);
            if (this.tokenBegin == -1) {
                this.tokenBegin = this.bufpos;
            }
            throw new IOException();
        }
        this.maxNextCharInd += n;
    }

    public final String GetImage() {
        if (this.bufpos >= this.tokenBegin) {
            return new String(this.buffer, 0, this.tokenBegin, this.bufpos - this.tokenBegin + 1);
        }
        return String.valueOf(new String(this.buffer, 0, this.tokenBegin, this.bufsize - this.tokenBegin)) + new String(this.buffer, 0, 0, this.bufpos + 1);
    }

    public final byte[] GetSuffix(int n) {
        byte[] byArray = new byte[n];
        if (this.bufpos + 1 >= n) {
            System.arraycopy(this.buffer, this.bufpos - n + 1, byArray, 0, n);
        } else {
            System.arraycopy(this.buffer, this.bufsize - (n - this.bufpos - 1), byArray, 0, n - this.bufpos - 1);
            System.arraycopy(this.buffer, 0, byArray, n - this.bufpos - 1, this.bufpos + 1);
        }
        return byArray;
    }

    private final void UpdateLineColumn(char c) {
        ++this.column;
        if (this.prevCharIsLF) {
            this.prevCharIsLF = false;
            this.column = 1;
            ++this.line;
        } else if (this.prevCharIsCR) {
            this.prevCharIsCR = false;
            if (c == '\n') {
                this.prevCharIsLF = true;
            } else {
                this.column = 1;
                ++this.line;
            }
        }
        switch (c) {
            case '\r': {
                this.prevCharIsCR = true;
                break;
            }
            case '\n': {
                this.prevCharIsLF = true;
                break;
            }
            case '\t': {
                this.column += 9 - (this.column & 7);
                break;
            }
        }
        this.bufline[this.bufpos] = this.line;
        this.bufcolumn[this.bufpos] = this.column;
    }

    public final void backup(int n) {
        this.inBuf += n;
        if ((this.bufpos -= n) < 0) {
            this.bufpos += this.bufsize;
        }
    }

    public final int getBeginColumn() {
        return this.bufcolumn[this.tokenBegin];
    }

    public final int getBeginLine() {
        return this.bufline[this.tokenBegin];
    }

    public final int getColumn() {
        return this.bufcolumn[this.bufpos];
    }

    public final int getEndColumn() {
        return this.bufcolumn[this.bufpos];
    }

    public final int getEndLine() {
        return this.bufline[this.bufpos];
    }

    public final int getLine() {
        return this.bufline[this.bufpos];
    }

    public final char readChar() throws IOException {
        if (this.inBuf > 0) {
            --this.inBuf;
            return (char)(0xFF & this.buffer[this.bufpos == this.bufsize - 1 ? (this.bufpos = 0) : (this.bufpos = this.bufpos + 1)]);
        }
        if (++this.bufpos >= this.maxNextCharInd) {
            this.FillBuff();
        }
        char c = (char)(0xFF & this.buffer[this.bufpos]);
        this.UpdateLineColumn(c);
        return c;
    }
}

