/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus.query;

public class Position {
    public static final int NONE = -1;
    public static final int WORD = 0;
    public static final int TAG = 1;
    public static final int ENDTAG = 2;
    int position;
    int type;

    public Position(int n, int n2) {
        this.position = n;
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                this.type = n2;
                break;
            }
            default: {
                System.err.println("Illegal type " + n2);
                this.type = 0;
            }
        }
    }

    public int diff(Position position) {
        if (position.type == this.type) {
            return this.position - position.position;
        }
        if (this.type == 0) {
            if (position.type == 2) {
                return this.position - position.position - 1;
            }
            return this.position - position.position + 1;
        }
        if (this.type == 1) {
            return this.position - position.position + 1;
        }
        if (this.type == 2) {
            return this.position - position.position - 1;
        }
        return this.position - position.position;
    }

    public boolean equals(Position position) {
        return this.position == position.position;
    }

    public boolean isValid() {
        return this.position != -1;
    }

    public boolean lessThan(Position position) {
        if (position.type == this.type) {
            return this.position < position.position;
        }
        if (this.type == 0) {
            if (position.type == 2) {
                return this.position <= position.position;
            }
            return this.position < position.position;
        }
        if (this.type == 1) {
            return this.position <= position.position;
        }
        if (this.type == 2) {
            return this.position < position.position;
        }
        return false;
    }

    public Position minus(int n) {
        return new Position(this.position - n, -1);
    }

    public Position plus(int n) {
        return new Position(this.position + n, -1);
    }
}

