/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus.query;

import java.io.PrintStream;
import java.util.Vector;
import uk.ac.bham.clg.cue.corpus.Corpus;
import uk.ac.bham.clg.cue.corpus.query.Position;

public abstract class QueryNode
implements Cloneable {
    Corpus theCorpus = null;
    QueryNode[] children = null;
    int chNum = 0;
    String description = "";
    final boolean DEBUG = false;
    boolean expired = false;

    public QueryNode() {
    }

    public QueryNode(Vector vector) {
        this.chNum = vector.size();
        this.children = new QueryNode[this.chNum];
        int n = 0;
        while (n < this.chNum) {
            this.children[n] = (QueryNode)vector.elementAt(n);
            ++n;
        }
        this.description = String.valueOf(this.description) + " (" + this.chNum + " ch)";
    }

    public Corpus getCorpus() {
        return this.theCorpus;
    }

    public String getDesc() {
        return this.description;
    }

    public abstract Position getNextPosition();

    public void getReady() {
    }

    public QueryNode instantiate(Corpus corpus) {
        this.theCorpus = corpus;
        try {
            QueryNode queryNode = (QueryNode)this.clone();
            queryNode.chNum = this.chNum;
            int n = 0;
            while (n < this.chNum) {
                queryNode.children[n] = queryNode.children[n].instantiate(corpus);
                ++n;
            }
            queryNode.getReady();
            return queryNode;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println(cloneNotSupportedException);
            return null;
        }
    }

    public void print(PrintStream printStream, int n) {
        int n2 = 0;
        while (n2 < n) {
            printStream.print("|");
            ++n2;
        }
        printStream.println("-" + this.getClass() + " [" + this.description + "]");
        int n3 = 0;
        while (n3 < this.chNum) {
            this.children[n3].print(printStream, n + 1);
            ++n3;
        }
    }

    public void skip(int n) {
        int n2 = 0;
        while (n2 < this.chNum) {
            this.children[n2].skip(n);
            ++n2;
        }
    }
}

