/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.corpus.query;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import uk.ac.bham.clg.cue.corpus.Corpus;
import uk.ac.bham.clg.cue.corpus.CorpusException;
import uk.ac.bham.clg.cue.corpus.Item;
import uk.ac.bham.clg.cue.corpus.query.Position;
import uk.ac.bham.clg.cue.corpus.query.QueryNode;

public class WordNode
extends QueryNode {
    private String word = null;
    private Enumeration source = null;
    private Item nextItem = null;

    public WordNode(String string) {
        this.description = this.word = string;
    }

    public Position getNextPosition() {
        if (this.nextItem == null) {
            return null;
        }
        Position position = new Position(this.nextItem.getOffset(), 0);
        this.nextItem = this.source.hasMoreElements() ? (Item)this.source.nextElement() : null;
        return position;
    }

    public QueryNode instantiate(Corpus corpus) {
        try {
            WordNode wordNode = (WordNode)this.clone();
            wordNode.theCorpus = corpus;
            wordNode.description = "*" + this.description;
            try {
                wordNode.source = corpus.retrieveItem(this.word, "text", -1);
            }
            catch (CorpusException corpusException) {
                System.err.println(corpusException);
            }
            if (wordNode.source != null && wordNode.source.hasMoreElements()) {
                wordNode.nextItem = (Item)wordNode.source.nextElement();
            }
            return wordNode;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println(cloneNotSupportedException);
            return null;
        }
    }

    public void skip(int n) {
        while (this.nextItem != null && this.nextItem.getOffset() < n) {
            try {
                this.nextItem = (Item)this.source.nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                this.nextItem = null;
            }
        }
    }
}

