/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.io;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class BitOutputStream
extends OutputStream {
    static final boolean DEBUG = false;
    DataOutput outputStream = null;
    int outputByte = 0;
    int outputCounter = 128;
    long streamPosition = 0L;
    int[] bitMask;

    public BitOutputStream(DataOutput dataOutput) {
        this.outputStream = dataOutput;
        this.outputCounter = 128;
        this.outputByte = 0;
        this.streamPosition = 0L;
        this.bitMask = new int[32];
        this.bitMask[0] = 1;
        int n = 1;
        while (n < 32) {
            this.bitMask[n] = 2 * this.bitMask[n - 1];
            ++n;
        }
    }

    public void close() {
        this.flush();
        this.outputStream = null;
    }

    public void flush() {
        this.writeByte();
    }

    public long getStreamPosition() {
        return this.streamPosition;
    }

    public static void main(String[] stringArray) throws IOException {
        int n = -1;
        BitOutputStream bitOutputStream = new BitOutputStream(new RandomAccessFile(stringArray[0], "rw"));
        if ("delta".equals(stringArray[0])) {
            n = bitOutputStream.writeDelta(Integer.parseInt(stringArray[1]));
        }
        if ("gamma".equals(stringArray[0])) {
            n = bitOutputStream.writeGamma(Integer.parseInt(stringArray[1]));
        }
        bitOutputStream.close();
        System.err.println("length = " + n);
    }

    public void write(int n) {
        System.err.println("BitOutputStream.write() should not be called!");
    }

    public void writeBit(int n) throws IOException, IllegalArgumentException {
        if (this.outputCounter == 0) {
            this.writeByte();
        }
        switch (n) {
            case 1: {
                this.outputByte += this.outputCounter;
            }
            case 0: {
                this.outputCounter /= 2;
                ++this.streamPosition;
                break;
            }
            default: {
                throw new IllegalArgumentException("writeBit: " + n + " is neither 0 nor 1");
            }
        }
    }

    private void writeByte() {
        if (this.outputStream == null) {
            throw new Error("write failed: BitOutputStream == null");
        }
        try {
            this.outputStream.writeByte(this.outputByte);
        }
        catch (IOException iOException) {
            System.err.println("BitOutputStream: " + iOException);
        }
        while (this.outputCounter > 0) {
            ++this.streamPosition;
            this.outputCounter /= 2;
        }
        this.outputByte = 0;
        this.outputCounter = 128;
    }

    public int writeDelta(int n) throws IOException, IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException("writeDelta: " + n);
        }
        if (n == 1) {
            this.writeBit(0);
            return 1;
        }
        int n2 = n;
        int n3 = 0;
        while (n2 > 0) {
            ++n3;
            n2 /= 2;
        }
        int n4 = this.writeGamma(n3);
        this.writeInt(n, n3 - 1);
        return n4 + n3 - 1;
    }

    public int writeGamma(int n) throws IOException, IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException("writeGamma: " + n);
        }
        if (n == 1) {
            this.writeBit(0);
            return 1;
        }
        int n2 = n / 2;
        int n3 = 0;
        while (n2 > 0) {
            this.writeBit(1);
            ++n3;
            n2 /= 2;
        }
        this.writeBit(0);
        this.writeInt(n, n3);
        return 2 * n3 + 1;
    }

    public void writeInt(int n, int n2) throws IOException {
        int n3 = this.bitMask[n2 - 1];
        while (n2-- > 0) {
            if ((n & n3) > 0) {
                this.writeBit(1);
            } else {
                this.writeBit(0);
            }
            n3 /= 2;
        }
    }
}

