/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.io;

import java.io.DataInput;
import java.io.IOException;
import java.io.RandomAccessFile;
import uk.ac.bham.clg.cue.io.BitInputStream;

public class BufferedBitInputStream
extends BitInputStream {
    static final boolean DEBUG = false;
    DataInput inputStream = null;
    boolean randomAccess = false;
    int inputByte = 0;
    int inputCounter = 0;
    byte[] theBuffer = new byte[4000];
    int bufferPosition = -1;

    public BufferedBitInputStream(DataInput dataInput) throws IOException {
        super(dataInput);
    }

    public int available() {
        return 0;
    }

    public void close() throws IOException {
        if (this.randomAccess) {
            ((RandomAccessFile)this.inputStream).close();
        }
    }

    private void fillByte() throws IOException {
        this.inputByte = 0;
        this.inputCounter = 128;
        if (this.inputStream == null) {
            System.err.println("BufferedBitInputStream: inputStream == null");
        } else {
            if (this.bufferPosition < 0 || this.bufferPosition > this.theBuffer.length) {
                this.inputStream.readFully(this.theBuffer);
                this.bufferPosition = 0;
            }
            this.inputByte = this.theBuffer[this.bufferPosition++] & 0xFF;
        }
    }

    public static void main(String[] stringArray) throws IOException {
        BufferedBitInputStream bufferedBitInputStream = new BufferedBitInputStream(new RandomAccessFile(stringArray[0], "r"));
        if ("delta".equals(stringArray[0])) {
            System.out.println(" " + bufferedBitInputStream.readDelta());
        }
        if ("gamma".equals(stringArray[0])) {
            System.out.println(" " + bufferedBitInputStream.readGamma());
        }
    }

    public synchronized void mark(int n) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() {
        return -1;
    }

    public int read(byte[] byArray) {
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) {
        return -1;
    }

    public int readBit() throws IOException {
        if (this.inputCounter == 0) {
            this.fillByte();
        }
        int n = (this.inputByte & this.inputCounter) == this.inputCounter ? 1 : 0;
        this.inputCounter /= 2;
        return n;
    }

    public int readDelta() throws IOException {
        int n = this.readGamma() - 1;
        int n2 = 1;
        if (n > 0) {
            n2 = this.readInt(n);
        }
        return (1 << n) + n2;
    }

    public int readGamma() throws IOException {
        int n = 0;
        int n2 = 1;
        while (this.readBit() == 1) {
            ++n;
        }
        if (n > 0) {
            n2 = this.readInt(n);
            return (1 << n) + n2;
        }
        return 1;
    }

    public int readInt(int n) throws IOException {
        int n2 = 0;
        while (n > 0) {
            n2 = n2 * 2 + this.readBit();
            --n;
        }
        return n2;
    }

    public synchronized void reset() {
    }

    public void seek(long l) throws IOException {
        if (!this.randomAccess) {
            throw new IOException("No random access possible");
        }
        long l2 = l / 8L;
        l %= 8L;
        this.bufferPosition = -1;
        try {
            ((RandomAccessFile)this.inputStream).seek(l2);
            this.fillByte();
        }
        catch (IOException iOException) {
            System.err.println("seek: " + iOException);
        }
        this.skip(l);
    }

    public long skip(long l) throws IOException {
        long l2 = 0L;
        while (--l >= 0L) {
            this.readBit();
            ++l2;
        }
        return l2;
    }
}

