/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.StringTokenizer;
import uk.ac.bham.clg.cue.modules.tagger.QTag;
import uk.ac.bham.clg.cue.modules.tagger.TaggerException;
import uk.ac.bham.clg.cue.modules.tagger.Word;

public class TaggedReader
extends BufferedReader {
    QTag theTagger = null;
    StringTokenizer theTokeniser = new StringTokenizer("");

    public TaggedReader(String string, Reader reader) {
        super(reader);
        try {
            this.theTagger = new QTag(string);
        }
        catch (TaggerException taggerException) {
            System.err.println("TaggedReader: " + (Object)((Object)taggerException));
            this.theTagger = null;
        }
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.err.println("usage: TaggedReader tagset-name");
            System.exit(1);
        }
        TaggedReader taggedReader = new TaggedReader(stringArray[0], new InputStreamReader(System.in));
        String string = null;
        while ((string = taggedReader.readLine()) != null) {
            System.out.println(string);
        }
    }

    public String readLine() throws IOException {
        Object object;
        if (this.theTagger == null) {
            return super.readLine();
        }
        if (this.theTokeniser == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        while (this.theTokeniser != null && stringBuffer.length() < 60) {
            Word word;
            if (!this.theTokeniser.hasMoreTokens()) {
                object = super.readLine();
                if (object == null) {
                    this.theTokeniser = null;
                    continue;
                }
                this.theTokeniser = new StringTokenizer((String)object);
            }
            if ((word = this.theTagger.tag((String)(object = this.theTokeniser.nextToken()), null)) == null) continue;
            stringBuffer.append(String.valueOf(word.getString()) + " " + word.getTag() + " ");
        }
        if (this.theTokeniser == null) {
            object = this.theTagger.tag(null, null);
            if (object != null) {
                stringBuffer.append(String.valueOf(object.getString()) + " " + object.getTag() + " ");
            }
            if ((object = this.theTagger.tag(null, null)) != null) {
                stringBuffer.append(String.valueOf(object.getString()) + " " + object.getTag() + " ");
            }
        }
        return stringBuffer.toString();
    }
}

