/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.qwick;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import uk.ac.bham.clg.cue.corpus.Collocate;
import uk.ac.bham.clg.cue.corpus.Collocations;
import uk.ac.bham.clg.cue.corpus.Concordances;
import uk.ac.bham.clg.cue.corpus.Cue;
import uk.ac.bham.clg.cue.qwick.Progress;
import uk.ac.bham.clg.cue.qwick.Qwick;
import uk.ac.bham.clg.cue.qwick.SaveDialog;
import uk.ac.bham.clg.cue.qwick.ToolBar;
import uk.ac.bham.clg.cue.qwick.ToolbarTarget;
import uk.ac.bham.clg.extawt.SwingWorker;
import uk.ac.bham.clg.util.options.ValueModel;

class CollocationPage
implements ToolbarTarget {
    static final boolean DEBUG = true;
    private Cue cue;
    private Qwick qwick;
    private Collocate[] collocates;
    private int[] collIndex = null;
    private Collocations collocations = null;
    private boolean dirty = false;
    private ValueModel evalfuncVM = null;
    private ValueModel spanLeftVM = null;
    private ValueModel spanRightVM = null;
    private ValueModel directionVM = null;
    private ValueModel casefoldVM = null;
    private ValueModel cutoffVM = null;
    private JComboBox evalFuncList = null;
    private JCheckBox dirCheck = null;
    private JCheckBox caseCheck = null;
    private JTextField cutOff = null;
    private JTable collTable = null;
    private JButton applyButton = null;
    private JFileChooser fileChooser = null;
    private TableModel model = null;
    private ToolBar theToolbar;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;

    public CollocationPage(Qwick qwick, Cue cue, JPanel jPanel) {
        Serializable serializable;
        this.qwick = qwick;
        this.cue = cue;
        this.evalfuncVM = this.cue.getValueModel("collocation.evalfunc");
        this.spanLeftVM = this.cue.getValueModel("collocation.span.left");
        this.spanRightVM = this.cue.getValueModel("collocation.span.right");
        this.directionVM = this.cue.getValueModel("collocation.direction");
        this.casefoldVM = this.cue.getValueModel("collocation.casefold");
        this.cutoffVM = this.cue.getValueModel("collocation.cutoff");
        if (this.evalfuncVM == null || this.spanLeftVM == null || this.spanRightVM == null || this.directionVM == null || this.casefoldVM == null || this.cutoffVM == null) {
            throw new RuntimeException("Couldn't load all required ValueModels!");
        }
        String[] stringArray = this.evalfuncVM.getChoiceNames();
        Box box = Box.createVerticalBox();
        JPanel jPanel2 = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Evaluation Function");
        this.evalFuncList = new JComboBox<String>(stringArray);
        this.evalFuncList.setSelectedIndex(this.evalfuncVM.getSelectedIndex());
        this.evalFuncList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CollocationPage.this.evalfuncVM.setValue(CollocationPage.this.evalFuncList.getSelectedIndex());
            }
        });
        jPanel2.add(this.evalFuncList);
        jPanel2.setBorder(titledBorder);
        box.add(jPanel2);
        Box box2 = Box.createVerticalBox();
        this.dirCheck = new JCheckBox("Direction", (boolean)((Boolean)this.directionVM.getValue()));
        this.dirCheck.setMnemonic('d');
        this.dirCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    CollocationPage.this.directionVM.setValue(new Boolean(true));
                } else {
                    CollocationPage.this.directionVM.setValue(new Boolean(false));
                }
            }
        });
        box2.add(this.dirCheck);
        this.caseCheck = new JCheckBox("Case Fold", (boolean)((Boolean)this.casefoldVM.getValue()));
        this.caseCheck.setMnemonic('c');
        this.caseCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    CollocationPage.this.casefoldVM.setValue(new Boolean(true));
                } else {
                    CollocationPage.this.casefoldVM.setValue(new Boolean(false));
                }
            }
        });
        box2.add(this.caseCheck);
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder("Enhancer");
        jPanel2 = new JPanel();
        jPanel2.add(box2);
        jPanel2.setBorder(titledBorder2);
        box.add(jPanel2);
        Box box3 = Box.createVerticalBox();
        final JTextField jTextField = new JTextField(String.valueOf(String.valueOf(this.spanLeftVM.getValue())), 3);
        jTextField.setHorizontalAlignment(4);
        jTextField.addKeyListener(this.qwick.numberAdapter);
        final JTextField jTextField2 = new JTextField(String.valueOf(String.valueOf(this.spanRightVM.getValue())), 3);
        jTextField2.setHorizontalAlignment(4);
        jTextField2.addKeyListener(this.qwick.numberAdapter);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(new JLabel("Span:"));
        jPanel3.add(jTextField);
        jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    spanLeftVM.setValue(new Integer(jTextField.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(qwick, "Not a valid number: " + jTextField.getText(), "Number Error", 0);
                }
            }
        });
        jTextField2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    cue.setValue("collocation.span.right", new Integer(jTextField2.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(qwick, "Not a valid number: " + jTextField2.getText(), "Number Error", 0);
                }
            }
        });
        jPanel3.add(new JLabel(" : "));
        jPanel3.add(jTextField2);
        box3.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        this.cutOff = new JTextField(String.valueOf(String.valueOf(this.cutoffVM.getValue())), 7);
        this.cutOff.setHorizontalAlignment(4);
        this.cutOff.addKeyListener(this.qwick.numberAdapter);
        jPanel4.add(new JLabel("Cut-Off:"));
        jPanel4.add(this.cutOff);
        this.cutOff.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    CollocationPage.this.cutoffVM.setValue(new Integer(CollocationPage.this.cutOff.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(CollocationPage.this.qwick, "Not a valid number: " + CollocationPage.this.cutOff.getText(), "Number Error", 0);
                }
            }
        });
        box3.add(jPanel4);
        TitledBorder titledBorder3 = BorderFactory.createTitledBorder("Environment");
        jPanel2 = new JPanel();
        jPanel2.add(box3);
        jPanel2.setBorder(titledBorder3);
        box.add(jPanel2);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        this.applyButton = new JButton("Calculate");
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                qwick.waitCursor();
                SwingWorker swingWorker = new SwingWorker(jTextField, jTextField2, this){
                    private final /* synthetic */ JTextField val$rightSpan;
                    private final /* synthetic */ JTextField val$leftSpan;
                    private final /* synthetic */ CollocationPage this$0;
                    {
                        this.val$leftSpan = jTextField;
                        this.val$rightSpan = jTextField2;
                        this.this$0 = collocationPage;
                    }

                    public Object construct() {
                        CollocationPage.access$4(this.this$0).setValue(new Integer(this.val$leftSpan.getText()));
                        CollocationPage.access$9(this.this$0).setValue(new Integer(this.val$rightSpan.getText()));
                        CollocationPage.access$7(this.this$0).setValue(new Integer(CollocationPage.access$8(this.this$0).getText()));
                        CollocationPage.access$10(this.this$0).setEnabled(false);
                        CollocationPage.access$14(this.this$0, CollocationPage.access$12(this.this$0, CollocationPage.access$11(this.this$0)));
                        ((AbstractTableModel)CollocationPage.access$15(this.this$0)).fireTableDataChanged();
                        CollocationPage.access$5(this.this$0).resetCursor();
                        CollocationPage.access$10(this.this$0).setEnabled(true);
                        return this;
                    }
                };
            }
        });
        jPanel5.add("Center", this.applyButton);
        box.add(jPanel5);
        this.model = new AbstractTableModel(){

            public Class getColumnClass(int n) {
                switch (n) {
                    case 0: {
                        return class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = CollocationPage.class$("java.lang.Integer"));
                    }
                    case 1: {
                        return class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = CollocationPage.class$("java.lang.String"));
                    }
                    case 2: {
                        return class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = CollocationPage.class$("java.lang.Integer"));
                    }
                    case 3: {
                        return class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = CollocationPage.class$("java.lang.Integer"));
                    }
                    case 4: {
                        return class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = CollocationPage.class$("java.lang.Double"));
                    }
                }
                return null;
            }

            public int getColumnCount() {
                return 5;
            }

            public String getColumnName(int n) {
                switch (n) {
                    case 0: {
                        return "#";
                    }
                    case 1: {
                        return "Collocate";
                    }
                    case 2: {
                        return "Joint Freq";
                    }
                    case 3: {
                        return "Total Freq";
                    }
                    case 4: {
                        return "Score";
                    }
                }
                return "???";
            }

            public int getRowCount() {
                if (CollocationPage.this.collocates == null) {
                    return 0;
                }
                return CollocationPage.this.collocates.length;
            }

            public Object getValueAt(int n, int n2) {
                if (CollocationPage.this.collocates[n] == null) {
                    return null;
                }
                switch (n2) {
                    case 0: {
                        return new Integer(CollocationPage.this.collIndex[n]);
                    }
                    case 1: {
                        return CollocationPage.this.collocates[n].getWord();
                    }
                    case 2: {
                        return new Integer(CollocationPage.this.collocates[n].getObserved());
                    }
                    case 3: {
                        return new Integer(CollocationPage.this.collocates[n].getTotal());
                    }
                    case 4: {
                        return new Double(CollocationPage.this.collocates[n].getScore());
                    }
                }
                return null;
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.collTable = new JTable(this.model);
        this.collTable.setBackground(Color.white);
        JScrollPane jScrollPane = new JScrollPane(this.collTable);
        this.collTable.setPreferredScrollableViewportSize(new Dimension(300, 400));
        int[] nArray = new int[]{20, 150, 60, 75, 80};
        int n = 0;
        while (n < 5) {
            serializable = this.collTable.getColumnModel().getColumn(n);
            ((TableColumn)serializable).setPreferredWidth(nArray[n]);
            ++n;
        }
        serializable = this.collTable.getTableHeader();
        ((Component)serializable).addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                CollocationPage.this.qwick.waitCursor();
                TableColumnModel tableColumnModel = CollocationPage.this.collTable.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                if (mouseEvent.getClickCount() == 1 && n != -1) {
                    int n2 = mouseEvent.getModifiers() & 1;
                    boolean bl = n2 != 0;
                    CollocationPage.this.sortColumn(n, bl);
                }
                CollocationPage.this.qwick.resetCursor();
            }
        });
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.add("North", box);
        jPanel6.setAlignmentX(0.5f);
        jPanel6.setAlignmentY(0.5f);
        jScrollPane.setAlignmentX(0.0f);
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel7 = new JPanel();
        TitledBorder titledBorder4 = BorderFactory.createTitledBorder("Collocation Parameters");
        jPanel7.add(jPanel6);
        jPanel7.setBorder(titledBorder4);
        jPanel.add("West", jPanel7);
        jPanel.add("Center", jScrollPane);
        JLabel jLabel = new JLabel(" ");
        jPanel.add("North", jLabel);
    }

    static /* synthetic */ JButton access$10(CollocationPage collocationPage) {
        return collocationPage.applyButton;
    }

    static /* synthetic */ Collocate[] access$11(CollocationPage collocationPage) {
        return collocationPage.calculate();
    }

    static /* synthetic */ Collocate[] access$12(CollocationPage collocationPage, Collocate[] collocateArray) {
        return collocationPage.filterNulls(collocateArray);
    }

    static /* synthetic */ void access$14(CollocationPage collocationPage, Collocate[] collocateArray) {
        collocationPage.collocates = collocateArray;
    }

    static /* synthetic */ TableModel access$15(CollocationPage collocationPage) {
        return collocationPage.model;
    }

    static /* synthetic */ ValueModel access$9(CollocationPage collocationPage) {
        return collocationPage.spanRightVM;
    }

    private Collocate[] calculate() {
        Collocate[] collocateArray = null;
        Concordances concordances = this.qwick.getWorkingSet();
        Progress progress = new Progress(this.qwick);
        if (concordances != null) {
            Concordances concordances2 = concordances;
            synchronized (concordances2) {
                this.collocations = new Collocations(this.cue, concordances);
                concordances = null;
                collocateArray = this.collocations.calculate(this.dirty, progress);
                this.qwick.resetCursor();
                this.init(this.theToolbar);
            }
        } else {
            JOptionPane.showMessageDialog(this.qwick, "No working data set available", "Collocation Error", 0);
            this.qwick.select(1);
        }
        if (collocateArray != null) {
            this.collIndex = new int[collocateArray.length];
            int n = 0;
            while (n < collocateArray.length) {
                this.collIndex[n] = n + 1;
                ++n;
            }
        } else {
            this.collIndex = null;
        }
        this.init(this.theToolbar);
        return collocateArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private int compareRows(int n, int n2, int n3, boolean bl) {
        int n4 = 0;
        if (this.collocates[n] == null && this.collocates[n2] == null) {
            return 0;
        }
        if (this.collocates[n] == null) {
            return -1;
        }
        if (this.collocates[n2] == null) {
            return 1;
        }
        switch (n3) {
            case 0: {
                n4 = this.collIndex[n] - this.collIndex[n2];
                break;
            }
            case 1: {
                String string = this.collocates[n2].getWord();
                n4 = this.collocates[n].getWord().compareTo(string);
                break;
            }
            case 2: {
                n4 = this.collocates[n2].getObserved() - this.collocates[n].getObserved();
                break;
            }
            case 3: {
                n4 = this.collocates[n2].getTotal() - this.collocates[n].getTotal();
                break;
            }
            case 4: {
                double d = this.collocates[n2].getScore() - this.collocates[n].getScore();
                n4 = Math.abs(d) < 1.0E-7 ? 0 : (d < 0.0 ? -1 : 1);
            }
        }
        if (bl) {
            return -n4;
        }
        return n4;
    }

    private Collocate[] filterNulls(Collocate[] collocateArray) {
        if (collocateArray == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < collocateArray.length) {
            if (collocateArray[n2] != null) {
                ++n;
            }
            ++n2;
        }
        if (n == collocateArray.length) {
            return collocateArray;
        }
        Collocate[] collocateArray2 = new Collocate[n];
        n = 0;
        int n3 = 0;
        while (n3 < collocateArray.length) {
            if (collocateArray[n3] != null) {
                collocateArray2[n++] = collocateArray[n3];
            }
            ++n3;
        }
        return collocateArray2;
    }

    public void help() {
        this.qwick.help("collocationPage.html");
    }

    public void init(ToolBar toolBar) {
        this.theToolbar = toolBar;
        if (this.collocates == null) {
            this.applyButton.setForeground(Color.red);
            toolBar.noPrint();
            toolBar.noSave();
            toolBar.noLoad();
            toolBar.noSort();
        } else {
            toolBar.noLoad();
            this.applyButton.setForeground(Color.black);
        }
    }

    public void invalidateData() {
        this.dirty = true;
    }

    public void load() throws IOException {
        throw new IOException("No LOAD option for collocations");
    }

    public void print() {
        PrintJob printJob = null;
        printJob = this.qwick.getToolkit().getPrintJob(this.qwick, "Print Concordance Table", null);
        if (printJob != null) {
            Graphics graphics = printJob.getGraphics();
            if (graphics != null) {
                ((Component)this.collTable).printAll(graphics);
                graphics.dispose();
            } else {
                System.err.println("could not get printGraphics object");
            }
            printJob.end();
        } else {
            System.err.println("Print Job cancelled");
        }
    }

    public void save() throws IOException {
        SaveDialog saveDialog = this.qwick.getSaveDialog();
        saveDialog.setBinary(false);
        int n = saveDialog.showDialog("Save Collocations", null);
        saveDialog.setBinary(true);
        if (n == 0) {
            boolean bl;
            int n2 = saveDialog.getFormat();
            String string = saveDialog.getFilename();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            boolean bl2 = bl = n2 == 0;
            if (bl) {
                bufferedWriter.write("<html>\n<center>\n<table>\n");
                bufferedWriter.write("<tr>\n");
                int n3 = this.model.getColumnCount();
                int n4 = 0;
                while (n4 < n3) {
                    bufferedWriter.write("<td>" + this.model.getColumnName(n4) + "</td>");
                    ++n4;
                }
                bufferedWriter.write("\n</tr>\n");
                int n5 = 0;
                while (n5 < this.model.getRowCount()) {
                    bufferedWriter.write("<tr>");
                    int n6 = 0;
                    while (n6 < n3) {
                        bufferedWriter.write("<td>" + this.model.getValueAt(n5, n6) + "</td>");
                        ++n6;
                    }
                    bufferedWriter.write("</tr>\n");
                    ++n5;
                }
                bufferedWriter.write("</table>\n</center>\n</html>\n");
            } else {
                int[] nArray = new int[]{5, 25, 35, 45, 55};
                int n7 = this.model.getColumnCount();
                StringBuffer stringBuffer = new StringBuffer(60);
                int n8 = 0;
                while (n8 < n7) {
                    stringBuffer.append(this.model.getColumnName(n8));
                    while (stringBuffer.length() < nArray[n8]) {
                        stringBuffer.append(' ');
                    }
                    ++n8;
                }
                bufferedWriter.write(String.valueOf(String.valueOf(stringBuffer)) + "\n");
                int n9 = 0;
                while (n9 < this.model.getRowCount()) {
                    stringBuffer.setLength(0);
                    int n10 = 0;
                    while (n10 < n7) {
                        stringBuffer.append(this.model.getValueAt(n9, n10));
                        while (stringBuffer.length() < nArray[n10]) {
                            stringBuffer.append(' ');
                        }
                        ++n10;
                    }
                    bufferedWriter.write(String.valueOf(String.valueOf(stringBuffer)) + "\n");
                    ++n9;
                }
            }
            bufferedWriter.close();
        }
    }

    public void sort() {
        JOptionPane.showMessageDialog(this.qwick, "Please click on a column header to sort that column\nShift-click sorts in reverse order", "Collocation Sorting", 1);
    }

    private void sortColumn(int n, boolean bl) {
        int n2 = this.collocates.length;
        int n3 = 0;
        int n4 = n2 - 1;
        while (n3 < n4) {
            int n5 = 0;
            int n6 = n3;
            while (n6 < n4) {
                if (this.compareRows(n6 + 1, n6, n, bl) < 0) {
                    this.swapRows(n6 + 1, n6);
                    n5 = n6;
                }
                ++n6;
            }
            n4 = n5;
            n5 = n2 - 1;
            int n7 = n4;
            while (n7 > n3) {
                if (this.compareRows(n7 - 1, n7, n, bl) > 0) {
                    this.swapRows(n7 - 1, n7);
                    n5 = n7;
                }
                --n7;
            }
            n3 = n5;
        }
        ((AbstractTableModel)this.model).fireTableDataChanged();
    }

    private void swapRows(int n, int n2) {
        Collocate collocate = this.collocates[n];
        this.collocates[n] = this.collocates[n2];
        this.collocates[n2] = collocate;
        int n3 = this.collIndex[n];
        this.collIndex[n] = this.collIndex[n2];
        this.collIndex[n2] = n3;
    }
}

