/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bham.clg.cue.qwick;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import uk.ac.bham.clg.cue.corpus.ConcordanceLine;
import uk.ac.bham.clg.cue.corpus.Concordances;
import uk.ac.bham.clg.cue.corpus.CorpusException;
import uk.ac.bham.clg.cue.corpus.Cue;
import uk.ac.bham.clg.cue.corpus.Item;
import uk.ac.bham.clg.cue.corpus.query.ParseError;
import uk.ac.bham.clg.cue.qwick.Progress;
import uk.ac.bham.clg.cue.qwick.Qwick;
import uk.ac.bham.clg.cue.qwick.SaveDialog;
import uk.ac.bham.clg.cue.qwick.ToolBar;
import uk.ac.bham.clg.cue.qwick.ToolbarTarget;
import uk.ac.bham.clg.extawt.ConcordanceList;
import uk.ac.bham.clg.extawt.ConcordanceModel;
import uk.ac.bham.clg.extawt.GUI;
import uk.ac.bham.clg.extawt.SwingWorker;
import uk.ac.bham.clg.extawt.Unicode;

class ConcordancePage
implements ToolbarTarget {
    static final boolean DEBUG = false;
    private JTextField statusLine = null;
    private Cue cue;
    private Qwick qwick;
    private final JButton queryButton = new JButton("NEW QUERY");
    private final JButton gotoButton = new JButton("GOTO");
    private final JButton searchButton = new JButton("SEARCH");
    private final JButton filterButton = new JButton("FILTER");
    private final JButton deleteButton = new JButton("DELETE");
    private final JButton sampleButton = new JButton("SAMPLE");
    private final JButton contextButton = new JButton("CONTEXT");
    private JFileChooser fileChooser = null;
    private ConcordanceList concList = null;
    int concNum = 0;
    int topLine = 0;
    private int fontSize = 12;
    private int listSize = 20;
    private Concordances queryResult = null;
    private ConcordanceModel model = null;

    public ConcordancePage(Qwick qwick, Cue cue, JPanel jPanel) {
        this.cue = cue;
        this.qwick = qwick;
        this.model = new ConcordanceModel(){
            private BitSet selected = new BitSet();
            int lastSelection = -1;

            public void clearSelection() {
                int n = 0;
                while (n < this.selected.size()) {
                    this.selected.clear(n);
                    ++n;
                }
                this.lastSelection = -1;
                ConcordancePage.this.contextButton.setEnabled(false);
                ConcordancePage.this.statusLine.setText(String.valueOf(ConcordancePage.this.concNum) + " lines available");
            }

            public int getLastSelection() {
                return this.lastSelection;
            }

            public ConcordanceLine getLine(int n) {
                if (ConcordancePage.this.queryResult == null) {
                    return null;
                }
                try {
                    ConcordanceLine concordanceLine = ConcordancePage.this.queryResult.getConcordanceLine(n, 150);
                    return concordanceLine;
                }
                catch (CorpusException corpusException) {
                    System.err.println(corpusException);
                    return null;
                }
            }

            public int getSize() {
                if (ConcordancePage.this.queryResult == null) {
                    return 0;
                }
                return ConcordancePage.this.queryResult.getSize();
            }

            public boolean isSelected(int n) {
                return this.selected.get(n);
            }

            public void setSelected(int n) {
                this.selected.set(n);
                this.lastSelection = n;
                ConcordancePage.this.contextButton.setEnabled(true);
                ConcordancePage.this.statusLine.setText(ConcordancePage.this.lineInfo(n));
            }

            public void unsetSelected(int n) {
                this.selected.clear(n);
                this.lastSelection = -1;
                ConcordancePage.this.contextButton.setEnabled(false);
                ConcordancePage.this.statusLine.setText(String.valueOf(ConcordancePage.this.concNum) + " lines available");
            }
        };
        jPanel.setLayout(new BorderLayout());
        jPanel.setFont(this.qwick.getFont());
        JPanel jPanel2 = new JPanel();
        this.queryButton.addActionListener(new ActionListener(){
            JDialog queryDialog = null;
            final JComboBox comboBox = new JComboBox();
            ActionListener doQuery;
            {
                this.doQuery = new ActionListener(ConcordancePage.this, this){
                    private final /* synthetic */ ConcordancePage this$0;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$0 = concordancePage;
                        this.this$1 = var2_2;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        ((Component)this.this$1.queryDialog).setVisible(false);
                        int n = this.this$1.comboBox.getSelectedIndex();
                        String string = (String)this.this$1.comboBox.getSelectedItem();
                        if (n < 0 && string != null) {
                            this.this$1.comboBox.insertItemAt(string, 0);
                            if (this.this$1.comboBox.getItemCount() > 5) {
                                this.this$1.comboBox.removeItemAt(5);
                            }
                        }
                        if (string != null) {
                            ConcordancePage.access$2(this.this$0).setText(string);
                            this.this$0.newQuery(string);
                        }
                    }
                };
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (this.queryDialog == null) {
                    this.init(ConcordancePage.this.qwick);
                }
                if (ConcordancePage.this.cue.getSize() == 0) {
                    JOptionPane.showMessageDialog(ConcordancePage.this.qwick, "Please select corpora first!", "Concordance Error", 0);
                    ConcordancePage.this.qwick.select(0);
                } else {
                    this.queryDialog.show();
                }
            }

            void init(Qwick qwick) {
                this.queryDialog = new JDialog((Frame)qwick, "Corpus Query");
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                JLabel jLabel = new JLabel("Please enter your query:");
                jPanel.add("North", jLabel);
                this.comboBox.setEditable(true);
                this.comboBox.setPreferredSize(new Dimension(100, 30));
                this.comboBox.addActionListener(this.doQuery);
                jPanel.add("Center", this.comboBox);
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new GridLayout(1, 3));
                JButton jButton = new JButton("OK");
                jPanel2.add(jButton);
                jButton.addActionListener(this.doQuery);
                jButton = new JButton("HELP");
                jPanel2.add(jButton);
                jButton.addActionListener(new ActionListener(ConcordancePage.this){
                    private final /* synthetic */ ConcordancePage this$0;
                    {
                        this.this$0 = concordancePage;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        ConcordancePage.access$4(this.this$0).help("queryLanguage.html");
                    }
                });
                jButton = new JButton("CANCEL");
                jPanel2.add(jButton);
                jButton.addActionListener(new ActionListener(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        ((Component)this.this$1.queryDialog).setVisible(false);
                    }
                });
                jPanel.add("South", jPanel2);
                JPanel jPanel3 = (JPanel)this.queryDialog.getContentPane();
                jPanel3.add("North", new JLabel(" "));
                jPanel3.add("South", new JLabel(" "));
                jPanel3.add("East", new JLabel(" "));
                jPanel3.add("West", new JLabel(" "));
                jPanel3.add("Center", jPanel);
                this.queryDialog.pack();
                ((Component)this.queryDialog).setBounds(GUI.centerWindow(this.queryDialog.getSize()));
            }
        });
        this.queryButton.setMnemonic('q');
        jPanel2.add(this.queryButton);
        this.gotoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                block3: {
                    String string = JOptionPane.showInputDialog(ConcordancePage.this.qwick, (Object)"Please enter the line you want to jump to");
                    if (string == null) break block3;
                    int n = -1;
                    try {
                        n = Integer.parseInt(string);
                        if (n > 0 && n <= ConcordancePage.this.queryResult.getSize()) {
                            ConcordancePage.this.concList.display(n - 1);
                            break block3;
                        }
                        JOptionPane.showMessageDialog(ConcordancePage.this.qwick, "Go To: " + n + "\nLine out of valid range (1-" + ConcordancePage.this.queryResult.getSize() + ")", "Range Error", 0);
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showMessageDialog(ConcordancePage.this.qwick, "Not a valid number: " + string, "Number Error", 0);
                    }
                }
            }
        });
        this.gotoButton.setMnemonic('g');
        jPanel2.add(this.gotoButton);
        this.searchButton.addActionListener(new ActionListener(){
            JDialog searchDialog = null;
            JTextField searchField = new JTextField(10);
            Qwick parent = null;

            public void actionPerformed(ActionEvent actionEvent) {
                if (this.searchDialog == null) {
                    this.init(ConcordancePage.this.qwick);
                }
                if (ConcordancePage.this.queryResult == null) {
                    JOptionPane.showMessageDialog(ConcordancePage.this.qwick, "Please retrieve data first!", "Search Error", 0);
                } else {
                    JDialog jDialog = this.searchDialog;
                    SwingUtilities.invokeLater(new Runnable(jDialog){
                        private final /* synthetic */ JDialog val$dummy;
                        {
                            this.val$dummy = jDialog;
                        }

                        public void run() {
                            this.val$dummy.show();
                        }
                    });
                }
            }

            void init(Qwick qwick) {
                ActionListener actionListener = new ActionListener(ConcordancePage.this, this){
                    private final /* synthetic */ ConcordancePage this$0;
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$0 = concordancePage;
                        this.this$1 = var2_2;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = this.this$1.searchField.getText();
                        if (!"".equals(string)) {
                            this.this$0.search(string);
                        }
                    }
                };
                this.parent = qwick;
                this.searchDialog = new JDialog(qwick);
                Box box = Box.createVerticalBox();
                JLabel jLabel = new JLabel("Please enter the word to search for:", 0);
                jLabel.setAlignmentX(0.5f);
                box.add(jLabel);
                this.searchField.setPreferredSize(new Dimension(100, 30));
                this.searchField.addActionListener(actionListener);
                this.searchField.addKeyListener(((ConcordancePage)ConcordancePage.this).qwick.numberAdapter);
                box.add(this.searchField);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new GridLayout(1, 3));
                JButton jButton = new JButton("SEARCH");
                jPanel.add(jButton);
                jButton.addActionListener(actionListener);
                jButton = new JButton("CLEAR");
                jPanel.add(jButton);
                jButton.addActionListener(new ActionListener(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.this$1.searchField.setText("");
                    }
                });
                jButton = new JButton("CLOSE");
                jPanel.add(jButton);
                jButton.addActionListener(new ActionListener(ConcordancePage.this, this){
                    private final /* synthetic */ ConcordancePage this$0;
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$0 = concordancePage;
                        this.this$1 = var2_2;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        ((Component)this.this$1.searchDialog).setVisible(false);
                        ConcordancePage.access$4(this.this$0).resetCursor();
                    }
                });
                box.add(jPanel);
                JPanel jPanel2 = (JPanel)this.searchDialog.getContentPane();
                jPanel2.add("North", new JLabel(" "));
                jPanel2.add("South", new JLabel(" "));
                jPanel2.add("East", new JLabel(" "));
                jPanel2.add("West", new JLabel(" "));
                jPanel2.add("Center", box);
                this.searchDialog.pack();
                ((Component)this.searchDialog).setBounds(GUI.centerWindow(this.searchDialog.getSize()));
            }
        });
        this.searchButton.setMnemonic('s');
        jPanel2.add(this.searchButton);
        this.contextButton.setMnemonic('c');
        this.contextButton.setEnabled(false);
        this.contextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConcordancePage.this.showContext();
            }
        });
        jPanel2.add(this.contextButton);
        this.sampleButton.setMnemonic('a');
        this.sampleButton.addActionListener(new ActionListener(){
            JDialog sampleDialog = null;
            JTextField targetSize = new JTextField(10);
            Qwick parent = null;

            public void actionPerformed(ActionEvent actionEvent) {
                if (this.sampleDialog == null) {
                    this.init(ConcordancePage.this.qwick);
                }
                if (ConcordancePage.this.queryResult == null) {
                    JOptionPane.showMessageDialog(ConcordancePage.this.qwick, "Please retrieve data first!", "Search Error", 0);
                } else {
                    this.targetSize.setText("");
                    this.sampleDialog.show();
                }
            }

            void init(Qwick qwick) {
                this.parent = qwick;
                JRadioButton jRadioButton = new JRadioButton("every Nth sampling");
                JRadioButton jRadioButton2 = new JRadioButton("random sampling");
                ActionListener actionListener = new ActionListener(jRadioButton, ConcordancePage.this, this){
                    private final /* synthetic */ JRadioButton val$nthBox;
                    private final /* synthetic */ ConcordancePage this$0;
                    private final /* synthetic */ 13 this$1;
                    {
                        this.val$nthBox = jRadioButton;
                        this.this$0 = concordancePage;
                        this.this$1 = var3_3;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        ((Component)this.this$1.sampleDialog).setVisible(false);
                        try {
                            int n = Integer.parseInt(this.this$1.targetSize.getText());
                            if (n < 0 || n >= ConcordancePage.access$0(this.this$0).getSize()) {
                                JOptionPane.showMessageDialog(ConcordancePage.access$4(this.this$0), "Value out of range: " + this.this$1.targetSize.getText(), "Sample Error", 0);
                            } else {
                                this.this$0.sample(n, this.val$nthBox.isSelected());
                                this.this$1.sampleDialog.dispose();
                                this.this$1.sampleDialog = null;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            JOptionPane.showMessageDialog(ConcordancePage.access$4(this.this$0), "Not a valid number: " + this.this$1.targetSize.getText(), "Sample Error", 0);
                        }
                    }
                };
                this.sampleDialog = new JDialog(qwick);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                Box box = Box.createVerticalBox();
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(jRadioButton);
                buttonGroup.add(jRadioButton2);
                jRadioButton.setSelected(true);
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new GridLayout(2, 1));
                jPanel2.add(jRadioButton);
                jPanel2.add(jRadioButton2);
                TitledBorder titledBorder = BorderFactory.createTitledBorder("Reduce Lines by");
                jPanel2.setBorder(titledBorder);
                box.add(jPanel2);
                JPanel jPanel3 = new JPanel();
                jPanel3.add(new JLabel("from a total of " + ConcordancePage.this.queryResult.getSize() + " down to "));
                this.targetSize.setPreferredSize(new Dimension(100, 30));
                this.targetSize.addActionListener(actionListener);
                jPanel3.add(this.targetSize);
                box.add(jPanel3);
                jPanel.add("Center", box);
                jPanel2 = new JPanel();
                jPanel2.setLayout(new GridLayout(1, 3));
                JButton jButton = new JButton("OK");
                jPanel2.add(jButton);
                jButton.addActionListener(actionListener);
                jButton = new JButton("HELP");
                jPanel2.add(jButton);
                jButton.addActionListener(new ActionListener(ConcordancePage.this){
                    private final /* synthetic */ ConcordancePage this$0;
                    {
                        this.this$0 = concordancePage;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        ConcordancePage.access$4(this.this$0).help("sampleDialog.html");
                    }
                });
                jButton = new JButton("CANCEL");
                jPanel2.add(jButton);
                jButton.addActionListener(new ActionListener(this){
                    private final /* synthetic */ 13 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        ((Component)this.this$1.sampleDialog).setVisible(false);
                        this.this$1.sampleDialog.dispose();
                        this.this$1.sampleDialog = null;
                    }
                });
                JPanel jPanel4 = (JPanel)this.sampleDialog.getContentPane();
                jPanel4.add("North", new JLabel(" "));
                jPanel4.add("South", jPanel2);
                jPanel4.add("East", new JLabel(" "));
                jPanel4.add("West", new JLabel(" "));
                jPanel4.add("Center", box);
                this.sampleDialog.pack();
                ((Component)this.sampleDialog).setBounds(GUI.centerWindow(this.sampleDialog.getSize()));
            }
        });
        jPanel2.add(this.sampleButton);
        this.filterButton.setMnemonic('f');
        this.filterButton.addActionListener(new ActionListener(){
            JDialog filterDialog = null;
            JTextField filterField = new JTextField(10);
            Qwick parent = null;

            public void actionPerformed(ActionEvent actionEvent) {
                if (this.filterDialog == null) {
                    this.init(ConcordancePage.this.qwick);
                }
                if (ConcordancePage.this.queryResult == null) {
                    JOptionPane.showMessageDialog(ConcordancePage.this.qwick, "Please retrieve data first!", "Search Error", 0);
                } else {
                    this.filterField.setText("");
                    this.filterDialog.show();
                }
            }

            void init(Qwick qwick) {
                this.parent = qwick;
                JRadioButton jRadioButton = new JRadioButton("do contain");
                JRadioButton jRadioButton2 = new JRadioButton("do not contain");
                ActionListener actionListener = new ActionListener(jRadioButton, ConcordancePage.this, this){
                    private final /* synthetic */ ConcordancePage this$0;
                    private final /* synthetic */ JRadioButton val$doBox;
                    private final /* synthetic */ 17 this$1;
                    {
                        this.val$doBox = jRadioButton;
                        this.this$0 = concordancePage;
                        this.this$1 = var3_3;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        ((Component)this.this$1.filterDialog).setVisible(false);
                        String string = this.this$1.filterField.getText();
                        if (!"".equals(string)) {
                            this.this$0.filter(string, this.val$doBox.isSelected());
                        }
                    }
                };
                this.filterDialog = new JDialog(qwick);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                Box box = Box.createVerticalBox();
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(jRadioButton);
                buttonGroup.add(jRadioButton2);
                jRadioButton.setSelected(true);
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new GridLayout(2, 1));
                jPanel2.add(jRadioButton);
                jPanel2.add(jRadioButton2);
                TitledBorder titledBorder = BorderFactory.createTitledBorder("Remove Lines that");
                jPanel2.setBorder(titledBorder);
                box.add(jPanel2);
                JLabel jLabel = new JLabel("the word");
                jLabel.setHorizontalAlignment(2);
                jLabel.setAlignmentX(0.0f);
                box.add(jLabel);
                this.filterField.setPreferredSize(new Dimension(100, 30));
                this.filterField.addActionListener(actionListener);
                this.filterField.addKeyListener(((ConcordancePage)ConcordancePage.this).qwick.numberAdapter);
                box.add(this.filterField);
                jPanel.add("Center", box);
                jPanel2 = new JPanel();
                jPanel2.setLayout(new GridLayout(1, 3));
                JButton jButton = new JButton("OK");
                jPanel2.add(jButton);
                jButton.addActionListener(actionListener);
                jButton = new JButton("HELP");
                jPanel2.add(jButton);
                jButton.addActionListener(new ActionListener(ConcordancePage.this){
                    private final /* synthetic */ ConcordancePage this$0;
                    {
                        this.this$0 = concordancePage;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        ConcordancePage.access$4(this.this$0).help("filterDialog.html");
                    }
                });
                jButton = new JButton("CANCEL");
                jPanel2.add(jButton);
                jButton.addActionListener(new ActionListener(this){
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        ((Component)this.this$1.filterDialog).setVisible(false);
                    }
                });
                JPanel jPanel3 = (JPanel)this.filterDialog.getContentPane();
                jPanel3.add("North", new JLabel(" "));
                jPanel3.add("South", jPanel2);
                jPanel3.add("East", new JLabel(" "));
                jPanel3.add("West", new JLabel(" "));
                jPanel3.add("Center", box);
                this.filterDialog.pack();
                ((Component)this.filterDialog).setBounds(GUI.centerWindow(this.filterDialog.getSize()));
            }
        });
        jPanel2.add(this.filterButton);
        this.deleteButton.setMnemonic('d');
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConcordancePage.this.deleteLines();
            }
        });
        jPanel2.add(this.deleteButton);
        jPanel.add("North", jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBackground(Color.white);
        this.concList = new ConcordanceList(this.model);
        jPanel2.add("Center", this.concList);
        jPanel.add("Center", jPanel2);
        jPanel2 = new JPanel();
        this.statusLine = new JTextField(40);
        this.statusLine.setEditable(false);
        this.statusLine.setHorizontalAlignment(0);
        jPanel2.add(this.statusLine);
        jPanel.add("South", jPanel2);
    }

    public void bottom() {
        if (this.topLine != this.concNum - this.concList.getRows()) {
            this.topLine = this.concNum - this.concList.getRows();
            this.concList.display(this.topLine);
        }
    }

    public void deleteLines() {
        int n = 0;
        Concordances concordances = this.queryResult;
        synchronized (concordances) {
            int n2 = this.model.getSize();
            while (n2 >= 0) {
                if (this.model.isSelected(n2)) {
                    this.queryResult.delete(n2);
                    this.concList.delItem(n2);
                    ++n;
                }
                --n2;
            }
        }
        this.concNum = this.queryResult.getSize();
        if (n == 0) {
            JOptionPane.showMessageDialog(this.qwick, "Please select the line to delete first!", "Deletion Error", 0);
        } else {
            this.model.clearSelection();
        }
        this.statusLine.setText(String.valueOf(this.concNum) + " lines available");
    }

    private String escISO(String string) {
        String string2 = string;
        int n = 0;
        while (n >= 0) {
            if ((n = string2.indexOf("&", n)) <= -1) continue;
            string2 = this.replaceSubstring(string2, "&", "&amp;", n);
            ++n;
        }
        while (string2.indexOf(60) >= 0) {
            string2 = this.replaceSubstring(string2, "<", "&lt;", 0);
        }
        while (string2.indexOf(62) >= 0) {
            string2 = this.replaceSubstring(string2, ">", "&gt;", 0);
        }
        string2 = Unicode.replace(string2);
        return string2;
    }

    public void export(PrintWriter printWriter, int n) {
        if (this.queryResult != null) {
            Concordances concordances = this.queryResult;
            synchronized (concordances) {
                int n2 = this.queryResult.getSize();
                int n3 = 0;
                while (n3 < n2) {
                    try {
                        ConcordanceLine concordanceLine = this.queryResult.getConcordanceLine(n3, n);
                        printWriter.println(concordanceLine);
                    }
                    catch (CorpusException corpusException) {
                        printWriter.println("Error: " + corpusException);
                    }
                    ++n3;
                }
            }
        }
    }

    public void filter(String string, boolean bl) {
        final String string2 = String.valueOf(' ') + string + ' ';
        final boolean bl2 = bl;
        if (this.queryResult == null) {
            JOptionPane.showMessageDialog(this.qwick, "Please retrieve data first!", "Filter Error", 0);
        } else {
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    qwick.waitCursor();
                    ProgressMonitor progressMonitor = new ProgressMonitor(qwick, "Filtering " + queryResult.getSize() + " lines", "", 0, queryResult.getSize());
                    topLine = 0;
                    int n = 0;
                    int n2 = 0;
                    Concordances concordances = queryResult;
                    synchronized (concordances) {
                        while (n < queryResult.getSize() && !progressMonitor.isCanceled()) {
                            boolean bl;
                            progressMonitor.setProgress(n2++);
                            String string = queryResult.getKwic(n, 80);
                            boolean bl22 = bl = string.indexOf(string2) >= 0;
                            if (bl2 == bl) {
                                queryResult.delete(n);
                                continue;
                            }
                            ++n;
                        }
                    }
                    progressMonitor.close();
                    qwick.resetCursor();
                    concNum = queryResult.getSize();
                    statusLine.setText(String.valueOf(concNum) + " lines available");
                    concList.display(topLine);
                    return this;
                }
            };
        }
    }

    public void help() {
        this.qwick.help("concordancePage.html");
    }

    public void init(ToolBar toolBar) {
        if (this.queryResult == null) {
            this.queryButton.setForeground(Color.red);
            this.gotoButton.setEnabled(false);
            this.searchButton.setEnabled(false);
            this.filterButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.sampleButton.setEnabled(false);
            this.contextButton.setEnabled(false);
            toolBar.reset();
            toolBar.noPrint();
            toolBar.noSave();
            toolBar.noSort();
        } else {
            toolBar.reset();
            this.queryButton.setForeground(Color.black);
            this.gotoButton.setEnabled(true);
            this.searchButton.setEnabled(true);
            this.filterButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
            this.sampleButton.setEnabled(true);
            this.contextButton.setEnabled(true);
        }
    }

    private String lineInfo(int n) {
        Item item = this.queryResult.getItem(n);
        if (item == null) {
            return "no information on that line available";
        }
        return String.valueOf(item.getCorpus().getLabel()) + ", position " + item.getOffset();
    }

    public void load() throws IOException {
        if (this.fileChooser == null) {
            this.fileChooser = this.qwick.getFileChooser();
        }
        this.fileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".cnc") || file.isDirectory();
            }

            public String getDescription() {
                return "Concordance Files (machine readable)";
            }
        });
        this.fileChooser.rescanCurrentDirectory();
        int n = this.fileChooser.showOpenDialog(this.qwick);
        if (n == 0) {
            this.qwick.waitCursor();
            File file = this.fileChooser.getSelectedFile();
            ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            this.queryResult = new Concordances(this.cue, objectInputStream);
            objectInputStream.close();
            this.concNum = this.queryResult.getSize();
            this.statusLine.setText(String.valueOf(this.concNum) + " lines available");
            this.qwick.resetCursor();
            this.topLine = 0;
            this.concList.display(this.topLine);
            this.qwick.setWorkingSet(this.queryResult);
        }
    }

    protected void newQuery(String string) {
        if ("".equals(string)) {
            return;
        }
        this.qwick.waitCursor();
        Progress progress = new Progress(this.qwick);
        try {
            Object object;
            final Enumeration enumeration = this.cue.query(string, null);
            this.queryResult = new Concordances();
            this.concList.display(0);
            this.listSize = this.concList.getRows();
            if (enumeration == null || !enumeration.hasMoreElements()) {
                this.qwick.resetCursor();
                this.queryResult = null;
                JOptionPane.showMessageDialog(this.qwick, "No hits found", "Query Result", 1);
                return;
            }
            this.model.clearSelection();
            int n = 0;
            while (n < this.listSize) {
                object = this.queryResult;
                synchronized (object) {
                    Item item;
                    ConcordanceLine concordanceLine;
                    if (enumeration.hasMoreElements() && (concordanceLine = new ConcordanceLine(item = (Item)enumeration.nextElement(), 150)) != null) {
                        this.concList.setLine(n, concordanceLine.getLeftContext(), concordanceLine.getNodeWord(), concordanceLine.getRightContext(), false);
                        this.queryResult.add(item);
                    }
                }
                ++n;
            }
            this.init(this.qwick.getToolbar());
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    Concordances concordances = queryResult;
                    synchronized (concordances) {
                        queryResult.fill(enumeration);
                        queryResult.convert();
                        concNum = queryResult.getSize();
                        qwick.setWorkingSet(queryResult);
                        statusLine.setText(String.valueOf(concNum) + " lines available");
                        topLine = 0;
                        concList.display(0);
                        System.gc();
                    }
                    return this;
                }
            };
            this.qwick.waitCursor();
            object = swingWorker.get();
            this.qwick.resetCursor();
        }
        catch (ParseError parseError) {
            this.qwick.resetCursor();
            JOptionPane.showMessageDialog(this.qwick, "Query: " + parseError, "Parse Error", 0);
        }
        catch (CorpusException corpusException) {
            this.qwick.resetCursor();
            JOptionPane.showMessageDialog(this.qwick, "Corpus Access: " + corpusException, "Corpus Error", 0);
        }
    }

    public void print() {
        PrintJob printJob;
        final int n = 0;
        final int n2 = this.queryResult.getSize() - 1;
        boolean bl = false;
        if (!bl && (printJob = this.qwick.getToolkit().getPrintJob(this.qwick, "Print Concordance Lines", null)) != null) {
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    try {
                        Concordances concordances = queryResult;
                        synchronized (concordances) {
                            this.printLines(printJob, n, n2);
                        }
                    }
                    catch (CorpusException corpusException) {
                        System.err.println(corpusException);
                    }
                    return this;
                }
            };
        }
    }

    public void printLines(PrintJob printJob, int n, int n2) throws CorpusException {
        Dimension dimension = printJob.getPageDimension();
        System.err.println(String.valueOf(dimension.width) + "x" + dimension.height);
        boolean bl = dimension.width > dimension.height;
        Graphics graphics = printJob.getGraphics();
        if (graphics == null) {
            throw new CorpusException("Cannot get Graphics Context for printing");
        }
        graphics.setFont(new Font("Times", 0, 10));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.charWidth(' ');
        int n4 = (int)(1.01 * (double)fontMetrics.getMaxAscent() + (double)fontMetrics.getMaxDescent());
        graphics.setClip(40, 40, dimension.width - 80, dimension.height - 40);
        graphics.translate(40, 40);
        int n5 = (dimension.height - 80) / n4 - 7;
        int n6 = (n2 - n) / n5 + 1;
        Rectangle rectangle = graphics.getClipBounds();
        graphics.translate(rectangle.x, rectangle.y);
        int n7 = rectangle.width / 2;
        int n8 = n;
        String string = " " + n2 + "   ";
        JDialog jDialog = new JDialog(this.qwick, "Printing", false);
        JProgressBar jProgressBar = new JProgressBar(n, n2);
        jProgressBar.setValue(n);
        jProgressBar.setStringPainted(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add("North", new JLabel("Printing " + n6 + " pages\nPlease wait."));
        jPanel.add("Center", jProgressBar);
        jDialog.getContentPane().add(jPanel);
        jDialog.pack();
        ((Component)jDialog).setBounds(GUI.centerWindow(jDialog.getSize()));
        jDialog.show();
        while (!jDialog.isShowing()) {
        }
        int n9 = 1;
        while (n9 <= n6) {
            if (n9 > 1) {
                graphics.dispose();
                graphics = printJob.getGraphics();
                if (graphics == null) {
                    throw new CorpusException("Cannot get Graphics Context for printing");
                }
                graphics.setFont(new Font("Times", 0, 10));
                graphics.setClip(40, 40, dimension.width - 40, dimension.height - 40);
                graphics.translate(40, 40);
                graphics.translate(rectangle.x, rectangle.y);
            }
            graphics.drawString("QWICK v1.0 Concordance Display, pg." + n9 + "/" + n6, 100, 2 * n4);
            System.err.println("QWICK v1.0 Concordance Display, pg." + n9 + "/" + n6);
            int n10 = 0;
            while (n10 < n5) {
                if (n8 > n2) break;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                int n11 = (n10 + 4) * n4;
                boolean bl2 = this.model.isSelected(n8);
                ConcordanceLine concordanceLine = this.queryResult.getConcordanceLine(n8, 500);
                if (concordanceLine != null) {
                    string2 = concordanceLine.getLeftContext();
                    string4 = concordanceLine.getRightContext();
                    string3 = concordanceLine.getNodeWord();
                }
                if (bl2) {
                    graphics.setColor(Color.yellow);
                } else {
                    graphics.setColor(Color.white);
                }
                graphics.fillRect(0, n11 - n4, n7 * 2, n4);
                if (string3 != null) {
                    int n12 = n11 - fontMetrics.getMaxDescent();
                    int n13 = n7 - n3 - fontMetrics.stringWidth(string3) / 2;
                    int n14 = n13 - fontMetrics.stringWidth(string2) - n3;
                    int n15 = n13 + fontMetrics.stringWidth(string3);
                    graphics.setColor(Color.black);
                    graphics.drawString(string2, n14, n12);
                    graphics.drawString(string4, n15, n12);
                    graphics.drawString(string3, n13, n12);
                    if (bl2) {
                        graphics.setColor(Color.yellow);
                    } else {
                        graphics.setColor(Color.white);
                    }
                    graphics.fillRect(0, n11 - n4, fontMetrics.stringWidth(string), n4);
                    graphics.setColor(Color.blue);
                    String string5 = " " + (n8 + 1) + "   ";
                    graphics.drawString(string5, fontMetrics.stringWidth(string) - fontMetrics.stringWidth(string5), n12);
                    graphics.setColor(Color.black);
                }
                jProgressBar.setValue(++n8);
                ++n10;
            }
            ++n9;
        }
        graphics.dispose();
        jDialog.dispose();
    }

    private String replaceSubstring(String string, String string2, String string3, int n) {
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(string2, n);
        if (n2 < 0) {
            return string;
        }
        string = String.valueOf(string.substring(0, n2)) + string3 + string.substring(n2 + string2.length());
        return string;
    }

    public void sample(int n, boolean bl) {
        boolean bl2;
        int n2;
        int n3;
        int n4 = this.queryResult.getSize();
        if (n >= n4) {
            return;
        }
        this.qwick.waitCursor();
        BitSet bitSet = new BitSet(n4);
        if (bl) {
            int n5 = 0;
            n3 = n4 / n;
            n2 = 0;
            while (n2 < n) {
                bl2 = false;
                do {
                    if (!bitSet.get(n5)) {
                        bitSet.set(n5);
                        bl2 = true;
                    }
                    if ((n5 += n3) < n4) continue;
                    n5 -= n4;
                } while (!bl2);
                ++n2;
            }
        } else {
            Random random = new Random();
            n3 = 0;
            n2 = 0;
            while (n2 < n) {
                bl2 = false;
                do {
                    if ((n3 = (int)((double)n3 + Math.abs(random.nextGaussian() * (double)n4))) >= n4) {
                        n3 -= n4;
                    }
                    if (bitSet.get(n3)) continue;
                    bitSet.set(n3);
                    bl2 = true;
                } while (!bl2);
                ++n2;
            }
        }
        int n6 = n4;
        while (n6 >= 0) {
            if (!bitSet.get(n6)) {
                this.queryResult.delete(n6);
            }
            --n6;
        }
        this.concNum = this.queryResult.getSize();
        this.statusLine.setText(String.valueOf(this.concNum) + " lines available");
        this.qwick.resetCursor();
        this.topLine = 0;
        this.concList.display(this.topLine);
    }

    public void save() throws IOException {
        int n = 80;
        SaveDialog saveDialog = this.qwick.getSaveDialog();
        int n2 = saveDialog.showDialog("Save Concordancelines", ".cnc");
        if (n2 == 0) {
            int n3 = saveDialog.getFormat();
            String string = saveDialog.getFilename();
            switch (n3) {
                case 0: {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
                    bufferedWriter.write("<html>\n<center>\n");
                    int n4 = this.queryResult.getSize();
                    int n5 = 0;
                    while (n5 < n4) {
                        ConcordanceLine concordanceLine;
                        try {
                            concordanceLine = this.queryResult.getConcordanceLine(n5, n);
                        }
                        catch (CorpusException corpusException) {
                            throw new IOException(String.valueOf(String.valueOf(corpusException)));
                        }
                        bufferedWriter.write("<tt>|" + concordanceLine.getLeftContext() + " <b>" + concordanceLine.getNodeWord() + "</b> " + concordanceLine.getRightContext() + "|</tt><br>\n");
                        ++n5;
                    }
                    bufferedWriter.write("</center>\n</html>");
                    bufferedWriter.close();
                    break;
                }
                case 1: {
                    PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
                    this.export(printWriter, n);
                    printWriter.close();
                    break;
                }
                case 2: {
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
                    this.queryResult.save(objectOutputStream);
                    objectOutputStream.close();
                    break;
                }
            }
        }
    }

    public void search(String string) {
        if (this.queryResult == null) {
            JOptionPane.showMessageDialog(this.qwick, "Please retrieve data first!", "Search Error", 0);
        } else {
            String string2 = String.valueOf(' ') + string + ' ';
            this.qwick.waitCursor();
            Concordances concordances = this.queryResult;
            synchronized (concordances) {
                boolean bl = false;
                while (!bl && this.topLine < this.queryResult.getSize() - 1) {
                    ++this.topLine;
                    String string3 = this.queryResult.getKwic(this.topLine, 150);
                    if (string3 == null) break;
                    if (string3.indexOf(string2) < 0) continue;
                    bl = true;
                }
                this.qwick.resetCursor();
                if (!bl) {
                    JOptionPane.showMessageDialog(this.qwick, "No (more) occurrences found.\nReturning to top of list.", "Search Result", 0);
                    this.topLine = 0;
                }
                this.concList.display(this.topLine);
            }
        }
    }

    public void setFontSize(int n) {
        Font font = new Font("Times", 0, n);
        if (font != null) {
            this.fontSize = n;
            this.concList.setFont(font);
        }
    }

    public void showContext() {
        int n = this.model.getLastSelection();
        if (n == -1) {
            JOptionPane.showMessageDialog(this.qwick, "Please select a line first!", "Selection Error", 0);
        } else {
            Component component;
            final JDialog jDialog = new JDialog(this.qwick, "Extended Context", true);
            JEditorPane jEditorPane = new JEditorPane();
            jEditorPane.setEditable(false);
            jEditorPane.setContentType("text/html");
            try {
                component = this.queryResult.getConcordanceLine(n, 550);
                jEditorPane.setText(String.valueOf(this.escISO(((ConcordanceLine)component).getLeftContext())) + " <b>" + this.escISO(((ConcordanceLine)component).getNodeWord()) + "</b> " + this.escISO(((ConcordanceLine)component).getRightContext()));
            }
            catch (CorpusException corpusException) {
                jEditorPane.setText("<h1>Internal Error</h1><hr>" + corpusException);
            }
            jEditorPane.setPreferredSize(new Dimension(400, 200));
            component = new JScrollPane(jEditorPane);
            ((JComponent)component).setPreferredSize(new Dimension(400, 200));
            jDialog.getContentPane().add("Center", component);
            JButton jButton = new JButton("Close Context Window");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((Component)jDialog).setVisible(false);
                    jDialog.dispose();
                }
            });
            jDialog.getContentPane().add("South", jButton);
            jDialog.pack();
            ((Component)jDialog).setBounds(GUI.centerWindow(jDialog.getSize()));
            jDialog.show();
        }
    }

    public void sort() {
        final JDialog jDialog = new JDialog(this.qwick, "Sorting Concordance Lines", true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JRadioButton jRadioButton = new JRadioButton("right");
        jRadioButton.setMnemonic('r');
        jRadioButton.setSelected(true);
        jRadioButton.setActionCommand("sortRight");
        final JRadioButton jRadioButton2 = new JRadioButton("left");
        jRadioButton2.setMnemonic('l');
        jRadioButton2.setActionCommand("sortLeft");
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        jRadioButton.setAlignmentX(0.5f);
        jRadioButton2.setAlignmentX(0.5f);
        jPanel2.add("North", jRadioButton);
        jPanel2.add("South", jRadioButton2);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Sort Direction");
        jPanel2.setBorder(titledBorder);
        jPanel.add("Center", jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(new JLabel("relative position:"));
        final JTextField jTextField = new JTextField(5);
        jTextField.setText("1");
        jTextField.addKeyListener(this.qwick.numberAdapter);
        jTextField.setPreferredSize(new Dimension(10, 30));
        jTextField.setHorizontalAlignment(4);
        jPanel3.add(jTextField);
        jPanel3.setAlignmentX(0.5f);
        jPanel.add("South", jPanel3);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = jTextField.getText();
                try {
                    int n = Integer.parseInt(string);
                    if (jRadioButton2.isSelected()) {
                        n = -n;
                    }
                    int n2 = n;
                    ((Component)jDialog).setVisible(false);
                    qwick.waitCursor();
                    this.sort(n2);
                    qwick.resetCursor();
                    jDialog.dispose();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(qwick, "Not a valid number: " + string, "Sort Error", 0);
                }
            }
        };
        jTextField.addActionListener(actionListener);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout());
        JButton jButton = new JButton("OK");
        jButton.addActionListener(actionListener);
        jPanel3.add(jButton);
        JButton jButton2 = new JButton("CANCEL");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jPanel3.add(jButton2);
        jDialog.getContentPane().add("North", new JLabel(" "));
        jDialog.getContentPane().add("West", new JLabel(" "));
        jDialog.getContentPane().add("East", new JLabel(" "));
        jDialog.getContentPane().add("South", jPanel3);
        jDialog.getContentPane().add("Center", jPanel);
        jDialog.pack();
        ((Component)jDialog).setBounds(GUI.centerWindow(jDialog.getSize()));
        jDialog.show();
    }

    public void sort(int n) {
        this.qwick.waitCursor();
        this.model.clearSelection();
        final int n2 = n;
        final Progress progress = new Progress(this.qwick);
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                qwick.waitCursor();
                queryResult.sort(n2, progress);
                concList.display(0);
                qwick.resetCursor();
                return this;
            }
        };
        this.qwick.resetCursor();
    }

    public void top() {
        this.topLine = 0;
        this.concList.display(this.topLine);
    }
}

